/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadsignsmod.client.util;

import com.mojang.blaze3d.platform.NativeImage;
import de.sarocesch.sarosroadsignsmod.SarosRoadSignsModMod;
import de.sarocesch.sarosroadsignsmod.packs.PackManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class DynamicTextureUtil {
    private static final Map<String, ResourceLocation> CACHE = new HashMap<String, ResourceLocation>();

    private static void dbg(String msg) {
        if (PackManager.isDebugEnabled()) {
            SarosRoadSignsModMod.LOGGER.info("[SRS][DynTex] " + msg);
        }
    }

    private static ResourceLocation registerFileTexture(String key, File file) throws IOException {
        if (CACHE.containsKey(key)) {
            return CACHE.get(key);
        }
        try (FileInputStream fis = new FileInputStream(file);){
            NativeImage img = NativeImage.m_85058_((InputStream)fis);
            DynamicTexture dt = new DynamicTexture(img);
            ResourceLocation rl = new ResourceLocation("saros_road_signs_mod", "dynamic/files/" + Integer.toHexString(key.hashCode()));
            Minecraft.m_91087_().m_91097_().m_118495_(rl, (AbstractTexture)dt);
            CACHE.put(key, rl);
            ResourceLocation resourceLocation = rl;
            return resourceLocation;
        }
    }

    public static ResourceLocation getButtonAtlas(String key, File file, int size) {
        ResourceLocation resourceLocation;
        long ver;
        String fileKey = file == null ? "null" : file.getAbsolutePath().replace('\\', '/');
        String cacheKey = "button/" + fileKey + "|" + (ver = file != null && file.exists() ? file.lastModified() ^ file.length() << 7 : -1L) + "|" + size;
        if (CACHE.containsKey(cacheKey)) {
            return CACHE.get(cacheKey);
        }
        if (file == null || !file.exists() || !file.isFile()) {
            if (PackManager.isDebugEnabled()) {
                SarosRoadSignsModMod.LOGGER.warn("[SRS][DynTex] Button atlas source missing: {}", (Object)fileKey);
            }
            return new ResourceLocation("saros_road_signs_mod", "textures/triangle0.png");
        }
        FileInputStream fis = new FileInputStream(file);
        try {
            int x;
            int y;
            NativeImage src = NativeImage.m_85058_((InputStream)fis);
            NativeImage scaled = new NativeImage(size, size, false);
            for (int y2 = 0; y2 < size; ++y2) {
                for (int x2 = 0; x2 < size; ++x2) {
                    int sx = x2 * Math.max(1, src.m_84982_()) / size;
                    int sy = y2 * Math.max(1, src.m_85084_()) / size;
                    scaled.m_84988_(x2, y2, src.m_84985_(sx, sy));
                }
            }
            NativeImage atlas = new NativeImage(size, size * 2, false);
            for (y = 0; y < size; ++y) {
                for (x = 0; x < size; ++x) {
                    atlas.m_84988_(x, y, scaled.m_84985_(x, y));
                }
            }
            for (y = 0; y < size; ++y) {
                for (x = 0; x < size; ++x) {
                    int argb = scaled.m_84985_(x, y);
                    int a = argb >>> 24 & 0xFF;
                    int r = argb >>> 16 & 0xFF;
                    int g = argb >>> 8 & 0xFF;
                    int b = argb & 0xFF;
                    r = (int)((double)r * 0.7);
                    g = (int)((double)g * 0.7);
                    b = (int)((double)b * 0.7);
                    int dim = a << 24 | r << 16 | g << 8 | b;
                    atlas.m_84988_(x, y + size, dim);
                }
            }
            DynamicTexture dt = new DynamicTexture(atlas);
            ResourceLocation rl = new ResourceLocation("saros_road_signs_mod", "dynamic/pack_button/" + Integer.toHexString(cacheKey.hashCode()));
            Minecraft.m_91087_().m_91097_().m_118495_(rl, (AbstractTexture)dt);
            CACHE.put(cacheKey, rl);
            if (PackManager.isDebugEnabled()) {
                SarosRoadSignsModMod.LOGGER.info("[SRS][DynTex] Button atlas loaded: {} ({}x{}) -> {}", (Object)fileKey, (Object)size, (Object)size, (Object)rl);
            }
            resourceLocation = rl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                if (PackManager.isDebugEnabled()) {
                    SarosRoadSignsModMod.LOGGER.warn("[SRS][DynTex] Failed to load {}: {}", (Object)fileKey, (Object)e.toString());
                }
                return new ResourceLocation("saros_road_signs_mod", "textures/triangle0.png");
            }
        }
        fis.close();
        return resourceLocation;
    }

    public static ResourceLocation getTexture(File file) {
        ResourceLocation resourceLocation;
        long ver;
        String fileKey = file == null ? "null" : file.getAbsolutePath().replace('\\', '/');
        String cacheKey = "tex/" + fileKey + "|" + (ver = file != null && file.exists() ? file.lastModified() ^ file.length() << 7 : -1L);
        if (CACHE.containsKey(cacheKey)) {
            return CACHE.get(cacheKey);
        }
        if (file == null || !file.exists() || !file.isFile()) {
            if (PackManager.isDebugEnabled()) {
                SarosRoadSignsModMod.LOGGER.warn("[SRS][DynTex] Texture source missing: {}", (Object)fileKey);
            }
            return new ResourceLocation("saros_road_signs_mod", "textures/triangle0.png");
        }
        FileInputStream fis = new FileInputStream(file);
        try {
            NativeImage src = NativeImage.m_85058_((InputStream)fis);
            DynamicTexture dt = new DynamicTexture(src);
            ResourceLocation rl = new ResourceLocation("saros_road_signs_mod", "dynamic/pack_tex/" + Integer.toHexString(cacheKey.hashCode()));
            Minecraft.m_91087_().m_91097_().m_118495_(rl, (AbstractTexture)dt);
            CACHE.put(cacheKey, rl);
            resourceLocation = rl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                if (PackManager.isDebugEnabled()) {
                    SarosRoadSignsModMod.LOGGER.warn("[SRS][DynTex] Failed to load {}: {}", (Object)fileKey, (Object)e.toString());
                }
                return new ResourceLocation("saros_road_signs_mod", "textures/triangle0.png");
            }
        }
        fis.close();
        return resourceLocation;
    }
}

