/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadsignsmod.network;

import de.sarocesch.sarosroadsignsmod.SarosRoadSignsModMod;
import de.sarocesch.sarosroadsignsmod.block.CustomSignBlock;
import de.sarocesch.sarosroadsignsmod.block.entity.CustomSignBlockEntity;
import de.sarocesch.sarosroadsignsmod.custom.CustomBlocks;
import de.sarocesch.sarosroadsignsmod.server.SelectedSignServerState;
import de.sarocesch.sarosroadsignsmod.util.ConfigUtil;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkEvent;

public class CustomSignPlaceMessage {
    public final BlockPos pos;

    public CustomSignPlaceMessage(BlockPos pos) {
        this.pos = pos;
    }

    public static void encode(CustomSignPlaceMessage m, FriendlyByteBuf b) {
        b.m_130064_(m.pos);
    }

    public static CustomSignPlaceMessage decode(FriendlyByteBuf b) {
        return new CustomSignPlaceMessage(b.m_130135_());
    }

    public static void handle(CustomSignPlaceMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sp = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sp == null) {
                return;
            }
            String pack = SelectedSignServerState.getPack(sp.m_20148_());
            String sign = SelectedSignServerState.getSign(sp.m_20148_());
            if (pack == null || sign == null) {
                return;
            }
            Level world = sp.m_9236_();
            if (world instanceof ServerLevel) {
                ServerLevel slevel = (ServerLevel)world;
                slevel.m_7260_(msg.pos, slevel.m_8055_(msg.pos), slevel.m_8055_(msg.pos), 3);
            }
            BlockState oldState = world.m_8055_(msg.pos);
            Direction facing = Direction.NORTH;
            if (oldState != null && oldState.m_61138_((Property)BlockStateProperties.f_61374_)) {
                facing = (Direction)oldState.m_61143_((Property)BlockStateProperties.f_61374_);
            } else if (sp != null) {
                facing = sp.m_6350_().m_122424_();
            }
            BlockState newState = ((Block)CustomBlocks.CUSTOM_SIGN.get()).m_49966_();
            if (newState.m_61138_((Property)CustomSignBlock.FACING)) {
                newState = (BlockState)newState.m_61124_((Property)CustomSignBlock.FACING, (Comparable)facing);
            }
            world.m_7731_(msg.pos, newState, 3);
            BlockEntity patt2661$temp = world.m_7702_(msg.pos);
            if (patt2661$temp instanceof CustomSignBlockEntity) {
                CustomSignBlockEntity be = (CustomSignBlockEntity)patt2661$temp;
                be.set(pack, sign);
            }
            if (ConfigUtil.isDebugEnabled()) {
                SarosRoadSignsModMod.LOGGER.info("[SRS] Placed custom sign at {} {} {} => {}/{}", (Object)msg.pos.m_123341_(), (Object)msg.pos.m_123342_(), (Object)msg.pos.m_123343_(), (Object)pack, (Object)sign);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

