/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadsignsmod.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import net.minecraftforge.fml.loading.FMLPaths;

public class ConfigUtil {
    private static Boolean debugCached = null;
    private static Boolean generateExampleCached = null;

    private static File configFile() {
        return new File(FMLPaths.GAMEDIR.get().toString() + "/config/", "saro\u00b4s_road_signs_mod.json");
    }

    public static boolean isDebugEnabled() {
        if (debugCached != null) {
            return debugCached;
        }
        try {
            File cfg = ConfigUtil.configFile();
            if (!cfg.exists()) {
                debugCached = false;
                return false;
            }
            try (BufferedReader br = new BufferedReader(new FileReader(cfg));){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                JsonObject obj = (JsonObject)new Gson().fromJson(sb.toString(), JsonObject.class);
                debugCached = obj != null && obj.has("debug") ? Boolean.valueOf(obj.get("debug").getAsBoolean()) : Boolean.valueOf(false);
            }
        }
        catch (Exception e) {
            debugCached = false;
        }
        return debugCached;
    }

    public static boolean shouldGenerateExamplePack() {
        if (generateExampleCached != null) {
            return generateExampleCached;
        }
        try {
            File cfg = ConfigUtil.configFile();
            if (!cfg.exists()) {
                generateExampleCached = true;
                return true;
            }
            try (BufferedReader br = new BufferedReader(new FileReader(cfg));){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                JsonObject obj = (JsonObject)new Gson().fromJson(sb.toString(), JsonObject.class);
                generateExampleCached = obj != null && obj.has("generateExamplePack") ? Boolean.valueOf(obj.get("generateExamplePack").getAsBoolean()) : Boolean.valueOf(true);
            }
        }
        catch (Exception e) {
            generateExampleCached = true;
        }
        return generateExampleCached;
    }

    public static void invalidate() {
        debugCached = null;
        generateExampleCached = null;
    }
}

