/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.mines.ClaymoreBlock;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.inventory.LensContainer;
import net.geforcemods.securitycraft.inventory.SingleLensMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.TargetingMode;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ClaymoreBlockEntity
extends CustomizableBlockEntity
implements ITickingBlockEntity,
MenuProvider,
ContainerListener,
SingleLensMenu.SingleLensContainer {
    private Option.IntOption range = new Option.IntOption("range", 5, 1, 10, 1);
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private Option.TargetingModeOption targetingMode = new Option.TargetingModeOption(TargetingMode.PLAYERS_AND_MOBS);
    private Option.RespectInvisibilityOption respectInvisibility = new Option.RespectInvisibilityOption();
    private LazyOptional<IItemHandler> insertOnlyHandler;
    private LazyOptional<IItemHandler> lensHandler;
    private LensContainer lens = new LensContainer(1);
    private int cooldown = -1;

    public ClaymoreBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.CLAYMORE_BLOCK_ENTITY.get(), pos, state);
        this.lens.m_19164_(this);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)ClaymoreBlock.DEACTIVATED)).booleanValue()) {
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        if (this.cooldown == 0) {
            ((ClaymoreBlock)state.m_60734_()).explode(level, pos);
            return;
        }
        TargetingMode mode = this.getTargetingMode();
        Direction dir = (Direction)state.m_61143_((Property)ClaymoreBlock.FACING);
        AABB area = switch (dir) {
            case Direction.NORTH -> new AABB(pos).m_82310_(0.0, 0.0, (double)((Integer)this.range.get()).intValue());
            case Direction.SOUTH -> new AABB(pos).m_82310_(0.0, 0.0, (double)(-((Integer)this.range.get()).intValue()));
            case Direction.EAST -> new AABB(pos).m_82310_((double)(-((Integer)this.range.get()).intValue()), 0.0, 0.0);
            case Direction.WEST -> new AABB(pos).m_82310_((double)((Integer)this.range.get()).intValue(), 0.0, 0.0);
            default -> new AABB(pos);
        };
        level.m_6443_(LivingEntity.class, area, e -> mode.canAttackEntity((LivingEntity)e, this, this.respectInvisibility::isConsideredInvisible)).stream().findFirst().ifPresent(e -> {
            this.cooldown = 20;
            level.m_5594_(null, BlockPos.m_274561_((double)((double)this.f_58858_.m_123341_() + 0.5), (double)((double)this.f_58858_.m_123342_() + 0.5), (double)((double)this.f_58858_.m_123343_() + 0.5)), SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, 0.6f);
        });
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("cooldown", this.cooldown);
        tag.m_128365_("lens", (Tag)this.lens.m_7927_());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.cooldown = tag.m_128451_("cooldown");
        this.lens.m_7797_(tag.m_128437_("lens", 10));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return BlockUtils.isAllowedToExtractFromProtectedObject(side, this) ? this.getNormalHandler().cast() : this.getInsertOnlyHandler().cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        if (this.insertOnlyHandler != null) {
            this.insertOnlyHandler.invalidate();
        }
        if (this.lensHandler != null) {
            this.lensHandler.invalidate();
        }
        super.invalidateCaps();
    }

    public void reviveCaps() {
        this.insertOnlyHandler = null;
        this.lensHandler = null;
        super.reviveCaps();
    }

    private LazyOptional<IItemHandler> getInsertOnlyHandler() {
        if (this.insertOnlyHandler == null) {
            this.insertOnlyHandler = LazyOptional.of(() -> new InsertOnlyInvWrapper((Container)this.lens));
        }
        return this.insertOnlyHandler;
    }

    private LazyOptional<IItemHandler> getNormalHandler() {
        if (this.lensHandler == null) {
            this.lensHandler = LazyOptional.of(() -> new InvWrapper((Container)this.lens));
        }
        return this.lensHandler;
    }

    public void m_5757_(Container container) {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new SingleLensMenu(id, this.f_58857_, this.f_58858_, inventory);
    }

    public Component m_5446_() {
        return super.m_5446_();
    }

    @Override
    public Container getLensContainer() {
        return this.lens;
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.range, this.ignoreOwner, this.targetingMode, this.respectInvisibility};
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[0];
    }

    @Override
    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    public TargetingMode getTargetingMode() {
        return (TargetingMode)((Object)this.targetingMode.get());
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_);
    }
}

