/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.KeypadChestBlock;
import net.geforcemods.securitycraft.entity.sentry.ISentryBulletContainer;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class KeypadChestBlockEntity
extends ChestBlockEntity
implements IPasscodeProtected,
IOwnable,
IModuleInventory,
ICustomizable,
ILockable,
ISentryBulletContainer {
    private LazyOptional<IItemHandler> insertOnlyHandler;
    private byte[] passcode;
    private UUID saltKey;
    private boolean saveSalt = false;
    private Owner owner = new Owner();
    private NonNullList<ItemStack> modules = NonNullList.m_122780_((int)this.getMaxNumberOfModules(), (Object)ItemStack.f_41583_);
    private Option.BooleanOption sendAllowlistMessage = new Option.SendAllowlistMessageOption(false);
    private Option.BooleanOption sendDenylistMessage = new Option.SendDenylistMessageOption(true);
    private Option.SmartModuleCooldownOption smartModuleCooldown = new Option.SmartModuleCooldownOption();
    private long cooldownEnd = 0L;
    private Map<ModuleType, Boolean> moduleStates = new EnumMap<ModuleType, Boolean>(ModuleType.class);
    private ResourceLocation previousChest;

    public KeypadChestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.KEYPAD_CHEST_BLOCK_ENTITY.get(), pos, state);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.writeModuleInventory(tag);
        this.writeModuleStates(tag);
        this.writeOptions(tag);
        long cooldownLeft = this.getCooldownEnd() - System.currentTimeMillis();
        tag.m_128356_("cooldownLeft", cooldownLeft <= 0L ? -1L : cooldownLeft);
        this.savePasscodeAndSalt(tag);
        if (this.owner != null) {
            this.owner.save(tag, this.needsValidation());
        }
        if (this.previousChest != null) {
            tag.m_128359_("previous_chest", this.previousChest.toString());
        }
    }

    public void m_142466_(CompoundTag tag) {
        ResourceLocation parsedPreviousChest;
        String savedPreviousChest;
        super.m_142466_(tag);
        this.modules = this.readModuleInventory(tag);
        this.moduleStates = this.readModuleStates(tag);
        this.readOptions(tag);
        this.cooldownEnd = System.currentTimeMillis() + tag.m_128454_("cooldownLeft");
        this.loadSaltKey(tag);
        this.loadPasscode(tag);
        this.owner.load(tag);
        if (tag.m_128441_("previous_chest") && !(savedPreviousChest = tag.m_128461_("previous_chest")).isBlank() && (parsedPreviousChest = new ResourceLocation(savedPreviousChest)).m_135815_() != null && !parsedPreviousChest.m_135815_().isBlank()) {
            this.previousChest = parsedPreviousChest;
        }
        if (tag.m_128441_("sendMessage") && !tag.m_128471_("sendMessage")) {
            this.sendAllowlistMessage.setValue(false);
            this.sendDenylistMessage.setValue(false);
        }
    }

    public CompoundTag m_5995_() {
        return PasscodeUtils.filterPasscodeAndSaltFromTag(this.m_187482_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        super.onDataPacket(net, packet);
        DisguisableBlockEntity.onHandleUpdateTag(this);
    }

    public void onLoad() {
        super.onLoad();
        DisguisableBlockEntity.onOnLoad(this);
    }

    public Component m_6820_() {
        return Utils.localize(((KeypadChestBlock)SCContent.KEYPAD_CHEST.get()).m_7705_(), new Object[0]);
    }

    protected void m_142151_(Level level, BlockPos pos, BlockState state, int i, int j) {
        super.m_142151_(level, pos, state, i, j);
        if (this.isModuleEnabled(ModuleType.REDSTONE)) {
            BlockUtils.updateIndirectNeighbors(level, pos, state.m_60734_(), Direction.DOWN);
        }
    }

    public int getNumPlayersUsing() {
        return this.f_155324_.m_155450_();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return BlockUtils.isAllowedToExtractFromProtectedObject(side, this) ? super.getCapability(cap, side) : this.getInsertOnlyHandler().cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        if (this.insertOnlyHandler != null) {
            this.insertOnlyHandler.invalidate();
        }
        super.invalidateCaps();
    }

    public void reviveCaps() {
        this.insertOnlyHandler = null;
        super.reviveCaps();
    }

    private LazyOptional<IItemHandler> getInsertOnlyHandler() {
        if (this.insertOnlyHandler == null) {
            this.insertOnlyHandler = LazyOptional.of(() -> new InsertOnlyInvWrapper((Container)this));
        }
        return this.insertOnlyHandler;
    }

    @Override
    public LazyOptional<IItemHandler> getHandlerForSentry(Sentry entity) {
        if (entity.getOwner().owns(this)) {
            return super.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP);
        }
        return LazyOptional.empty();
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : super.m_8020_(slot);
    }

    @Override
    public void activate(Player player) {
        Block block;
        if (!this.f_58857_.f_46443_ && (block = this.m_58900_().m_60734_()) instanceof KeypadChestBlock) {
            KeypadChestBlock block2 = (KeypadChestBlock)block;
            if (!this.isBlocked()) {
                block2.activate(this.m_58900_(), this.f_58857_, this.f_58858_, player);
            }
        }
    }

    @Override
    public void openPasscodeGUI(Level level, BlockPos pos, Player player) {
        if (!level.f_46443_ && !this.isBlocked()) {
            IPasscodeProtected.super.openPasscodeGUI(level, pos, player);
        }
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        IModuleInventory.super.onModuleInserted(stack, module, toggled);
        this.addOrRemoveModuleFromAttached(stack, false, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onDisguiseModuleInserted((BlockEntity)this, stack, toggled);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        IModuleInventory.super.onModuleRemoved(stack, module, toggled);
        this.addOrRemoveModuleFromAttached(stack, true, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onDisguiseModuleRemoved((BlockEntity)this, stack, toggled);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> void onOptionChanged(Option<T> option) {
        KeypadChestBlockEntity otherBe = this.findOther();
        if (otherBe != null) {
            if (option instanceof Option.BooleanOption) {
                Option.BooleanOption bo = (Option.BooleanOption)option;
                if (option == this.sendAllowlistMessage) {
                    otherBe.setSendsAllowlistMessage((Boolean)bo.get());
                } else {
                    if (option != this.sendDenylistMessage) throw new UnsupportedOperationException("Unhandled option synchronization in keypad chest! " + option.getName());
                    otherBe.setSendsAllowlistMessage((Boolean)bo.get());
                }
            } else {
                if (!(option instanceof Option.IntOption) || option != this.smartModuleCooldown) throw new UnsupportedOperationException("Unhandled option synchronization in keypad chest! " + option.getName());
                otherBe.smartModuleCooldown.copy(option);
            }
        }
        ICustomizable.super.onOptionChanged(option);
    }

    @Override
    public void dropAllModules() {
        KeypadChestBlockEntity offsetBe = this.findOther();
        for (ItemStack module : this.getInventory()) {
            Item item = module.m_41720_();
            if (!(item instanceof ModuleItem)) continue;
            ModuleItem item2 = (ModuleItem)item;
            if (offsetBe != null) {
                offsetBe.removeModule(item2.getModuleType(), false);
            }
            Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)module);
        }
        this.getInventory().clear();
    }

    public void addOrRemoveModuleFromAttached(ItemStack module, boolean remove, boolean toggled) {
        Item item;
        if (module.m_41619_() || !((item = module.m_41720_()) instanceof ModuleItem)) {
            return;
        }
        ModuleItem moduleItem = (ModuleItem)item;
        KeypadChestBlockEntity offsetBe = this.findOther();
        if (offsetBe != null) {
            if (toggled ? offsetBe.isModuleEnabled(moduleItem.getModuleType()) != remove : offsetBe.hasModule(moduleItem.getModuleType()) != remove) {
                return;
            }
            if (remove) {
                offsetBe.removeModule(moduleItem.getModuleType(), toggled);
            } else {
                offsetBe.insertModule(module, toggled);
            }
        }
    }

    public KeypadChestBlockEntity findOther() {
        BlockState state = this.m_58900_();
        ChestType type = (ChestType)state.m_61143_((Property)ChestBlock.f_51479_);
        if (type != ChestType.SINGLE) {
            BlockEntity blockEntity;
            ChestType offsetType;
            BlockPos offsetPos = this.f_58858_.m_121945_(ChestBlock.m_51584_((BlockState)state));
            BlockState offsetState = this.f_58857_.m_8055_(offsetPos);
            if (state.m_60734_() == offsetState.m_60734_() && (offsetType = (ChestType)offsetState.m_61143_((Property)ChestBlock.f_51479_)) != ChestType.SINGLE && type != offsetType && state.m_61143_((Property)ChestBlock.f_51478_) == offsetState.m_61143_((Property)ChestBlock.f_51478_) && (blockEntity = this.f_58857_.m_7702_(offsetPos)) instanceof KeypadChestBlockEntity) {
                KeypadChestBlockEntity be = (KeypadChestBlockEntity)blockEntity;
                return be;
            }
        }
        return null;
    }

    @Override
    public void onOwnerChanged(BlockState state, Level level, BlockPos pos, Player player, Owner oldOwner, Owner newOwner) {
        KeypadChestBlockEntity otherHalf = this.findOther();
        if (otherHalf != null) {
            otherHalf.setOwner(this.getOwner().getUUID(), this.getOwner().getName());
        }
        IOwnable.super.onOwnerChanged(state, level, pos, player, oldOwner, newOwner);
    }

    public void m_7651_() {
        super.m_7651_();
        DisguisableBlockEntity.onSetRemoved((BlockEntity)this);
    }

    @Override
    public byte[] getPasscode() {
        return this.passcode == null || this.passcode.length == 0 ? null : this.passcode;
    }

    @Override
    public void setPasscode(byte[] passcode) {
        this.passcode = passcode;
        this.m_6596_();
    }

    @Override
    public UUID getSaltKey() {
        return this.saltKey;
    }

    @Override
    public void setSaltKey(UUID saltKey) {
        this.saltKey = saltKey;
    }

    @Override
    public void setSaveSalt(boolean saveSalt) {
        this.saveSalt = saveSalt;
    }

    @Override
    public boolean shouldSaveSalt() {
        return this.saveSalt;
    }

    @Override
    public void setPasscodeInAdjacentBlock(String codeToSet) {
        KeypadChestBlockEntity chestBe = this.findOther();
        if (chestBe != null && this.getOwner().owns(chestBe)) {
            chestBe.hashAndSetPasscode(codeToSet, this.getSalt());
            this.f_58857_.m_7260_(chestBe.f_58858_, chestBe.m_58900_(), chestBe.m_58900_(), 2);
        }
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
        this.m_6596_();
    }

    public boolean isBlocked() {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos pos = this.m_58899_().m_121945_(dir);
            if (!(this.f_58857_.m_8055_(pos).m_60734_() instanceof KeypadChestBlock) || !KeypadChestBlock.isBlocked(this.f_58857_, pos)) continue;
            return true;
        }
        return this.isSingleBlocked();
    }

    public boolean isSingleBlocked() {
        return KeypadChestBlock.isBlocked(this.m_58904_(), this.m_58899_());
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public void startCooldown() {
        KeypadChestBlockEntity otherHalf = this.findOther();
        long start = System.currentTimeMillis();
        this.startCooldown(start);
        if (otherHalf != null) {
            otherHalf.startCooldown(start);
        }
    }

    public void startCooldown(long start) {
        if (!this.isOnCooldown()) {
            this.cooldownEnd = start + (long)((Integer)this.smartModuleCooldown.get() * 50);
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
            this.m_6596_();
        }
    }

    @Override
    public long getCooldownEnd() {
        return this.cooldownEnd;
    }

    @Override
    public boolean isOnCooldown() {
        return System.currentTimeMillis() < this.getCooldownEnd();
    }

    @Override
    public boolean shouldDropModules() {
        return this.m_58900_().m_61143_((Property)ChestBlock.f_51479_) == ChestType.SINGLE;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.REDSTONE, ModuleType.SMART, ModuleType.HARMING, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendAllowlistMessage, this.sendDenylistMessage, this.smartModuleCooldown};
    }

    @Override
    public boolean isModuleEnabled(ModuleType module) {
        return this.hasModule(module) && this.moduleStates.get((Object)module) == Boolean.TRUE;
    }

    @Override
    public void toggleModuleState(ModuleType module, boolean shouldBeEnabled) {
        this.moduleStates.put(module, shouldBeEnabled);
    }

    public ModelData getModelData() {
        return DisguisableBlockEntity.getModelData((BlockEntity)this);
    }

    public boolean sendsAllowlistMessage() {
        return (Boolean)this.sendAllowlistMessage.get();
    }

    public void setSendsAllowlistMessage(boolean value) {
        this.sendAllowlistMessage.setValue(value);
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.m_6596_();
    }

    public boolean sendsDenylistMessage() {
        return (Boolean)this.sendDenylistMessage.get();
    }

    public void setSendsDenylistMessage(boolean value) {
        this.sendDenylistMessage.setValue(value);
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.m_6596_();
    }

    public void setPreviousChest(Block previousChest) {
        this.previousChest = Utils.getRegistryName(previousChest);
    }

    public ResourceLocation getPreviousChest() {
        return this.previousChest;
    }

    @Override
    public Level myLevel() {
        return this.f_58857_;
    }

    @Override
    public BlockPos myPos() {
        return this.f_58858_;
    }
}

