/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public abstract class AbstractPanelBlock
extends OwnableBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.f_61376_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    protected AbstractPanelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(FACE, (Comparable)AttachFace.WALL)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors((Level)level, pos, (Block)this, AbstractPanelBlock.getConnectedDirection(state).m_122424_());
        }
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return (Boolean)state.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return (Boolean)state.m_61143_((Property)POWERED) != false && AbstractPanelBlock.getConnectedDirection(state) == side ? 15 : 0;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return AbstractPanelBlock.canAttach(level, pos, AbstractPanelBlock.getConnectedDirection(state).m_122424_());
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        for (Direction direction : ctx.m_6232_()) {
            BlockState state = direction.m_122434_() == Direction.Axis.Y ? (BlockState)((BlockState)this.m_49966_().m_61124_(FACE, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).m_61124_((Property)FACING, (Comparable)ctx.m_8125_()) : (BlockState)((BlockState)this.m_49966_().m_61124_(FACE, (Comparable)AttachFace.WALL)).m_61124_((Property)FACING, (Comparable)direction.m_122424_());
            if (!state.m_60710_((LevelReader)level, pos)) continue;
            return (BlockState)((BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return AbstractPanelBlock.getConnectedDirection(state).m_122424_() == facing && !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (player.m_7500_() && (blockEntity = level.m_7702_(pos)) instanceof IModuleInventory) {
            IModuleInventory inv = (IModuleInventory)blockEntity;
            inv.getInventory().clear();
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity be = level.m_7702_(pos);
            if (!((Boolean)ConfigHandler.SERVER.vanillaToolBlockBreaking.get()).booleanValue() && be instanceof IModuleInventory) {
                IModuleInventory inv = (IModuleInventory)be;
                inv.dropAllModules();
            }
            if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
                level.m_46672_(pos, (Block)this);
                level.m_46672_(pos.m_121945_(AbstractPanelBlock.getConnectedDirection(state).m_122424_()), (Block)this);
            }
            if (be instanceof IPasscodeProtected) {
                IPasscodeProtected passcodeProtected = (IPasscodeProtected)be;
                SaltData.removeSalt(passcodeProtected.getSaltKey());
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWERED, FACE, WATERLOGGED});
    }

    public void activate(BlockState state, Level level, BlockPos pos, int signalLength) {
        level.m_46597_(pos, (BlockState)state.m_61122_((Property)POWERED));
        BlockUtils.updateIndirectNeighbors(level, pos, (Block)this, AbstractPanelBlock.getConnectedDirection(state).m_122424_());
        if (signalLength > 0) {
            level.m_186460_(pos, (Block)this, signalLength);
        }
    }

    public static Direction getConnectedDirection(BlockState state) {
        return switch ((AttachFace)state.m_61143_(FACE)) {
            case AttachFace.CEILING -> Direction.DOWN;
            case AttachFace.FLOOR -> Direction.UP;
            default -> (Direction)state.m_61143_((Property)FACING);
        };
    }

    public static boolean canAttach(LevelReader level, BlockPos pos, Direction direction) {
        BlockPos relativePos = pos.m_121945_(direction);
        return level.m_8055_(relativePos).m_60783_((BlockGetter)level, relativePos, direction.m_122424_());
    }
}

