/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IDoorActivator;
import net.geforcemods.securitycraft.blockentities.SecureRedstoneInterfaceBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;

public class SecureRedstoneInterfaceBlock
extends DisguisableBlock {
    public static final BooleanProperty SENDER = BooleanProperty.m_61465_((String)"sender");
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final VoxelShape[] SENDER_SHAPES = new VoxelShape[]{Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), (VoxelShape)Block.m_49796_((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)15.0, (double)9.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)7.0, (double)7.0, (double)1.0, (double)9.0, (double)9.0, (double)9.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)7.0), (VoxelShape)Block.m_49796_((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)15.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)9.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)1.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)7.0, (double)7.0, (double)7.0, (double)15.0, (double)9.0, (double)9.0))};
    private static final VoxelShape[] RECEIVER_SHAPES = new VoxelShape[]{Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)7.0, (double)3.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), (VoxelShape)Block.m_49796_((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)13.0, (double)9.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)7.0, (double)7.0, (double)3.0, (double)9.0, (double)9.0, (double)9.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)7.0), (VoxelShape)Block.m_49796_((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)13.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)9.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)3.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)7.0, (double)7.0, (double)7.0, (double)13.0, (double)9.0, (double)9.0))};

    public SecureRedstoneInterfaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)SENDER, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FACING, (Comparable)Direction.UP));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60651_(level, pos, ctx);
        }
        return ((Boolean)state.m_61143_((Property)SENDER) != false ? SENDER_SHAPES : RECEIVER_SHAPES)[((Direction)state.m_61143_((Property)FACING)).m_122411_()];
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand pHand, BlockHitResult hit) {
        SecureRedstoneInterfaceBlockEntity be;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SecureRedstoneInterfaceBlockEntity && (be = (SecureRedstoneInterfaceBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            if (!level.f_46443_) {
                if (be.isDisabled()) {
                    player.m_5661_((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
                } else if (be.getOwner().isValidated()) {
                    SecurityCraft.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenScreen(OpenScreen.DataType.SECURE_REDSTONE_INTERFACE, pos));
                } else {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:universalOwnerChanger.ownerInvalidated", new Object[0]), ChatFormatting.RED);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_7899_(BlockState state) {
        return (Boolean)state.m_61143_((Property)SENDER) == false;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        SecureRedstoneInterfaceBlockEntity be;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SecureRedstoneInterfaceBlockEntity && (be = (SecureRedstoneInterfaceBlockEntity)blockEntity).isSender() && !be.isDisabled()) {
            be.refreshPower();
        }
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        if (state.m_61143_((Property)FACING) == direction) {
            return this.m_6378_(state, level, pos, direction);
        }
        return 0;
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SecureRedstoneInterfaceBlockEntity) {
            SecureRedstoneInterfaceBlockEntity be = (SecureRedstoneInterfaceBlockEntity)blockEntity;
            return be.getRedstonePowerOutput();
        }
        return 0;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof SecureRedstoneInterfaceBlockEntity) {
            SecureRedstoneInterfaceBlockEntity be = (SecureRedstoneInterfaceBlockEntity)blockEntity;
            be.disabled.setValue(true);
            if (be.isSender()) {
                be.tellSimilarReceiversToRefresh();
            } else {
                be.updateNeighbors();
            }
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)super.m_5573_(ctx).m_61124_((Property)FACING, (Comparable)ctx.m_43719_());
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SecureRedstoneInterfaceBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return SecureRedstoneInterfaceBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)SCContent.SECURE_REDSTONE_INTERFACE_BLOCK_ENTITY.get()), LevelUtils::blockEntityTicker);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SENDER, FACING, WATERLOGGED});
    }

    public static class DoorActivator
    implements IDoorActivator {
        private final List<Block> blocks = Arrays.asList((Block)SCContent.SECURE_REDSTONE_INTERFACE.get());

        @Override
        public boolean isPowering(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity, Direction direction, int distance) {
            SecureRedstoneInterfaceBlockEntity be;
            return (Boolean)state.m_61143_((Property)SENDER) == false && blockEntity instanceof SecureRedstoneInterfaceBlockEntity && (be = (SecureRedstoneInterfaceBlockEntity)blockEntity).isProtectedSignal() && be.getPower() > 0;
        }

        @Override
        public List<Block> getBlocks() {
            return this.blocks;
        }
    }
}

