/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.geforcemods.securitycraft.blocks.reinforced.BaseReinforcedBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ReinforcedStairsBlock
extends BaseReinforcedBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.f_61398_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape AABB_SLAB_TOP = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape AABB_SLAB_BOTTOM = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape NWD_CORNER = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0);
    protected static final VoxelShape SWD_CORNER = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0);
    protected static final VoxelShape NWU_CORNER = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SWU_CORNER = Block.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NED_CORNER = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
    protected static final VoxelShape SED_CORNER = Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape NEU_CORNER = Block.m_49796_((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SEU_CORNER = Block.m_49796_((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape[] SLAB_TOP_SHAPES = ReinforcedStairsBlock.makeShapes(AABB_SLAB_TOP, NWD_CORNER, NED_CORNER, SWD_CORNER, SED_CORNER);
    protected static final VoxelShape[] SLAB_BOTTOM_SHAPES = ReinforcedStairsBlock.makeShapes(AABB_SLAB_BOTTOM, NWU_CORNER, NEU_CORNER, SWU_CORNER, SEU_CORNER);
    private static final int[] SHAPE_BY_STATE = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};
    private final Block modelBlock;
    private final BlockState modelState;

    public ReinforcedStairsBlock(BlockBehaviour.Properties properties, Block vB) {
        this(properties, () -> vB);
    }

    public ReinforcedStairsBlock(BlockBehaviour.Properties properties, Supplier<Block> vB) {
        super(properties, vB);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)Half.BOTTOM)).m_61124_(SHAPE, (Comparable)StairsShape.STRAIGHT)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.modelBlock = this.getVanillaBlock();
        this.modelState = this.modelBlock.m_49966_();
    }

    private static VoxelShape[] makeShapes(VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(shape -> ReinforcedStairsBlock.combineShapes(shape, slabShape, nwCorner, neCorner, swCorner, seCorner)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape combineShapes(int bitfield, VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        VoxelShape shape = slabShape;
        if ((bitfield & 1) != 0) {
            shape = Shapes.m_83110_((VoxelShape)slabShape, (VoxelShape)nwCorner);
        }
        if ((bitfield & 2) != 0) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)neCorner);
        }
        if ((bitfield & 4) != 0) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)swCorner);
        }
        if ((bitfield & 8) != 0) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)seCorner);
        }
        return shape;
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (state.m_61143_(HALF) == Half.TOP ? SLAB_TOP_SHAPES : SLAB_BOTTOM_SHAPES)[SHAPE_BY_STATE[this.getShapeIndex(state)]];
    }

    private int getShapeIndex(BlockState state) {
        return ((StairsShape)state.m_61143_(SHAPE)).ordinal() * 4 + ((Direction)state.m_61143_((Property)FACING)).m_122416_();
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        this.modelBlock.m_214162_(state, level, pos, rand);
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        this.modelState.m_60686_(level, pos, player);
    }

    public void m_6786_(LevelAccessor level, BlockPos pos, BlockState state) {
        this.modelBlock.m_6786_(level, pos, state);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.m_60734_() != oldState.m_60734_()) {
            this.modelState.m_60690_(level, pos, Blocks.f_50016_, pos, false);
            this.modelBlock.m_6807_(this.modelState, level, pos, oldState, false);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            this.modelState.m_60753_(level, pos, newState, isMoving);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        this.modelBlock.m_141947_(level, pos, state, entity);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.modelState.m_222963_(level, pos, random);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.modelState.m_60664_(level, player, hand, hit);
    }

    public void m_7592_(Level level, BlockPos pos, Explosion explosion) {
        this.modelBlock.m_7592_(level, pos, explosion);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction dir = ctx.m_43719_();
        BlockPos pos = ctx.m_8083_();
        FluidState fluidState = ctx.m_43725_().m_6425_(pos);
        BlockState state = (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_())).m_61124_(HALF, (Comparable)(dir != Direction.DOWN && (dir == Direction.UP || ctx.m_43720_().f_82480_ - (double)pos.m_123342_() <= 0.5) ? Half.BOTTOM : Half.TOP))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        return (BlockState)state.m_61124_(SHAPE, (Comparable)ReinforcedStairsBlock.getShapeProperty(state, (BlockGetter)ctx.m_43725_(), pos));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return facing.m_122434_().m_122479_() ? (BlockState)state.m_61124_(SHAPE, (Comparable)ReinforcedStairsBlock.getShapeProperty(state, (BlockGetter)level, currentPos)) : super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    private static StairsShape getShapeProperty(BlockState state, BlockGetter level, BlockPos pos) {
        Direction offsetOppositeDir;
        Direction offsetDir;
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        BlockState offsetState = level.m_8055_(pos.m_121945_(dir));
        if (ReinforcedStairsBlock.isBlockStairs(offsetState) && state.m_61143_(HALF) == offsetState.m_61143_(HALF) && (offsetDir = (Direction)offsetState.m_61143_((Property)FACING)).m_122434_() != ((Direction)state.m_61143_((Property)FACING)).m_122434_() && ReinforcedStairsBlock.isDifferentStairs(state, level, pos, offsetDir.m_122424_())) {
            if (offsetDir == dir.m_122428_()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState offsetOppositeState = level.m_8055_(pos.m_121945_(dir.m_122424_()));
        if (ReinforcedStairsBlock.isBlockStairs(offsetOppositeState) && state.m_61143_(HALF) == offsetOppositeState.m_61143_(HALF) && (offsetOppositeDir = (Direction)offsetOppositeState.m_61143_((Property)FACING)).m_122434_() != ((Direction)state.m_61143_((Property)FACING)).m_122434_() && ReinforcedStairsBlock.isDifferentStairs(state, level, pos, offsetOppositeDir)) {
            if (offsetOppositeDir == dir.m_122428_()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean isDifferentStairs(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        BlockState offsetState = level.m_8055_(pos.m_121945_(face));
        return !ReinforcedStairsBlock.isBlockStairs(offsetState) || offsetState.m_61143_((Property)FACING) != state.m_61143_((Property)FACING) || offsetState.m_61143_(HALF) != state.m_61143_(HALF);
    }

    public static boolean isBlockStairs(BlockState state) {
        return state.m_60734_() instanceof ReinforcedStairsBlock || state.m_60734_() instanceof StairBlock;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        StairsShape shape = (StairsShape)state.m_61143_(SHAPE);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (direction.m_122434_() != Direction.Axis.Z) break;
                return switch (shape) {
                    case StairsShape.INNER_LEFT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.INNER_RIGHT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.OUTER_LEFT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    default -> state.m_60717_(Rotation.CLOCKWISE_180);
                };
            }
            case FRONT_BACK: {
                if (direction.m_122434_() != Direction.Axis.X) break;
                return switch (shape) {
                    default -> throw new IncompatibleClassChangeError();
                    case StairsShape.INNER_LEFT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.INNER_RIGHT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.OUTER_LEFT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    case StairsShape.STRAIGHT -> state.m_60717_(Rotation.CLOCKWISE_180);
                };
            }
        }
        return super.m_6943_(state, mirror);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HALF, SHAPE, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

