/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity;

import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SCTags;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.inventory.CustomizeBlockMenu;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;

public class SecuritySeaBoat
extends ChestBoat
implements IOwnable,
IPasscodeProtected,
IModuleInventory,
ICustomizable {
    private static final EntityDataAccessor<Owner> OWNER = SynchedEntityData.m_135353_(SecuritySeaBoat.class, Owner.getSerializer());
    private static final EntityDataAccessor<Boolean> SEND_ALLOWLIST_MESSAGE = SynchedEntityData.m_135353_(SecuritySeaBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SEND_DENYLIST_MESSAGE = SynchedEntityData.m_135353_(SecuritySeaBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SMART_MODULE_COOLDOWN = SynchedEntityData.m_135353_(SecuritySeaBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Long> COOLDOWN_END = SynchedEntityData.m_135353_(SecuritySeaBoat.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    private static final EntityDataAccessor<Map<ModuleType, Boolean>> MODULE_STATES = SynchedEntityData.m_135353_(SecuritySeaBoat.class, (EntityDataSerializer)((EntityDataSerializer)SCContent.MODULE_STATES_SERIALIZER.get()));
    private static final EntityDataAccessor<NonNullList<ItemStack>> MODULES = SynchedEntityData.m_135353_(SecuritySeaBoat.class, (EntityDataSerializer)((EntityDataSerializer)SCContent.ITEM_STACK_LIST_SERIALIZER.get()));
    private byte[] passcode;
    private UUID saltKey;
    private boolean saveSalt = false;
    private Option.EntityDataWrappedOption<Boolean> sendAllowlistMessage = new Option.SendAllowlistMessageOption(false).wrapForEntityData(SEND_ALLOWLIST_MESSAGE, () -> this.f_19804_);
    private Option.EntityDataWrappedOption<Boolean> sendDenylistMessage = new Option.SendDenylistMessageOption(true).wrapForEntityData(SEND_DENYLIST_MESSAGE, () -> this.f_19804_);
    private Option.EntityDataWrappedOption<Integer> smartModuleCooldown = new Option.SmartModuleCooldownOption().wrapForEntityData(SMART_MODULE_COOLDOWN, () -> this.f_19804_);
    private boolean isInLava = false;
    private LazyOptional<IItemHandler> insertOnlyHandler;

    public SecuritySeaBoat(EntityType<? extends Boat> type, Level level) {
        super((EntityType)SCContent.SECURITY_SEA_BOAT_ENTITY.get(), level);
    }

    public SecuritySeaBoat(Level level, double x, double y, double z) {
        super((EntityType)SCContent.SECURITY_SEA_BOAT_ENTITY.get(), level);
        this.m_6034_(x, y, z);
        this.f_19854_ = y;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER, (Object)new Owner());
        this.f_19804_.m_135372_(SEND_ALLOWLIST_MESSAGE, (Object)false);
        this.f_19804_.m_135372_(SEND_DENYLIST_MESSAGE, (Object)true);
        this.f_19804_.m_135372_(SMART_MODULE_COOLDOWN, (Object)100);
        this.f_19804_.m_135372_(COOLDOWN_END, (Object)0L);
        this.f_19804_.m_135372_(MODULE_STATES, new EnumMap(ModuleType.class));
        this.f_19804_.m_135372_(MODULES, (Object)NonNullList.m_122780_((int)this.getMaxNumberOfModules(), (Object)ItemStack.f_41583_));
    }

    public boolean m_7310_(Entity passenger) {
        return super.m_7310_(passenger) && (this.isOwnedBy(passenger) || this.isAllowed(passenger)) && !this.isDenied(passenger);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        final Level level = player.m_9236_();
        if (!(!this.isDenied((Entity)player) || this.isOwnedBy((Entity)player) || player.m_36341_() && stack.m_150930_((Item)SCContent.CODEBREAKER.get()))) {
            if (this.sendsDenylistMessage()) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_6095_().m_20675_(), new Object[0]), Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), ChatFormatting.RED);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (player.m_36341_()) {
            if (stack.m_150930_((Item)SCContent.CODEBREAKER.get())) {
                if (!level.f_46443_) {
                    this.handleCodebreaking(player, player.m_21205_().m_150930_((Item)SCContent.CODEBREAKER.get()) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (stack.m_150930_((Item)SCContent.UNIVERSAL_KEY_CHANGER.get())) {
                if (!level.f_46443_) {
                    if (this.isOwnedBy((Entity)player) || player.m_7500_()) {
                        SecurityCraft.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenScreen(OpenScreen.DataType.CHANGE_PASSCODE_FOR_ENTITY, this.m_19879_()));
                    } else {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(((Item)SCContent.UNIVERSAL_KEY_CHANGER.get()).m_5524_(), new Object[0]), Utils.localize("messages.securitycraft:notOwned", PlayerUtils.getOwnerComponent(this.getOwner())), ChatFormatting.RED);
                    }
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (stack.m_150930_((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()) && this.isOwnedBy((Entity)player)) {
                if (!level.f_46443_) {
                    String newOwner = stack.m_41786_().getString();
                    if (FMLEnvironment.production) {
                        this.dropAllModules();
                    }
                    this.setOwner(PlayerUtils.isPlayerOnline(newOwner) ? PlayerUtils.getPlayerFromName(newOwner).m_20148_().toString() : "ownerUUID", newOwner);
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).m_5524_(), new Object[0]), Utils.localize("messages.securitycraft:universalOwnerChanger.changed", newOwner), ChatFormatting.GREEN);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (stack.m_150930_((Item)SCContent.UNIVERSAL_BLOCK_MODIFIER.get())) {
                if (this.isOwnedBy((Entity)player)) {
                    if (!level.f_46443_) {
                        final BlockPos pos = this.m_20183_();
                        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                            public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                                return new CustomizeBlockMenu(windowId, level, pos, SecuritySeaBoat.super.m_19879_(), inv);
                            }

                            public Component m_5446_() {
                                return SecuritySeaBoat.super.m_5446_();
                            }
                        }, data -> {
                            data.m_130064_(pos);
                            data.m_130130_(SecuritySeaBoat.super.m_19879_());
                        });
                    }
                } else {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).m_5524_(), new Object[0]), Utils.localize("messages.securitycraft:notOwned", PlayerUtils.getOwnerComponent(this.getOwner())), ChatFormatting.RED);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (stack.m_150930_((Item)SCContent.UNIVERSAL_BLOCK_REMOVER.get())) {
                if (this.isOwnedBy((Entity)player) || player.m_7500_()) {
                    this.m_213560_(this.m_269291_().m_269075_(player));
                } else {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((Item)SCContent.UNIVERSAL_BLOCK_REMOVER.get()).m_5524_(), new Object[0]), Utils.localize("messages.securitycraft:notOwned", PlayerUtils.getOwnerComponent(this.getOwner())), ChatFormatting.RED);
                }
            }
        } else if (!this.m_7310_((Entity)player)) {
            if (this.isDenied((Entity)player)) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_6095_().m_20675_(), new Object[0]), Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), ChatFormatting.RED);
            } else {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_6095_().m_20675_(), new Object[0]), Utils.localize("messages.securitycraft:security_sea_boat.cant_enter", PlayerUtils.getOwnerComponent(this.getOwner())), ChatFormatting.RED);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6096_(player, hand);
    }

    public InteractionResult m_268996_(Player player) {
        Level level = this.m_9236_();
        BlockPos pos = this.m_20183_();
        if (!level.f_46443_ && this.verifyPasscodeSet(level, pos, this, player)) {
            if (this.isDenied((Entity)player)) {
                if (this.sendsDenylistMessage()) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_6095_().m_20675_(), new Object[0]), Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), ChatFormatting.RED);
                }
            } else if (this.isAllowed((Entity)player)) {
                if (this.sendsAllowlistMessage()) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_6095_().m_20675_(), new Object[0]), Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), ChatFormatting.GREEN);
                }
                this.activate(player);
            } else {
                this.openPasscodeGUI(level, pos, player);
            }
        }
        return !level.f_46443_ ? InteractionResult.CONSUME : InteractionResult.SUCCESS;
    }

    public void m_213583_(Player player) {
        this.m_268996_(player);
    }

    @Override
    public void openPasscodeGUI(Level level, BlockPos pos, Player player) {
        if (!level.f_46443_ && this.getPasscode() != null) {
            SecurityCraft.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenScreen(OpenScreen.DataType.CHECK_PASSCODE_FOR_ENTITY, this.m_19879_()));
        }
    }

    @Override
    public void openSetPasscodeScreen(ServerPlayer player, BlockPos pos) {
        SecurityCraft.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenScreen(OpenScreen.DataType.SET_PASSCODE_FOR_ENTITY, this.m_19879_()));
    }

    public boolean canBoatInFluid(FluidState state) {
        return super.canBoatInFluid(state) || state.m_192917_((Fluid)Fluids.f_76195_);
    }

    public boolean canBoatInFluid(FluidType type) {
        return super.canBoatInFluid(type) || type == ForgeMod.LAVA_TYPE.get();
    }

    public boolean m_38393_() {
        this.isInLava = this.m_9236_().m_6425_(this.m_20183_()).m_192917_((Fluid)Fluids.f_76195_);
        return super.m_38393_();
    }

    public void m_20256_(Vec3 deltaMovement) {
        if (this.isInLava) {
            super.m_20256_(deltaMovement.m_82490_(0.5));
        } else {
            super.m_20256_(deltaMovement);
        }
    }

    public void m_8119_() {
        Entity passenger;
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.isInLava && (passenger = this.m_146895_()) != null) {
            if (!passenger.m_5825_()) {
                passenger.m_7311_(passenger.m_20094_() + 1);
                if (passenger.m_20094_() == 0) {
                    passenger.m_20254_(8);
                }
            }
            passenger.m_6469_(this.m_9236_().m_269111_().m_269387_(), 1.0f);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Player player;
        Entity entity = source.m_7639_();
        if (!(entity instanceof Player) || this.isOwnedBy((Entity)(player = (Player)entity)) || player.m_7500_()) {
            return super.m_6469_(source, amount);
        }
        return false;
    }

    public boolean m_6673_(DamageSource source) {
        return !source.m_269533_(SCTags.DamageTypes.SECURITY_SEA_BOAT_VULNERABLE_TO) || super.m_6673_(source);
    }

    public Item m_38369_() {
        return (Item)(switch (this.m_28554_()) {
            case Boat.Type.SPRUCE -> SCContent.SPRUCE_SECURITY_SEA_BOAT;
            case Boat.Type.BIRCH -> SCContent.BIRCH_SECURITY_SEA_BOAT;
            case Boat.Type.JUNGLE -> SCContent.JUNGLE_SECURITY_SEA_BOAT;
            case Boat.Type.ACACIA -> SCContent.ACACIA_SECURITY_SEA_BOAT;
            case Boat.Type.DARK_OAK -> SCContent.DARK_OAK_SECURITY_SEA_BOAT;
            case Boat.Type.MANGROVE -> SCContent.MANGROVE_SECURITY_SEA_BOAT;
            case Boat.Type.CHERRY -> SCContent.CHERRY_SECURITY_SEA_BOAT;
            case Boat.Type.BAMBOO -> SCContent.BAMBOO_SECURITY_SEA_RAFT;
            default -> SCContent.OAK_SECURITY_SEA_BOAT;
        }).get();
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.m_9236_().f_46443_ && reason.m_146965_()) {
            Containers.m_19010_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), this.getInventory());
            SaltData.removeSalt(this.getSaltKey());
        }
        super.m_142687_(reason);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.m_6084_() && cap == ForgeCapabilities.ITEM_HANDLER) {
            return BlockUtils.isAllowedToExtractFromProtectedObject(side, this, this.m_9236_(), this.m_20183_()) ? super.getCapability(cap, side) : this.getInsertOnlyHandler().cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        if (this.insertOnlyHandler != null) {
            this.insertOnlyHandler.invalidate();
        }
        super.invalidateCaps();
    }

    public void reviveCaps() {
        this.insertOnlyHandler = null;
        super.reviveCaps();
    }

    private LazyOptional<IItemHandler> getInsertOnlyHandler() {
        if (this.insertOnlyHandler == null) {
            this.insertOnlyHandler = LazyOptional.of(() -> new InsertOnlyInvWrapper((Container)this));
        }
        return this.insertOnlyHandler;
    }

    protected void m_7380_(CompoundTag tag) {
        CompoundTag ownerTag = new CompoundTag();
        super.m_7380_(tag);
        this.writeModuleInventory(tag);
        this.writeModuleStates(tag);
        this.writeOptions(tag);
        long cooldownLeft = this.getCooldownEnd() - System.currentTimeMillis();
        tag.m_128356_("cooldownLeft", cooldownLeft <= 0L ? -1L : cooldownLeft);
        this.getOwner().save(ownerTag, this.needsValidation());
        tag.m_128365_("owner", (Tag)ownerTag);
        this.savePasscodeAndSalt(tag);
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(MODULES, (Object)this.readModuleInventory(tag));
        this.f_19804_.m_135381_(MODULE_STATES, (Object)this.readModuleStates(tag));
        this.readOptions(tag);
        this.f_19804_.m_135381_(COOLDOWN_END, (Object)(System.currentTimeMillis() + tag.m_128454_("cooldownLeft")));
        this.f_19804_.m_135381_(OWNER, (Object)Owner.fromCompound(tag.m_128469_("owner")));
        this.loadSaltKey(tag);
        this.loadPasscode(tag);
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(((Option.EntityDataWrappedOption)option).getEntityDataKey(), option.get());
        }
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (this.m_9236_().f_46443_) {
            if (key == SEND_ALLOWLIST_MESSAGE) {
                this.sendAllowlistMessage.setValue((Boolean)this.f_19804_.m_135370_(SEND_ALLOWLIST_MESSAGE));
            } else if (key == SEND_DENYLIST_MESSAGE) {
                this.sendDenylistMessage.setValue((Boolean)this.f_19804_.m_135370_(SEND_DENYLIST_MESSAGE));
            } else if (key == SMART_MODULE_COOLDOWN) {
                this.smartModuleCooldown.setValue((Integer)this.f_19804_.m_135370_(SMART_MODULE_COOLDOWN));
            }
        }
        super.m_7350_(key);
    }

    public void setOwner(Player player) {
        if (player != null) {
            this.setOwner(player.m_36316_().getId().toString(), player.m_7755_().getString());
        }
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.f_19804_.m_135381_(OWNER, (Object)new Owner(name, uuid));
    }

    @Override
    public Owner getOwner() {
        return (Owner)this.f_19804_.m_135370_(OWNER);
    }

    @Override
    public void onOwnerChanged(BlockState state, Level level, BlockPos pos, Player player, Owner oldOwner, Owner newOwner) {
    }

    @Override
    public void activate(Player player) {
        super.m_213583_(player);
    }

    @Override
    public byte[] getPasscode() {
        return this.passcode == null || this.passcode.length == 0 ? null : this.passcode;
    }

    @Override
    public void setPasscode(byte[] passcode) {
        this.passcode = passcode;
    }

    @Override
    public UUID getSaltKey() {
        return this.saltKey;
    }

    @Override
    public void setSaltKey(UUID saltKey) {
        this.saltKey = saltKey;
    }

    @Override
    public void setSaveSalt(boolean saveSalt) {
        this.saveSalt = saveSalt;
    }

    @Override
    public boolean shouldSaveSalt() {
        return this.saveSalt;
    }

    @Override
    public void startCooldown() {
        if (!this.isOnCooldown()) {
            this.f_19804_.m_135381_(COOLDOWN_END, (Object)(System.currentTimeMillis() + (long)(this.smartModuleCooldown.get() * 50)));
        }
    }

    @Override
    public boolean isOnCooldown() {
        return System.currentTimeMillis() < this.getCooldownEnd();
    }

    @Override
    public long getCooldownEnd() {
        return (Long)this.f_19804_.m_135370_(COOLDOWN_END);
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendAllowlistMessage, this.sendDenylistMessage, this.smartModuleCooldown};
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return (NonNullList)this.f_19804_.m_135370_(MODULES);
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.SMART, ModuleType.HARMING};
    }

    @Override
    public boolean isModuleEnabled(ModuleType module) {
        return this.hasModule(module) && ((Map)this.f_19804_.m_135370_(MODULE_STATES)).get((Object)module) == Boolean.TRUE;
    }

    @Override
    public void toggleModuleState(ModuleType module, boolean shouldBeEnabled) {
        Map moduleStates = (Map)this.f_19804_.m_135370_(MODULE_STATES);
        moduleStates.put(module, shouldBeEnabled);
        this.f_19804_.m_135381_(MODULE_STATES, (Object)moduleStates);
    }

    @Override
    public String getModuleDescriptionId(String denotation, ModuleType module) {
        return IModuleInventory.super.getModuleDescriptionId("generic." + denotation, module);
    }

    @Override
    public Level myLevel() {
        return this.m_9236_();
    }

    @Override
    public BlockPos myPos() {
        return this.m_20183_();
    }

    public boolean sendsAllowlistMessage() {
        return this.sendAllowlistMessage.get();
    }

    public void setSendsAllowlistMessage(boolean value) {
        this.sendAllowlistMessage.setValue(value);
    }

    public boolean sendsDenylistMessage() {
        return this.sendDenylistMessage.get();
    }

    public void setSendsDenylistMessage(boolean value) {
        this.sendDenylistMessage.setValue(value);
    }
}

