/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.ProjectorBlockEntity;
import net.geforcemods.securitycraft.inventory.ProjectorMenu;
import net.geforcemods.securitycraft.inventory.StateSelectorAccessMenu;
import net.geforcemods.securitycraft.network.server.SyncProjector;
import net.geforcemods.securitycraft.screen.components.CallbackCheckbox;
import net.geforcemods.securitycraft.screen.components.CallbackSlider;
import net.geforcemods.securitycraft.screen.components.StateSelector;
import net.geforcemods.securitycraft.screen.components.TextHoverChecker;
import net.geforcemods.securitycraft.screen.components.TogglePictureButton;
import net.geforcemods.securitycraft.util.IHasExtraAreas;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ProjectorScreen
extends AbstractContainerScreen<ProjectorMenu>
implements IHasExtraAreas {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/projector.png");
    private static final Component SLOT_TOOLTIP = Utils.localize("gui.securitycraft:projector.block", new Object[0]);
    private ProjectorBlockEntity be;
    private TextHoverChecker slotHoverChecker;
    private CallbackSlider projectionWidthSlider;
    private CallbackSlider projectionHeightSlider;
    private CallbackSlider projectionRangeSlider;
    private CallbackSlider projectionOffsetSlider;
    private TogglePictureButton horizontalToggleButton;
    private CallbackCheckbox overrideCheckbox;
    private StateSelector stateSelector;
    private int sliderWidth = 120;

    public ProjectorScreen(ProjectorMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.be = menu.be;
        this.f_97727_ = 235;
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_97735_ += 90;
        int left = this.f_97735_ + (this.f_97726_ - this.sliderWidth) / 2;
        this.projectionWidthSlider = (CallbackSlider)this.m_142416_((GuiEventListener)new CallbackSlider(left, this.f_97736_ + 57, this.sliderWidth, 20, (Component)Utils.localize("gui.securitycraft:projector.width", ""), (Component)Component.m_237119_(), 1.0, 10.0, this.be.getProjectionWidth(), true, this::applySliderValue));
        this.projectionWidthSlider.setFGColor(0xE0E0E0);
        this.projectionWidthSlider.m_257544_(Tooltip.m_257550_((Component)Utils.localize("gui.securitycraft:projector.width.description", new Object[0])));
        this.projectionHeightSlider = (CallbackSlider)this.m_142416_((GuiEventListener)new CallbackSlider(left, this.f_97736_ + 78, this.sliderWidth, 20, (Component)Utils.localize("gui.securitycraft:projector.height", ""), (Component)Component.m_237119_(), 1.0, 10.0, this.be.getProjectionHeight(), true, this::applySliderValue));
        this.projectionHeightSlider.setFGColor(0xE0E0E0);
        this.projectionHeightSlider.m_257544_(Tooltip.m_257550_((Component)Utils.localize("gui.securitycraft:projector.height.description", new Object[0])));
        this.projectionRangeSlider = (CallbackSlider)this.m_142416_((GuiEventListener)new CallbackSlider(left, this.f_97736_ + 99, this.sliderWidth, 20, (Component)Utils.localize("gui.securitycraft:projector.range", ""), (Component)Component.m_237119_(), 1 - (this.be.isHorizontal() ? 16 : 0), 30 - (this.be.isHorizontal() ? 16 : 0), this.be.getProjectionRange() - (this.be.isHorizontal() ? 16 : 0), true, this::applySliderValue));
        this.projectionRangeSlider.setFGColor(0xE0E0E0);
        this.projectionRangeSlider.m_257544_(Tooltip.m_257550_((Component)Utils.localize("gui.securitycraft:projector.range.description", new Object[0])));
        this.projectionOffsetSlider = (CallbackSlider)this.m_142416_((GuiEventListener)new CallbackSlider(left, this.f_97736_ + 120, this.sliderWidth, 20, (Component)Utils.localize("gui.securitycraft:projector.offset", ""), (Component)Component.m_237119_(), -10.0, 10.0, this.be.getProjectionOffset(), true, this::applySliderValue));
        this.projectionOffsetSlider.setFGColor(0xE0E0E0);
        this.projectionOffsetSlider.m_257544_(Tooltip.m_257550_((Component)Utils.localize("gui.securitycraft:projector.offset.description", new Object[0])));
        this.horizontalToggleButton = (TogglePictureButton)this.m_142416_((GuiEventListener)new TogglePictureButton(left + this.sliderWidth - 20, this.f_97736_ + 36, 20, 20, TEXTURE, new int[]{176, 192}, new int[]{0, 0}, 2, 2, button -> {
            boolean horizontal = !this.be.isHorizontal();
            this.be.setHorizontal(horizontal);
            this.updateHorizontalToggleButtonTooltip();
            this.projectionRangeSlider.setMinValue(this.projectionRangeSlider.getMinValue() - (double)(horizontal ? 16 : -16));
            this.projectionRangeSlider.setMaxValue(this.projectionRangeSlider.getMaxValue() - (double)(horizontal ? 16 : -16));
            this.projectionRangeSlider.m_93611_(this.projectionRangeSlider.getValue() - (double)(horizontal ? 16 : -16));
            this.applySliderValue(this.projectionRangeSlider);
            SecurityCraft.CHANNEL.sendToServer((Object)new SyncProjector(this.be.m_58899_(), this.be.isHorizontal() ? 1 : 0, SyncProjector.DataType.HORIZONTAL));
        }));
        this.horizontalToggleButton.setCurrentIndex(this.be.isHorizontal() ? 1 : 0);
        this.updateHorizontalToggleButtonTooltip();
        this.overrideCheckbox = (CallbackCheckbox)this.m_142416_((GuiEventListener)new CallbackCheckbox(left + this.sliderWidth - 41, this.f_97736_ + 36, 20, 20, (Component)Component.m_237119_(), this.be.isOverridingBlocks(), newValue -> {
            this.be.setOverridingBlocks((boolean)newValue);
            SecurityCraft.CHANNEL.sendToServer((Object)new SyncProjector(this.be.m_58899_(), this.be.isOverridingBlocks() ? 1 : 0, SyncProjector.DataType.OVERRIDING_BLOCKS));
            this.updateOverrideCheckboxTooltip();
        }, 0));
        this.updateOverrideCheckboxTooltip();
        this.slotHoverChecker = new TextHoverChecker(this.f_97736_ + 22, this.f_97736_ + 39, this.f_97735_ + 78, this.f_97735_ + 95, SLOT_TOOLTIP);
        this.stateSelector = (StateSelector)this.m_142416_(new StateSelector((StateSelectorAccessMenu)this.f_97732_, this.f_96539_, this.f_97735_ - 190, this.f_97736_ + 7, 0, 197, 0, 234, 35));
        this.stateSelector.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
    }

    private void updateHorizontalToggleButtonTooltip() {
        this.horizontalToggleButton.m_257544_(Tooltip.m_257550_((Component)(this.be.isHorizontal() ? Utils.localize("gui.securitycraft:projector.horizontal", new Object[0]) : Utils.localize("gui.securitycraft:projector.vertical", new Object[0]))));
    }

    private void updateOverrideCheckboxTooltip() {
        this.overrideCheckbox.m_257544_(Tooltip.m_257550_((Component)(this.be.isOverridingBlocks() ? Utils.localize("gui.securitycraft:projector.isOverridingBlocks.yes", new Object[0]) : Utils.localize("gui.securitycraft:projector.isOverridingBlocks.no", new Object[0]))));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        if (this.slotHoverChecker.checkHover(mouseX, mouseY) && ((ProjectorMenu)this.f_97732_).be.m_7983_()) {
            guiGraphics.m_280557_(this.f_96547_, this.slotHoverChecker.getName(), mouseX, mouseY);
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, 6, 0x404040, false);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.stateSelector != null && this.stateSelector.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return this.m_7222_() != null && this.m_7282_() && button == 0 && this.m_7222_().m_7979_(mouseX, mouseY, button, dragX, dragY) || super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        if (this.stateSelector != null) {
            return this.stateSelector.getGuiExtraAreas();
        }
        return List.of();
    }

    public void m_7379_() {
        super.m_7379_();
        if (this.stateSelector.getState() != null) {
            this.be.setProjectedState(this.stateSelector.getState());
            SecurityCraft.CHANNEL.sendToServer((Object)new SyncProjector(this.be.m_58899_(), this.stateSelector.getState()));
        }
    }

    public void applySliderValue(CallbackSlider slider) {
        int data = 0;
        SyncProjector.DataType dataType = SyncProjector.DataType.INVALID;
        if (slider == this.projectionWidthSlider) {
            data = slider.getValueInt();
            this.be.setProjectionWidth(data);
            dataType = SyncProjector.DataType.WIDTH;
        } else if (slider == this.projectionHeightSlider) {
            data = slider.getValueInt();
            this.be.setProjectionHeight(data);
            dataType = SyncProjector.DataType.HEIGHT;
        } else if (slider == this.projectionRangeSlider) {
            data = slider.getValueInt();
            if (this.be.isHorizontal()) {
                data += 16;
            }
            this.be.setProjectionRange(data);
            dataType = SyncProjector.DataType.RANGE;
        } else if (slider == this.projectionOffsetSlider) {
            data = slider.getValueInt();
            this.be.setProjectionOffset(data);
            dataType = SyncProjector.DataType.OFFSET;
        }
        SecurityCraft.CHANNEL.sendToServer((Object)new SyncProjector(this.be.m_58899_(), data, dataType));
    }
}

