/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ClientUtils {
    private static final ResourceLocation[] MODULE_TEXTURES = new ResourceLocation[]{new ResourceLocation("securitycraft", "textures/item/module_background.png"), new ResourceLocation("securitycraft", "textures/item/whitelist_module.png"), new ResourceLocation("securitycraft", "textures/item/blacklist_module.png"), new ResourceLocation("securitycraft", "textures/item/harming_module.png"), new ResourceLocation("securitycraft", "textures/item/smart_module.png"), new ResourceLocation("securitycraft", "textures/item/storage_module.png"), new ResourceLocation("securitycraft", "textures/item/disguise_module.png"), new ResourceLocation("securitycraft", "textures/item/module_background.png")};
    private static final ResourceLocation REDSTONE_TEXTURE = new ResourceLocation("textures/item/redstone.png");
    private static final ResourceLocation SUGAR_TEXTURE = new ResourceLocation("textures/item/sugar.png");

    private ClientUtils() {
    }

    public static void renderModuleInfo(GuiGraphics guiGraphics, Font font, ModuleType module, Component moduleTooltip, boolean isModuleInstalled, int moduleLeft, int moduleTop, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        float alpha = isModuleInstalled ? 1.0f : 0.5f;
        int moduleRight = moduleLeft + 16;
        int moduleBottom = moduleTop + 16;
        Matrix4f m4f = guiGraphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem._setShaderTexture((int)0, (ResourceLocation)MODULE_TEXTURES[module.ordinal()]);
        ClientUtils.drawTexture(bufferBuilder, m4f, moduleLeft, moduleTop, moduleRight, moduleBottom, alpha);
        if (module == ModuleType.REDSTONE) {
            RenderSystem._setShaderTexture((int)0, (ResourceLocation)REDSTONE_TEXTURE);
            ClientUtils.drawTexture(bufferBuilder, m4f, moduleLeft, moduleTop, moduleRight, moduleBottom, alpha);
        } else if (module == ModuleType.SPEED) {
            RenderSystem._setShaderTexture((int)0, (ResourceLocation)SUGAR_TEXTURE);
            ClientUtils.drawTexture(bufferBuilder, m4f, moduleLeft, moduleTop, moduleRight, moduleBottom, alpha);
        }
        RenderSystem.disableBlend();
        if (moduleTooltip != null && mouseX >= moduleLeft && mouseX < moduleRight && mouseY >= moduleTop && mouseY <= moduleBottom && mc.f_91080_ != null) {
            guiGraphics.m_280666_(font, Arrays.asList(moduleTooltip), mouseX, mouseY);
        }
    }

    private static void drawTexture(BufferBuilder bufferBuilder, Matrix4f m4f, int moduleLeft, int moduleTop, int moduleRight, int moduleBottom, float alpha) {
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        bufferBuilder.m_252986_(m4f, (float)moduleLeft, (float)moduleBottom, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(m4f, (float)moduleRight, (float)moduleBottom, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(1.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(m4f, (float)moduleRight, (float)moduleTop, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(1.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(m4f, (float)moduleLeft, (float)moduleTop, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(0.0f, 0.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    public static Quaternionf fromXYZDegrees(float x, float y, float z) {
        return ClientUtils.fromXYZ((float)Math.toRadians(x), (float)Math.toRadians(y), (float)Math.toRadians(z));
    }

    public static Quaternionf fromXYZ(float x, float y, float z) {
        Quaternionf quaternion = new Quaternionf();
        quaternion.mul((Quaternionfc)new Quaternionf((float)Math.sin(x / 2.0f), 0.0f, 0.0f, (float)Math.cos(x / 2.0f)));
        quaternion.mul((Quaternionfc)new Quaternionf(0.0f, (float)Math.sin(y / 2.0f), 0.0f, (float)Math.cos(y / 2.0f)));
        quaternion.mul((Quaternionfc)new Quaternionf(0.0f, 0.0f, (float)Math.sin(z / 2.0f), (float)Math.cos(z / 2.0f)));
        return quaternion;
    }

    public static void fillHorizontalGradient(GuiGraphics guiGraphics, int zLevel, int left, int top, int right, int bottom, int fromColor, int toColor) {
        float fromAlpha = (float)(fromColor >> 24 & 0xFF) / 255.0f;
        float fromRed = (float)(fromColor >> 16 & 0xFF) / 255.0f;
        float fromGreen = (float)(fromColor >> 8 & 0xFF) / 255.0f;
        float fromBlue = (float)(fromColor & 0xFF) / 255.0f;
        float toAlpha = (float)(toColor >> 24 & 0xFF) / 255.0f;
        float toRed = (float)(toColor >> 16 & 0xFF) / 255.0f;
        float toGreen = (float)(toColor >> 8 & 0xFF) / 255.0f;
        float toBlue = (float)(toColor & 0xFF) / 255.0f;
        Matrix4f mat = guiGraphics.m_280168_().m_85850_().m_252922_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_252986_(mat, (float)right, (float)top, (float)zLevel).m_85950_(toRed, toGreen, toBlue, toAlpha).m_5752_();
        buffer.m_252986_(mat, (float)left, (float)top, (float)zLevel).m_85950_(fromRed, fromGreen, fromBlue, fromAlpha).m_5752_();
        buffer.m_252986_(mat, (float)left, (float)bottom, (float)zLevel).m_85950_(fromRed, fromGreen, fromBlue, fromAlpha).m_5752_();
        buffer.m_252986_(mat, (float)right, (float)bottom, (float)zLevel).m_85950_(toRed, toGreen, toBlue, toAlpha).m_5752_();
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static float[] RGBtoHSB(int r, int g, int b) {
        float hue;
        int cmin;
        float[] hsb = new float[3];
        int cmax = r > g ? r : g;
        int n = cmin = r < g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        if (b < cmin) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsb[0] = hue;
        hsb[1] = saturation;
        hsb[2] = brightness;
        return hsb;
    }
}

