/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mixin.modded.mtr;

import com.lx862.jcm.mod.resources.MTRContentResourceManager;
import com.lx862.jcm.mod.scripting.jcm.JCMScripting;
import com.lx862.jcm.mod.scripting.mtr.eyecandy.EyeCandyScriptContext;
import com.lx862.jcm.mod.scripting.mtr.eyecandy.EyeCandyScriptInstance;
import com.lx862.mtrscripting.api.ScriptResultCall;
import com.lx862.mtrscripting.core.ParsedScript;
import com.lx862.mtrscripting.core.ScriptInstance;
import com.lx862.mtrscripting.data.UniqueKey;
import java.util.ArrayList;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.block.BlockEyeCandy;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.render.RenderEyeCandy;
import org.mtr.mod.render.StoredMatrixTransformations;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RenderEyeCandy.class}, remap=false)
public class RenderEyeCandyMixin {
    @Inject(method={"render(Lorg/mtr/mod/block/BlockEyeCandy$BlockEntity;FLorg/mtr/mapping/mapper/GraphicsHolder;II)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderScript(BlockEyeCandy.BlockEntity blockEntity, float tickDelta, GraphicsHolder graphicsHolder, int light, int overlay, CallbackInfo ci) {
        World world = blockEntity.getWorld2();
        if (world == null) {
            return;
        }
        ParsedScript script = MTRContentResourceManager.getEyecandyScript(blockEntity.getModelId());
        if (script == null) {
            return;
        }
        ScriptInstance<BlockEyeCandy.BlockEntity> scriptInstance = JCMScripting.getScriptManager().getInstanceManager().getInstance(new UniqueKey("mtr", "eyecandy", blockEntity.getModelId(), blockEntity.getPos2().getX(), blockEntity.getPos2().getY(), blockEntity.getPos2().getZ()), () -> new EyeCandyScriptInstance(new EyeCandyScriptContext(blockEntity), blockEntity, script));
        if (!(scriptInstance instanceof EyeCandyScriptInstance)) {
            return;
        }
        EyeCandyScriptInstance eyeCandyScriptInstance = (EyeCandyScriptInstance)scriptInstance;
        EyeCandyScriptContext eyeCandyScriptContext = (EyeCandyScriptContext)scriptInstance.getScriptContext();
        scriptInstance.setWrapperObject(blockEntity);
        scriptInstance.getScript().invokeRenderFunctions(scriptInstance, () -> eyeCandyScriptInstance.setDrawCalls(eyeCandyScriptContext.getDrawCalls()));
        BlockPos blockPos = blockEntity.getPos2();
        Direction facing = IBlock.getStatePropertySafe((World)blockEntity.getWorld2(), (BlockPos)blockPos, (DirectionProperty)BlockEyeCandy.FACING);
        StoredMatrixTransformations blockStoredMatrixTransformations = new StoredMatrixTransformations(0.5 + (double)blockEntity.getPos2().getX(), (double)blockEntity.getPos2().getY(), 0.5 + (double)blockEntity.getPos2().getZ());
        StoredMatrixTransformations storedMatrixTransformations = blockStoredMatrixTransformations.copy();
        storedMatrixTransformations.add(graphicsHolderNew -> {
            graphicsHolderNew.translate((double)blockEntity.getTranslateX(), (double)blockEntity.getTranslateY(), (double)blockEntity.getTranslateZ());
            graphicsHolderNew.rotateYDegrees(180.0f - facing.asRotation());
            graphicsHolderNew.rotateXDegrees(blockEntity.getRotateX() + 180.0f);
            graphicsHolderNew.rotateYDegrees(blockEntity.getRotateY());
            graphicsHolderNew.rotateZDegrees(blockEntity.getRotateZ());
        });
        for (ScriptResultCall drawCall : new ArrayList<ScriptResultCall>(eyeCandyScriptInstance.drawCalls)) {
            if (drawCall == null) continue;
            drawCall.run(world, graphicsHolder, storedMatrixTransformations, facing, light);
        }
        for (ScriptResultCall soundCall : new ArrayList<ScriptResultCall>(eyeCandyScriptInstance.soundCalls)) {
            if (soundCall == null) continue;
            soundCall.run(world, graphicsHolder, storedMatrixTransformations, facing, light);
        }
        ci.cancel();
    }
}

