/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.render.gui.widget;

import com.lx862.jcm.mod.render.ClipStack;
import com.lx862.jcm.mod.render.GuiHelper;
import org.mtr.mapping.mapper.ClickableWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;

public abstract class AbstractScrollViewWidget
extends ClickableWidgetExtension {
    public static final int SCROLLBAR_WIDTH = 6;
    protected double currentScroll = 0.0;
    private boolean scrollbarDragging = false;

    public AbstractScrollViewWidget(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public boolean mouseClicked2(double mouseX, double mouseY, int button) {
        this.scrollbarDragging = button == 0 && this.isOverScrollbar(mouseX, mouseY);
        return super.mouseClicked2(mouseX, mouseY, button);
    }

    public boolean mouseReleased2(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.scrollbarDragging = false;
        }
        return super.mouseReleased2(mouseX, mouseY, button);
    }

    public boolean mouseDragged2(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.f_93624_ && this.isFocused2() && this.scrollbarDragging) {
            double remainingHeight = this.getContentHeight() - this.getHeight2();
            int s1 = this.getHeight2() * this.getHeight2() / this.getContentHeight();
            double scrollScale = remainingHeight / ((double)this.getHeight2() - (double)s1);
            this.setScroll(this.currentScroll + deltaY * scrollScale);
            return true;
        }
        return false;
    }

    public boolean mouseScrolled2(double mouseX, double mouseY, double amount) {
        double oldScroll = this.currentScroll;
        this.setScroll(this.currentScroll - (amount *= 15.0));
        return oldScroll != this.currentScroll;
    }

    public boolean keyPressed2(int keyCode, int scanCode, int modifiers) {
        boolean bl2;
        boolean bl = keyCode == 265;
        boolean bl3 = bl2 = keyCode == 264;
        if (bl || bl2) {
            double oldScroll = this.currentScroll;
            if (bl) {
                this.setScroll(this.currentScroll - 15.0);
            } else {
                this.setScroll(this.currentScroll + 15.0);
            }
            if (oldScroll != this.currentScroll) {
                return true;
            }
        }
        return super.keyPressed2(keyCode, scanCode, modifiers);
    }

    protected boolean contentOverflowed() {
        return this.getContentHeight() > this.getHeight2();
    }

    protected int getScrollbarOffset() {
        return this.contentOverflowed() ? 6 : 0;
    }

    public void setScroll(double scroll) {
        this.currentScroll = scroll < 0.0 || !this.contentOverflowed() ? 0.0 : (scroll > (double)(this.getContentHeight() - this.getHeight2()) ? (double)(this.getContentHeight() - this.getHeight2()) : scroll);
    }

    private void renderScrollbar(GuiDrawing guiDrawing, boolean isMouseOverScrollbar) {
        if (!this.contentOverflowed()) {
            return;
        }
        int fullHeight = this.getContentHeight();
        int visibleHeight = this.getHeight2();
        double scrollbarHeight = (double)visibleHeight * ((double)visibleHeight / (double)fullHeight);
        double bottomOffset = this.currentScroll / (double)(fullHeight - visibleHeight);
        double yOffset = bottomOffset * ((double)visibleHeight - scrollbarHeight);
        GuiHelper.drawRectangle(guiDrawing, this.getX2() + this.getWidth2() - 6, (double)this.getY2() + yOffset, 6.0, scrollbarHeight, isMouseOverScrollbar ? -1 : -4144960);
        GuiHelper.drawRectangle(guiDrawing, this.getX2() + this.getWidth2() - 1, (double)this.getY2() + yOffset, 1.0, scrollbarHeight, -8355712);
        GuiHelper.drawRectangle(guiDrawing, this.getX2() + this.getWidth2() - 6, (double)this.getY2() + yOffset + scrollbarHeight - 1.0, 6.0, 1.0, -8355712);
    }

    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float tickDelta) {
        GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
        ClipStack.push(this.getX2(), this.getY2(), this.getWidth2(), this.getHeight2());
        ClipStack.push(this.getX2(), this.getY2(), this.getWidth2() - this.getScrollbarOffset(), this.getHeight2());
        this.renderContent(graphicsHolder, mouseX, mouseY, tickDelta);
        ClipStack.pop();
        this.renderScrollbar(guiDrawing, this.isOverScrollbar(mouseX, mouseY));
        ClipStack.pop();
    }

    private boolean isOverScrollbar(double mouseX, double mouseY) {
        int scrollbarEndX = this.getX2() + this.getWidth2();
        int scrollbarStartX = scrollbarEndX - this.getScrollbarOffset();
        return mouseX >= (double)scrollbarStartX && mouseX <= (double)scrollbarEndX && mouseY >= (double)this.getY2() && mouseY <= (double)(this.getY2() + this.getHeight2());
    }

    public abstract void renderContent(GraphicsHolder var1, int var2, int var3, float var4);

    protected abstract int getContentHeight();
}

