/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.resources;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.lx862.jcm.mod.JCMClient;
import com.lx862.jcm.mod.scripting.mtr.MTRScripting;
import com.lx862.jcm.mod.util.JCMLogger;
import com.lx862.mtrscripting.core.ParsedScript;
import com.lx862.mtrscripting.data.ScriptContent;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.mapper.ResourceManagerHelper;

public class MTRContentResourceManager {
    private static final HashMap<String, ParsedScript> vehicleScripts = new HashMap();
    private static final HashMap<String, ParsedScript> eyecandyScripts = new HashMap();

    public static void reload() {
        JCMLogger.info("Loading scripts on-behalf of MTR...", new Object[0]);
        eyecandyScripts.clear();
        vehicleScripts.clear();
        MTRContentResourceManager.registerEyecandyScripts();
        MTRContentResourceManager.registerVehicleScripts();
    }

    private static void registerEyecandyScripts() {
        ResourceManagerHelper.readDirectory((String)"eyecandies", (identifier, inputStream) -> {
            if (identifier.getNamespace().equals("mtrsteamloco") && identifier.getPath().endsWith(".json")) {
                try (InputStreamReader isp = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);){
                    JsonObject rootObject = new JsonParser().parse((Reader)isp).getAsJsonObject();
                    if (rootObject.has("model")) {
                        String id = FilenameUtils.getBaseName((String)identifier.getPath());
                        ParsedScript ps = MTRContentResourceManager.tryParseScript(id, "eyecandy", "Block", rootObject, false);
                        eyecandyScripts.put(id, ps);
                    } else {
                        for (Map.Entry entry : rootObject.entrySet()) {
                            String id = (String)entry.getKey();
                            JsonObject entryObject = ((JsonElement)entry.getValue()).getAsJsonObject();
                            ParsedScript ps = MTRContentResourceManager.tryParseScript(id, "eyecandy", "Block", entryObject, false);
                            eyecandyScripts.put(id, ps);
                        }
                    }
                }
                catch (Exception e) {
                    if (JCMClient.getConfig().debug) {
                        JCMLogger.error("Error when parsing eyecandy scripts!", e);
                    }
                    JCMLogger.error("Error when parsing eyecandy scripts: " + e.getMessage(), new Object[0]);
                    JCMLogger.error("(Enable debug mode to see more information)", new Object[0]);
                }
            }
        });
    }

    private static void registerVehicleScripts() {
        ResourceManagerHelper.readAllResources((Identifier)new Identifier("mtr", "mtr_custom_resources.json"), inputStream -> {
            try (InputStreamReader isp = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);){
                JsonObject rootObject = new JsonParser().parse((Reader)isp).getAsJsonObject();
                if (rootObject.has("custom_trains")) {
                    JsonObject vehicleObject = rootObject.get("custom_trains").getAsJsonObject();
                    for (Map.Entry map : vehicleObject.entrySet()) {
                        JsonObject vehicleResource;
                        String baseId = "mtr_custom_train_" + (String)map.getKey();
                        ParsedScript ps = MTRContentResourceManager.tryParseScript(baseId, "vehicle", "Vehicle", vehicleResource = ((JsonElement)map.getValue()).getAsJsonObject(), true);
                        if (ps == null) continue;
                        vehicleScripts.put(baseId + "_trailer", ps);
                        vehicleScripts.put(baseId + "_cab_1", ps);
                        vehicleScripts.put(baseId + "_cab_2", ps);
                        vehicleScripts.put(baseId + "_cab_3", ps);
                    }
                }
            }
            catch (Exception e) {
                if (JCMClient.getConfig().debug) {
                    JCMLogger.error("Error when parsing vehicle scripts!", e);
                }
                JCMLogger.error("Error when parsing vehicle scripts: " + e.getMessage(), new Object[0]);
                JCMLogger.error("(Enable debug mode to see more information)", new Object[0]);
            }
        });
    }

    private static ParsedScript tryParseScript(String id, String name, String contextName, JsonObject jsonObject, boolean useSnakeCase) throws Exception {
        String scriptTextsKey;
        ObjectArrayList scripts = new ObjectArrayList();
        String scriptFilesKey = useSnakeCase ? "script_files" : "scriptFiles";
        String string = scriptTextsKey = useSnakeCase ? "script_texts" : "scriptTexts";
        if (jsonObject.has(scriptFilesKey) || jsonObject.has(scriptTextsKey)) {
            String scriptText;
            Identifier scriptLocation;
            int i;
            if (jsonObject.has(scriptTextsKey)) {
                JsonArray scriptTextArray = jsonObject.get(scriptTextsKey).getAsJsonArray();
                for (i = 0; i < scriptTextArray.size(); ++i) {
                    scriptLocation = new Identifier("jsblock", "script_texts/" + name + "/" + id + "/line" + i);
                    scriptText = scriptTextArray.get(i).getAsString();
                    scripts.add(new ScriptContent(scriptLocation, scriptText));
                }
            }
            if (jsonObject.has(scriptFilesKey)) {
                JsonArray scriptFilesArray = jsonObject.get(scriptFilesKey).getAsJsonArray();
                for (i = 0; i < scriptFilesArray.size(); ++i) {
                    scriptLocation = new Identifier(scriptFilesArray.get(i).getAsString());
                    scriptText = ResourceManagerHelper.readResource((Identifier)scriptLocation);
                    if (scriptText.isEmpty()) {
                        JCMLogger.warn("Script {}:{} is either missing, or the file content is empty!", scriptLocation.getNamespace(), scriptLocation.getPath());
                        continue;
                    }
                    scripts.add(new ScriptContent(scriptLocation, scriptText));
                }
            }
        }
        return scripts.isEmpty() ? null : MTRScripting.getScriptManager().parseScript(id + " (" + name + ")", contextName, (List<ScriptContent>)scripts);
    }

    public static ParsedScript getEyecandyScript(String modelId) {
        return eyecandyScripts.get(modelId);
    }

    public static ParsedScript getVehicleScript(String carriageId) {
        return vehicleScripts.get(carriageId);
    }
}

