/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrscripting.core;

import com.lx862.jcm.mod.config.ClientConfig;
import com.lx862.mtrscripting.api.ClassRule;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.ClassShutter;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Arrays;

public class MTRClassShutter
implements ClassShutter {
    private boolean shutterEnabled;
    private final ObjectList<ClassRule> allowedScriptClasses = new ObjectArrayList();
    private final ObjectList<ClassRule> deniedScriptClasses = new ObjectArrayList();

    public MTRClassShutter() {
        this.allowClass(ClassRule.parse("java.awt.*"), ClassRule.parse("java.time.*"), ClassRule.parse("java.lang.*"), ClassRule.parse("java.math.*"), ClassRule.parse("java.util.*"), ClassRule.parse("javax.imageio.*"), ClassRule.parse("sun.java2d.*"), ClassRule.parse("sun.font.*"), ClassRule.parse("sun.awt.*"), ClassRule.parse("java.io.Closeable"), ClassRule.parse("java.io.InputStream"), ClassRule.parse("java.io.OutputStream"), ClassRule.parse("jdk.*"));
        this.denyClass(ClassRule.parse("java.lang.reflect.*"), ClassRule.parse("jdk.internal.*"));
    }

    public void setEnabled(boolean shutterEnabled) {
        this.shutterEnabled = shutterEnabled;
    }

    public void allowClass(ClassRule ... classRules) {
        this.allowedScriptClasses.addAll(Arrays.asList(classRules));
    }

    public void denyClass(ClassRule ... classRules) {
        this.deniedScriptClasses.addAll(Arrays.asList(classRules));
    }

    @Override
    public boolean visibleToScripts(String fullClassName) {
        return !fullClassName.equals(MTRClassShutter.class.getName()) && !fullClassName.equals(ClientConfig.class.getName()) && this.isClassAllowed(fullClassName);
    }

    private boolean isClassAllowed(String className) {
        if (!this.shutterEnabled) {
            return true;
        }
        if (className.startsWith("com.lx862.mtrscripting.util")) {
            return true;
        }
        if (className.startsWith("com.lx862.mtrscripting.lib.org.mozilla")) {
            return true;
        }
        for (ClassRule cs : this.deniedScriptClasses) {
            if (!cs.match(className)) continue;
            return false;
        }
        for (ClassRule cs : this.allowedScriptClasses) {
            if (!cs.match(className)) continue;
            return true;
        }
        return false;
    }
}

