/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrscripting.util;

import com.lx862.jcm.mod.render.text.TextureTextRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.Closeable;
import java.util.UUID;
import org.mtr.mapping.holder.AbstractTexture;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.NativeImage;
import org.mtr.mapping.holder.NativeImageBackedTexture;

public class GraphicsTexture
implements Closeable {
    private final NativeImageBackedTexture dynamicTexture;
    public final Identifier identifier;
    public final BufferedImage bufferedImage;
    public final Graphics2D graphics;
    public final int width;
    public final int height;

    public GraphicsTexture(int width, int height) {
        this.width = width;
        this.height = height;
        this.dynamicTexture = new NativeImageBackedTexture(new NativeImage(width, height, false));
        this.identifier = new Identifier("mtrscripting", String.format("dynamic/graphics/%s", UUID.randomUUID()));
        MinecraftClient.getInstance().execute(() -> MinecraftClient.getInstance().getTextureManager().registerTexture(this.identifier, new AbstractTexture((net.minecraft.client.renderer.texture.AbstractTexture)this.dynamicTexture.data)));
        this.bufferedImage = new BufferedImage(width, height, 2);
        this.graphics = this.bufferedImage.createGraphics();
        this.graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
    }

    public static BufferedImage createArgbBufferedImage(BufferedImage src) {
        BufferedImage newImage = new BufferedImage(src.getWidth(), src.getHeight(), 2);
        Graphics2D graphics = newImage.createGraphics();
        graphics.drawImage((Image)src, 0, 0, null);
        graphics.dispose();
        return newImage;
    }

    public void upload() {
        int[] biData = ((DataBufferInt)this.bufferedImage.getData().getDataBuffer()).getData();
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                int rgb = biData[this.width * y + x];
                this.dynamicTexture.getImage().setPixelColor(x, y, TextureTextRenderer.toAbgr(rgb));
            }
        }
        RenderSystem.recordRenderCall(() -> ((NativeImageBackedTexture)this.dynamicTexture).upload());
    }

    @Override
    public void close() {
        MinecraftClient.getInstance().execute(() -> MinecraftClient.getInstance().getTextureManager().destroyTexture(this.identifier));
        this.graphics.dispose();
    }
}

