/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import org.apache.logging.log4j.Logger;

public class SimpleTagBuilder
extends TagBuilder {
    private final Set<String> uniqueKeys = new HashSet<String>();
    private final ResourceLocation id;

    protected SimpleTagBuilder(ResourceLocation location) {
        this.id = location;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public static SimpleTagBuilder of(ResourceLocation location) {
        return new SimpleTagBuilder(location);
    }

    public static SimpleTagBuilder of(TagKey<?> key) {
        return new SimpleTagBuilder(key.f_203868_());
    }

    public SimpleTagBuilder merge(SimpleTagBuilder other) {
        this.addAll(other.m_215904_());
        return this;
    }

    public SimpleTagBuilder addAll(Collection<TagEntry> entries) {
        entries.forEach(this::m_215902_);
        return this;
    }

    public TagBuilder m_215902_(TagEntry entry) {
        if (this.validateEntry(entry)) {
            return super.m_215902_(entry);
        }
        return this;
    }

    public SimpleTagBuilder add(ResourceLocation entry) {
        super.m_215900_(entry);
        return this;
    }

    public TagBuilder addOptional(ResourceLocation elementLocation) {
        super.m_215905_(elementLocation);
        return this;
    }

    private boolean validateEntry(TagEntry entry) {
        String string = entry.toString();
        return this.uniqueKeys.add(string);
    }

    public SimpleTagBuilder addTag(ResourceLocation pId) {
        super.m_215907_(pId);
        return this;
    }

    public SimpleTagBuilder addTag(TagKey<?> tagKey) {
        return this.addTag(tagKey.f_203868_());
    }

    public SimpleTagBuilder addOptionalTag(ResourceLocation pId) {
        super.m_215909_(pId);
        return this;
    }

    public SimpleTagBuilder addTag(SimpleTagBuilder otherBuilder) {
        return this.addTag(otherBuilder.getId());
    }

    public SimpleTagBuilder addEntries(Collection<?> entries) {
        entries.forEach(e -> this.add(Utils.getID(e)));
        return this;
    }

    public SimpleTagBuilder addEntry(Object entry) {
        this.add(Utils.getID(entry));
        return this;
    }

    public JsonElement serializeToJson() {
        return (JsonElement)TagFile.f_215958_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new TagFile(this.m_215904_(), false)).getOrThrow(false, arg_0 -> ((Logger)Moonlight.LOGGER).error(arg_0));
    }

    public void addFromJson(JsonObject oldTag) {
        TagFile tagfile = (TagFile)TagFile.f_215958_.parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)oldTag)).getOrThrow(false, arg_0 -> ((Logger)Moonlight.LOGGER).error(arg_0));
        if (tagfile.f_215960_()) {
            // empty if block
        }
        tagfile.f_215959_().forEach(this::m_215902_);
    }
}

