/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.entity;

import com.dairymoose.entity.MotorboatEntity;
import com.dairymoose.entity.MotorboatModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public final class MotorboatRenderer
extends EntityRenderer<MotorboatEntity> {
    private float modelScale = 1.0f;
    private final MotorboatModel motorboatModel;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation texture = new ResourceLocation("modernlife", "textures/item/motorboat_uv.png");

    public MotorboatRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.motorboatModel = new MotorboatModel(ctx.m_174023_(MotorboatModel.MOTORBOAT));
    }

    public boolean shouldRender(MotorboatEntity p_225626_1_, Frustum p_225626_2_, double p_225626_3_, double p_225626_5_, double p_225626_7_) {
        return true;
    }

    public void render(MotorboatEntity motorboatEntity, float p_225623_2_, float p_225623_3_, PoseStack matrixStack, MultiBufferSource buffer, int p_225623_6_) {
        Vec3 pos = motorboatEntity.m_20182_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 1.5, 0.0);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(270.0f - p_225623_2_));
        float lvt_7_1_ = (float)motorboatEntity.getHurtTime() - p_225623_3_;
        float lvt_8_1_ = motorboatEntity.getDamage() - p_225623_3_;
        if (lvt_8_1_ < 0.0f) {
            lvt_8_1_ = 0.0f;
        }
        if (lvt_7_1_ > 0.0f) {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)lvt_7_1_) * lvt_7_1_ * lvt_8_1_ / 10.0f * (float)motorboatEntity.getHurtDir()));
        }
        matrixStack.m_85841_(-this.modelScale, -this.modelScale, this.modelScale);
        this.motorboatModel.m_6973_(motorboatEntity, p_225623_3_, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer builder = buffer.m_6299_(this.motorboatModel.m_103119_(this.getTextureLocation(motorboatEntity)));
        this.motorboatModel.m_7695_(matrixStack, builder, p_225623_6_, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!motorboatEntity.m_5842_()) {
            VertexConsumer vertexconsumer1 = buffer.m_6299_(RenderType.m_110478_());
            this.motorboatModel.waterPatch().m_104301_(matrixStack, vertexconsumer1, p_225623_6_, OverlayTexture.f_118083_);
        }
        matrixStack.m_85849_();
        LivingEntity controller = motorboatEntity.m_6688_();
        if (controller != null && motorboatEntity.f_19797_ % 2 == 0 && motorboatEntity.status == MotorboatEntity.Status.IN_WATER && !motorboatEntity.isOutOfFuel()) {
            Vec3 vec3 = new Vec3(1.65, 0.45, 0.0).m_82524_(-(motorboatEntity.m_146908_() * ((float)Math.PI / 180) - 1.5707964f));
            Vec3 particleLocation = motorboatEntity.m_20182_().m_82549_(vec3);
            int minCount = 1;
            int maxCount = 12;
            int count = minCount;
            if (!motorboatEntity.isBackingUp() && motorboatEntity.m_20184_().m_82556_() > 0.0144) {
                float accelPct = motorboatEntity.getCurAccel() / motorboatEntity.getMaxAccel();
                count = (int)Math.ceil((float)maxCount * accelPct);
                count = Math.max(minCount, count);
            }
            for (int i = 0; i < count; ++i) {
                double xRandMax = 0.6;
                double yRandMax = 0.3;
                double zRandMax = 0.6;
                double xRand = Math.random() * 2.0 * xRandMax - xRandMax;
                double yRand = Math.random() * 2.0 * yRandMax - yRandMax;
                double zRand = Math.random() * 2.0 * zRandMax - zRandMax;
                motorboatEntity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, particleLocation.f_82479_ - xRand, particleLocation.f_82480_ + yRand, particleLocation.f_82481_ + zRand, 1.0, 1.0, 1.0);
            }
        }
        super.m_7392_((Entity)motorboatEntity, p_225623_2_, p_225623_3_, matrixStack, buffer, p_225623_6_);
    }

    public ResourceLocation getTextureLocation(MotorboatEntity var1) {
        return texture;
    }
}

