/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeClient;
import com.dairymoose.modernlife.tileentities.CanvasBlockEntity;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.text.DecimalFormat;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CanvasBlock
extends Block
implements EntityBlock {
    protected static final VoxelShape SHAPE_SOUTH = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_WEST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH);
    protected static final VoxelShape SHAPE_NORTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WEST);
    protected static final VoxelShape SHAPE_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH);
    protected static final VoxelShape SHAPE_SOUTH_SIZE_0 = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)15.99, (double)15.99, (double)1.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_WEST_SIZE_0 = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH_SIZE_0);
    protected static final VoxelShape SHAPE_NORTH_SIZE_0 = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WEST_SIZE_0);
    protected static final VoxelShape SHAPE_EAST_SIZE_0 = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH_SIZE_0);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty SIZE = IntegerProperty.m_61631_((String)"size", (int)0, (int)7);
    public static final int MAX_SIZE = (Integer)SIZE.m_6908_().stream().max((i, i2) -> i - i2).get();

    public CanvasBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283919_).m_60918_(SoundType.f_56754_).m_60913_(1.0f, 10.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.SOUTH)).m_61124_((Property)SIZE, (Comparable)Integer.valueOf(1)));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_6810_(BlockState p_196243_1_, Level p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (!p_196243_1_.m_60713_(p_196243_4_.m_60734_())) {
            BlockEntity lvt_6_1_ = p_196243_2_.m_7702_(p_196243_3_);
            if (lvt_6_1_ instanceof Container) {
                Containers.m_19002_((Level)p_196243_2_, (BlockPos)p_196243_3_, (Container)((Container)lvt_6_1_));
                p_196243_2_.m_46717_(p_196243_3_, (Block)this);
            }
            super.m_6810_(p_196243_1_, p_196243_2_, p_196243_3_, p_196243_4_, p_196243_5_);
        }
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockEntity e;
        if (!worldIn.f_46443_ && (e = worldIn.m_7702_(pos)) instanceof CanvasBlockEntity) {
            CanvasBlockEntity tile = (CanvasBlockEntity)e;
            tile.m_6836_(0, itemStack.m_41777_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockReader, List<Component> list, TooltipFlag tooltipFlag) {
        Long canvasUniqueId = null;
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("UniqueId")) {
            list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("A work of art")));
            long uniqueId = itemStack.m_41783_().m_128454_("UniqueId");
            list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("ID = " + uniqueId)));
            canvasUniqueId = uniqueId;
        } else {
            list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("For use with an easel")));
        }
        if (canvasUniqueId != null) {
            int width = ModernLifeClient.getCanvasWidth(canvasUniqueId);
            int height = ModernLifeClient.getCanvasHeight(canvasUniqueId);
            list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(width + "x" + height + " pixels")));
        }
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("Size")) {
            int size = itemStack.m_41783_().m_128451_("Size");
            list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("")));
            if (size == 1) {
                list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Normal print")));
            } else if (size == 2) {
                list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Large print")));
            } else if (size == 3) {
                list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Extra Large print")));
            } else if (size == 4) {
                list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Massive print")));
            } else if (size == 5) {
                list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Large square print")));
            } else if (size == 6) {
                list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Extra Large square print")));
            } else if (size == 7) {
                list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Massive square print")));
            } else if (size == 0) {
                list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Custom print")));
                CompoundTag nbt = itemStack.m_41783_();
                DecimalFormat df = new DecimalFormat("#.##");
                if (nbt.m_128441_("BlockWidth") && nbt.m_128441_("BlockHeight")) {
                    float blockWidth = nbt.m_128457_("BlockWidth");
                    float blockHeight = nbt.m_128457_("BlockHeight");
                    list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(df.format(blockWidth) + "x" + df.format(blockHeight))));
                }
                if (nbt.m_128441_("xOffset") && nbt.m_128441_("yOffset")) {
                    float xOffset = nbt.m_128457_("xOffset");
                    float yOffset = nbt.m_128457_("yOffset");
                    if (xOffset != 0.0f || yOffset != 0.0f) {
                        list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("(" + df.format(xOffset) + ", " + df.format(yOffset) + ")")));
                    }
                }
            }
        }
    }

    public BlockState m_7417_(BlockState p_196271_1_, Direction p_196271_2_, BlockState p_196271_3_, LevelAccessor p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        return ((Direction)p_196271_1_.m_61143_((Property)FACING)).m_122424_() == p_196271_2_ && !p_196271_1_.m_60710_((LevelReader)p_196271_4_, p_196271_5_) ? Blocks.f_50016_.m_49966_() : super.m_7417_(p_196271_1_, p_196271_2_, p_196271_3_, p_196271_4_, p_196271_5_, p_196271_6_);
    }

    public VoxelShape m_5940_(BlockState bs, BlockGetter reader, BlockPos pos, CollisionContext sel) {
        if ((Integer)bs.m_61143_((Property)SIZE) == 0) {
            switch ((Direction)bs.m_61143_((Property)FACING)) {
                case NORTH: {
                    return SHAPE_NORTH_SIZE_0;
                }
                case SOUTH: {
                    return SHAPE_SOUTH_SIZE_0;
                }
                case EAST: {
                    return SHAPE_EAST_SIZE_0;
                }
                case WEST: {
                    return SHAPE_WEST_SIZE_0;
                }
            }
        }
        switch ((Direction)bs.m_61143_((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_NORTH;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        CanvasBlockEntity toReturn = (CanvasBlockEntity)CanvasBlockEntity.CANVAS.m_155264_(pos, state);
        return toReturn;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SIZE});
    }

    public boolean m_7898_(BlockState p_196260_1_, LevelReader p_196260_2_, BlockPos p_196260_3_) {
        return FaceAttachedHorizontalDirectionalBlock.m_53196_((LevelReader)p_196260_2_, (BlockPos)p_196260_3_, (Direction)((Direction)p_196260_1_.m_61143_((Property)FACING)).m_122424_());
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        for (Direction lvt_5_1_ : context.m_6232_()) {
            int size;
            BlockState lvt_6_2_;
            if (lvt_5_1_.m_122434_() == Direction.Axis.Y || !(lvt_6_2_ = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)lvt_5_1_.m_122424_())).m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            ItemStack itemStack = context.m_43722_();
            if (itemStack != null && itemStack.m_41720_() == CustomBlocks.ITEM_CANVAS.get() && itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("Size") && (size = itemStack.m_41783_().m_128451_("Size")) >= 0 && size <= MAX_SIZE) {
                lvt_6_2_ = (BlockState)lvt_6_2_.m_61124_((Property)SIZE, (Comparable)Integer.valueOf(size));
            }
            return lvt_6_2_;
        }
        return this.m_49966_();
    }
}

