/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CatwalkBlock
extends Block {
    protected static final VoxelShape SHAPE_WEST_LONG_WALL = Stream.of(Block.m_49796_((double)0.8, (double)1.0, (double)0.0, (double)2.4, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_EAST_LONG_WALL = Stream.of(Block.m_49796_((double)13.6, (double)1.0, (double)0.0, (double)15.2, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_NORTH_LONG_WALL = Stream.of(Block.m_49796_((double)0.0, (double)1.0, (double)0.8, (double)16.0, (double)16.0, (double)2.4)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_SOUTH_LONG_WALL = Stream.of(Block.m_49796_((double)0.0, (double)1.0, (double)13.6, (double)16.0, (double)16.0, (double)15.2)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_WEST_WALL = Stream.of(Block.m_49796_((double)0.8, (double)1.0, (double)0.8, (double)2.4, (double)16.0, (double)15.2)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_EAST_WALL = Stream.of(Block.m_49796_((double)13.6, (double)1.0, (double)0.8, (double)15.2, (double)16.0, (double)13.6)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_NORTH_WALL = Stream.of(Block.m_49796_((double)2.4, (double)1.0, (double)0.8, (double)13.6, (double)16.0, (double)2.4)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_SOUTH_WALL = Stream.of(Block.m_49796_((double)2.4, (double)1.0, (double)13.6, (double)15.2, (double)16.0, (double)15.2)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_FLOOR_BIG = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_FLOOR = Stream.of(Block.m_49796_((double)0.8, (double)0.0, (double)0.8, (double)15.2, (double)1.0, (double)15.2)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_X_AXIS = Stream.of(SHAPE_NORTH_WALL, SHAPE_SOUTH_WALL, SHAPE_FLOOR).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_Z_AXIS = Stream.of(SHAPE_EAST_WALL, SHAPE_WEST_WALL, SHAPE_FLOOR).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_ONE_BORDER_N = Stream.of(SHAPE_SOUTH_WALL, SHAPE_FLOOR).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_ONE_BORDER_E = Stream.of(SHAPE_WEST_WALL, SHAPE_FLOOR).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_ONE_BORDER_W = Stream.of(SHAPE_EAST_WALL, SHAPE_FLOOR).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_ONE_BORDER_S = Stream.of(SHAPE_NORTH_WALL, SHAPE_FLOOR).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_NORTH_END = Stream.of(SHAPE_NORTH_WALL, SHAPE_EAST_WALL, SHAPE_WEST_WALL, SHAPE_FLOOR).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_EAST_END = Stream.of(SHAPE_EAST_WALL, SHAPE_NORTH_WALL, SHAPE_SOUTH_WALL, SHAPE_FLOOR).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_SOUTH_END = Stream.of(SHAPE_SOUTH_WALL, SHAPE_EAST_WALL, SHAPE_WEST_WALL, SHAPE_FLOOR).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_WEST_END = Stream.of(SHAPE_WEST_WALL, SHAPE_NORTH_WALL, SHAPE_SOUTH_WALL, SHAPE_FLOOR).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_NE_CORNER = Stream.of(SHAPE_NORTH_WALL, SHAPE_EAST_WALL, SHAPE_FLOOR).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_NW_CORNER = Stream.of(SHAPE_NORTH_WALL, SHAPE_WEST_WALL, SHAPE_FLOOR).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_SE_CORNER = Stream.of(SHAPE_SOUTH_WALL, SHAPE_EAST_WALL, SHAPE_FLOOR).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_SW_CORNER = Stream.of(SHAPE_SOUTH_WALL, SHAPE_WEST_WALL, SHAPE_FLOOR).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_BOX = Stream.of(SHAPE_WEST_WALL, SHAPE_EAST_WALL, SHAPE_NORTH_WALL, SHAPE_SOUTH_WALL, SHAPE_FLOOR).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final EnumProperty<CatwalkType> TYPE = EnumProperty.m_61587_((String)"type", CatwalkType.class);
    public static final BooleanProperty NE_POST = BooleanProperty.m_61465_((String)"ne_post");
    public static final BooleanProperty SE_POST = BooleanProperty.m_61465_((String)"se_post");
    public static final BooleanProperty SW_POST = BooleanProperty.m_61465_((String)"sw_post");
    public static final BooleanProperty NW_POST = BooleanProperty.m_61465_((String)"nw_post");
    public static final BooleanProperty ALTERED = BooleanProperty.m_61465_((String)"altered");

    public VoxelShape m_5940_(BlockState bs, BlockGetter reader, BlockPos pos, CollisionContext sel) {
        switch ((CatwalkType)((Object)bs.m_61143_(TYPE))) {
            case single: {
                return SHAPE_BOX;
            }
            case mid: {
                return SHAPE_FLOOR;
            }
            case one_border_n: {
                return SHAPE_ONE_BORDER_N;
            }
            case one_border_e: {
                return SHAPE_ONE_BORDER_E;
            }
            case one_border_s: {
                return SHAPE_ONE_BORDER_S;
            }
            case one_border_w: {
                return SHAPE_ONE_BORDER_W;
            }
            case x_axis: {
                return SHAPE_X_AXIS;
            }
            case z_axis: {
                return SHAPE_Z_AXIS;
            }
            case s_end: {
                return SHAPE_SOUTH_END;
            }
            case w_end: {
                return SHAPE_WEST_END;
            }
            case n_end: {
                return SHAPE_NORTH_END;
            }
            case e_end: {
                return SHAPE_EAST_END;
            }
            case ne_corner: {
                return SHAPE_NE_CORNER;
            }
            case nw_corner: {
                return SHAPE_NW_CORNER;
            }
            case se_corner: {
                return SHAPE_SE_CORNER;
            }
            case sw_corner: {
                return SHAPE_SW_CORNER;
            }
        }
        return SHAPE_BOX;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult p_225533_6_) {
        if (player.m_20161_() && hand == InteractionHand.MAIN_HAND && player.m_21120_(hand).m_41619_()) {
            if (!level.f_46443_) {
                CatwalkType initialType = (CatwalkType)((Object)state.m_61143_(TYPE));
                Direction dir = player.m_6350_();
                CatwalkType newType = null;
                if (initialType == CatwalkType.w_end && dir == Direction.NORTH) {
                    newType = CatwalkType.nw_corner;
                } else if (initialType == CatwalkType.w_end && dir == Direction.SOUTH) {
                    newType = CatwalkType.sw_corner;
                } else if (initialType == CatwalkType.w_end) {
                    newType = CatwalkType.x_axis;
                } else if (initialType == CatwalkType.e_end && dir == Direction.NORTH) {
                    newType = CatwalkType.ne_corner;
                } else if (initialType == CatwalkType.e_end && dir == Direction.SOUTH) {
                    newType = CatwalkType.se_corner;
                } else if (initialType == CatwalkType.e_end) {
                    newType = CatwalkType.x_axis;
                } else if (initialType == CatwalkType.s_end && dir == Direction.EAST) {
                    newType = CatwalkType.se_corner;
                } else if (initialType == CatwalkType.s_end && dir == Direction.WEST) {
                    newType = CatwalkType.sw_corner;
                } else if (initialType == CatwalkType.s_end) {
                    newType = CatwalkType.z_axis;
                } else if (initialType == CatwalkType.n_end && dir == Direction.EAST) {
                    newType = CatwalkType.ne_corner;
                } else if (initialType == CatwalkType.n_end && dir == Direction.WEST) {
                    newType = CatwalkType.nw_corner;
                } else if (initialType == CatwalkType.n_end) {
                    newType = CatwalkType.z_axis;
                } else if (initialType == CatwalkType.x_axis && dir == Direction.NORTH) {
                    newType = CatwalkType.one_border_s;
                } else if (initialType == CatwalkType.x_axis && dir == Direction.SOUTH) {
                    newType = CatwalkType.one_border_n;
                } else if (initialType == CatwalkType.z_axis && dir == Direction.WEST) {
                    newType = CatwalkType.one_border_e;
                } else if (initialType == CatwalkType.z_axis && dir == Direction.EAST) {
                    newType = CatwalkType.one_border_w;
                } else if (initialType == CatwalkType.one_border_e || initialType == CatwalkType.one_border_w || initialType == CatwalkType.one_border_n || initialType == CatwalkType.one_border_s) {
                    newType = CatwalkType.mid;
                } else if (initialType == CatwalkType.ne_corner && dir == Direction.WEST) {
                    newType = CatwalkType.one_border_s;
                } else if (initialType == CatwalkType.ne_corner && dir == Direction.SOUTH) {
                    newType = CatwalkType.one_border_w;
                } else if (initialType == CatwalkType.nw_corner && dir == Direction.EAST) {
                    newType = CatwalkType.one_border_s;
                } else if (initialType == CatwalkType.nw_corner && dir == Direction.SOUTH) {
                    newType = CatwalkType.one_border_e;
                } else if (initialType == CatwalkType.se_corner && dir == Direction.WEST) {
                    newType = CatwalkType.one_border_n;
                } else if (initialType == CatwalkType.se_corner && dir == Direction.NORTH) {
                    newType = CatwalkType.one_border_w;
                } else if (initialType == CatwalkType.sw_corner && dir == Direction.EAST) {
                    newType = CatwalkType.one_border_n;
                } else if (initialType == CatwalkType.sw_corner && dir == Direction.NORTH) {
                    newType = CatwalkType.one_border_e;
                }
                if (newType != initialType && newType != null) {
                    level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)ALTERED, (Comparable)Boolean.valueOf(true))).m_61124_(TYPE, (Comparable)((Object)newType)), 2);
                }
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getNewState((LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState updater, LevelAccessor world, BlockPos pos, BlockPos updaterPos) {
        if (((Boolean)state.m_61143_((Property)ALTERED)).booleanValue()) {
            return state;
        }
        return this.getNewState(world, pos);
    }

    protected BlockState applyCatwalkPosts(BlockState state, boolean useNePost, boolean useNwPost, boolean useSePost, boolean useSwPost) {
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NE_POST, (Comparable)Boolean.valueOf(useNePost))).m_61124_((Property)NW_POST, (Comparable)Boolean.valueOf(useNwPost))).m_61124_((Property)SE_POST, (Comparable)Boolean.valueOf(useSePost))).m_61124_((Property)SW_POST, (Comparable)Boolean.valueOf(useSwPost));
    }

    protected BlockState getNewState(LevelAccessor world, BlockPos pos) {
        BlockState nState = world.m_8055_(pos.m_122012_());
        BlockState eState = world.m_8055_(pos.m_122029_());
        BlockState sState = world.m_8055_(pos.m_122019_());
        BlockState wState = world.m_8055_(pos.m_122024_());
        int adjacentTableCount = 0;
        boolean nTable = nState.m_60713_((Block)this);
        boolean eTable = eState.m_60713_((Block)this);
        boolean sTable = sState.m_60713_((Block)this);
        boolean wTable = wState.m_60713_((Block)this);
        BlockState neState = world.m_8055_(pos.m_122012_().m_122029_());
        BlockState nwState = world.m_8055_(pos.m_122012_().m_122024_());
        BlockState seState = world.m_8055_(pos.m_122019_().m_122029_());
        BlockState swState = world.m_8055_(pos.m_122019_().m_122024_());
        boolean neTable = neState.m_60713_((Block)this);
        boolean nwTable = nwState.m_60713_((Block)this);
        boolean seTable = seState.m_60713_((Block)this);
        boolean swTable = swState.m_60713_((Block)this);
        boolean useNePost = false;
        boolean useNwPost = false;
        boolean useSePost = false;
        boolean useSwPost = false;
        if (nTable && eTable && !neTable) {
            useNePost = true;
        }
        if (nTable && wTable && !nwTable) {
            useNwPost = true;
        }
        if (sTable && eTable && !seTable) {
            useSePost = true;
        }
        if (sTable && wTable && !swTable) {
            useSwPost = true;
        }
        if (nTable) {
            ++adjacentTableCount;
        }
        if (eTable) {
            ++adjacentTableCount;
        }
        if (sTable) {
            ++adjacentTableCount;
        }
        if (wTable) {
            ++adjacentTableCount;
        }
        if (adjacentTableCount >= 2) {
            if (nTable && eTable && !sTable && !wTable) {
                if (neTable) {
                    return (BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)CatwalkType.sw_corner));
                }
                return (BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)CatwalkType.sw_corner))).m_61124_((Property)NE_POST, (Comparable)Boolean.valueOf(true));
            }
            if (nTable && wTable && !sTable && !eTable) {
                if (nwTable) {
                    return (BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)CatwalkType.se_corner));
                }
                return (BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)CatwalkType.se_corner))).m_61124_((Property)NW_POST, (Comparable)Boolean.valueOf(true));
            }
            if (sTable && eTable && !nTable && !wTable) {
                if (seTable) {
                    return (BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)CatwalkType.nw_corner));
                }
                return (BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)CatwalkType.nw_corner))).m_61124_((Property)SE_POST, (Comparable)Boolean.valueOf(true));
            }
            if (sTable && wTable && !nTable && !eTable) {
                if (swTable) {
                    return (BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)CatwalkType.ne_corner));
                }
                return (BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)CatwalkType.ne_corner))).m_61124_((Property)SW_POST, (Comparable)Boolean.valueOf(true));
            }
            if (adjacentTableCount == 2 && wTable && eTable) {
                return (BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)CatwalkType.x_axis));
            }
            if (adjacentTableCount == 2 && nTable && sTable) {
                return (BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)CatwalkType.z_axis));
            }
            if (adjacentTableCount == 3) {
                if (wTable && nTable && eTable) {
                    return this.applyCatwalkPosts((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)CatwalkType.one_border_n)), useNePost, useNwPost, useSePost, useSwPost);
                }
                if (nTable && eTable && sTable) {
                    return this.applyCatwalkPosts((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)CatwalkType.one_border_e)), useNePost, useNwPost, useSePost, useSwPost);
                }
                if (eTable && sTable && wTable) {
                    return this.applyCatwalkPosts((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)CatwalkType.one_border_s)), useNePost, useNwPost, useSePost, useSwPost);
                }
                if (sTable && wTable && nTable) {
                    return this.applyCatwalkPosts((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)CatwalkType.one_border_w)), useNePost, useNwPost, useSePost, useSwPost);
                }
            }
            if (!(adjacentTableCount != 4 || seTable || swTable || neTable || nwTable)) {
                return this.applyCatwalkPosts((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)CatwalkType.mid)), useNePost, useNwPost, useSePost, useSwPost);
            }
            return this.applyCatwalkPosts((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)CatwalkType.mid)), useNePost, useNwPost, useSePost, useSwPost);
        }
        if (adjacentTableCount == 1) {
            if (nTable) {
                return (BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)CatwalkType.s_end));
            }
            if (eTable) {
                return (BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)CatwalkType.w_end));
            }
            if (sTable) {
                return (BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)CatwalkType.n_end));
            }
            if (wTable) {
                return (BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)CatwalkType.e_end));
            }
        }
        return this.applyCatwalkPosts(this.m_49966_(), useNePost, useNwPost, useSePost, useSwPost);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE, NE_POST, NW_POST, SE_POST, SW_POST, ALTERED});
    }

    public CatwalkBlock(BlockBehaviour.Properties p_i48377_1_) {
        super(p_i48377_1_);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)CatwalkType.single))).m_61124_((Property)NE_POST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NW_POST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SE_POST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SW_POST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ALTERED, (Comparable)Boolean.valueOf(false)));
    }

    public static enum CatwalkType implements StringRepresentable
    {
        single,
        mid,
        one_border_n,
        one_border_e,
        one_border_s,
        one_border_w,
        x_axis,
        z_axis,
        s_end,
        w_end,
        n_end,
        e_end,
        ne_corner,
        se_corner,
        nw_corner,
        sw_corner;


        public String m_7912_() {
            return this.name().toLowerCase();
        }
    }
}

