/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.blocks.AbstractPanelBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.LavaFluid;
import net.minecraft.world.level.material.WaterFluid;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GrateBlock
extends AbstractPanelBlock
implements SimpleWaterloggedBlock {
    private boolean allowAllLiquids = true;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)8);
    public static final EnumProperty<FluidType> FLUIDTYPE = EnumProperty.m_61587_((String)"fluidtype", FluidType.class);
    private static final int MS_PER_TICK = 50;
    private static final float GRATE_SLOWDOWN_FACTOR = 1.0f;
    private static final HashSet<BlockPos> respawning = new HashSet();
    private static final HashMap<BlockPos, Integer> waterLevel = new HashMap();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    protected static final VoxelShape SHAPE_FLOOR_NORTH = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_WALL_NORTH = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_WALL_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WALL_NORTH);
    protected static final VoxelShape SHAPE_WALL_SOUTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WALL_EAST);
    protected static final VoxelShape SHAPE_WALL_WEST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WALL_SOUTH);
    protected static final VoxelShape SHAPE_CEILING_NORTH = Stream.of(Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public GrateBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)FACE, (Comparable)AttachFace.FLOOR)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack m_142598_(LevelAccessor p_154560_, BlockPos p_154561_, BlockState p_154562_) {
        ItemStack fluid = super.m_142598_(p_154560_, p_154561_, p_154562_);
        BlockState newState = p_154560_.m_8055_(p_154561_);
        if (!((Boolean)newState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            ModernLifeCommon.LOGGER.debug("Set level to 0");
            p_154560_.m_7731_(p_154561_, (BlockState)newState.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0)), 3);
        }
        return fluid;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockReader, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Allows water and items to flow through freely")));
    }

    public boolean m_7361_(LevelAccessor p_204509_1_, BlockPos p_204509_2_, BlockState p_204509_3_, FluidState p_204509_4_) {
        if (p_204509_4_.m_76152_() instanceof WaterFluid || p_204509_4_.m_76152_() instanceof LavaFluid) {
            if (p_204509_1_ instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)p_204509_1_;
                FluidType f = FluidType.water;
                if (p_204509_4_.m_76152_() instanceof WaterFluid) {
                    f = FluidType.water;
                } else if (p_204509_4_.m_76152_() instanceof LavaFluid) {
                    f = FluidType.lava;
                }
                int newLevel = p_204509_4_.m_76186_();
                ModernLifeCommon.LOGGER.debug("placeLiquid update: " + p_204509_4_);
                if (p_204509_4_.m_76170_()) {
                    world.m_7731_(p_204509_2_, (BlockState)((BlockState)((BlockState)p_204509_3_.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).m_61124_(FLUIDTYPE, (Comparable)((Object)f))).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(newLevel)), 3);
                } else {
                    world.m_7731_(p_204509_2_, (BlockState)((BlockState)p_204509_3_.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(newLevel))).m_61124_(FLUIDTYPE, (Comparable)((Object)f)), 3);
                }
            }
            return true;
        }
        return false;
    }

    public boolean m_6044_(BlockGetter p_204510_1_, BlockPos p_204510_2_, BlockState p_204510_3_, Fluid p_204510_4_) {
        if (this.allowAllLiquids) {
            return true;
        }
        return super.m_6044_(p_204510_1_, p_204510_2_, p_204510_3_, p_204510_4_);
    }

    public BlockState m_7417_(final BlockState grate, Direction dir, BlockState updater, final LevelAccessor world, BlockPos gratePos, BlockPos updaterPos) {
        ModernLifeCommon.LOGGER.debug("world = " + world);
        ModernLifeCommon.LOGGER.debug("updateShape, bs1: " + grate + " with pos = " + gratePos);
        ModernLifeCommon.LOGGER.debug("updateShape, bs2: " + updater + " with pos = " + updaterPos);
        ModernLifeCommon.LOGGER.debug("direction = " + dir);
        BlockPos.MutableBlockPos originalGratePos = gratePos.m_122032_();
        GrateBlock grateBlock = this;
        this.scheduler.schedule(new Runnable(){
            final /* synthetic */ BlockPos val$originalGratePos;
            final /* synthetic */ GrateBlock val$grateBlock;
            {
                this.val$originalGratePos = blockPos;
                this.val$grateBlock = grateBlock;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Method newLiquidMethod = null;
                try {
                    int currentLevel = (Integer)grate.m_61143_((Property)LEVEL);
                    try {
                        newLiquidMethod = FlowingFluid.class.getDeclaredMethod("m_76035_", LevelReader.class, BlockPos.class, BlockState.class);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (newLiquidMethod == null) {
                        newLiquidMethod = FlowingFluid.class.getDeclaredMethod("getNewLiquid", LevelReader.class, BlockPos.class, BlockState.class);
                    }
                    newLiquidMethod.setAccessible(true);
                    FluidState newFluid = (FluidState)newLiquidMethod.invoke((Object)Fluids.f_76192_, world, this.val$originalGratePos, grate);
                    int newLevel = newFluid.m_76186_();
                    if (newLevel < currentLevel) {
                        BlockState newGrateState = world.m_8055_(this.val$originalGratePos);
                        if (newGrateState.m_60713_((Block)CustomBlocks.BLOCK_METAL_GRATE.get()) && !((Boolean)newGrateState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                            world.m_7731_(this.val$originalGratePos, (BlockState)grate.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(newLevel)), 3);
                        }
                        ModernLifeCommon.LOGGER.debug("Set to new state: " + grate.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(newLevel)));
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                    ModernLifeCommon.LOGGER.error("getNewLiquid error", (Throwable)e1);
                }
                finally {
                    this.val$grateBlock.allowAllLiquids = true;
                }
            }
        }, (long)((int)((float)(50 * updater.m_60819_().m_76152_().m_6718_((LevelReader)world)) * 1.0f)), TimeUnit.MILLISECONDS);
        return grate;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter blockReader, BlockPos blockPos, CollisionContext ctx) {
        Entity collisionEntity = null;
        if (ctx instanceof EntityCollisionContext) {
            Entity entity = collisionEntity = ((EntityCollisionContext)ctx).m_193113_() != null ? ((EntityCollisionContext)ctx).m_193113_() : null;
        }
        if (ctx == CollisionContext.m_82749_() || collisionEntity != null && (collisionEntity instanceof ItemEntity || collisionEntity instanceof ExperienceOrb)) {
            return Shapes.m_83040_();
        }
        return super.m_5939_(state, blockReader, blockPos, ctx);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos;
        FluidType f = FluidType.water;
        Level world = context.m_43725_();
        BlockState oldState = world.m_8055_(pos = context.m_8083_());
        if (oldState.m_60819_().m_76152_() instanceof WaterFluid) {
            f = FluidType.water;
        } else if (oldState.m_60819_().m_76152_() instanceof LavaFluid) {
            f = FluidType.lava;
        }
        boolean waterlogged = false;
        if (!oldState.m_60819_().m_76178_() && oldState.m_60819_().m_76170_()) {
            waterlogged = true;
        }
        return (BlockState)((BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(oldState.m_60819_().m_76186_()))).m_61124_(FLUIDTYPE, (Comparable)((Object)f))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    @Deprecated
    public void m_6807_(final BlockState newState, final Level world, final BlockPos pos, BlockState oldState, boolean p_220082_5_) {
        int level;
        ModernLifeCommon.LOGGER.debug("onPlace newState = " + newState + ", bool=" + p_220082_5_);
        if (!(oldState.m_60734_() instanceof LiquidBlock) || !oldState.m_60819_().m_76178_()) {
            // empty if block
        }
        if ((level = ((Integer)newState.m_61143_((Property)LEVEL)).intValue()) >= 0) {
            GrateBlock thisBlock = this;
            this.scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    FlowingFluid fluid = Fluids.f_76193_;
                    if (newState.m_61143_(FLUIDTYPE) == FluidType.water) {
                        fluid = Fluids.f_76193_;
                    } else if (newState.m_61143_(FLUIDTYPE) == FluidType.lava) {
                        fluid = Fluids.f_76195_;
                    }
                    int level = (Integer)newState.m_61143_((Property)LEVEL);
                    Method m = null;
                    try {
                        try {
                            m = FlowingFluid.class.getDeclaredMethod("m_76010_", LevelAccessor.class, BlockPos.class, FluidState.class);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                        if (m == null) {
                            m = FlowingFluid.class.getDeclaredMethod("spread", LevelAccessor.class, BlockPos.class, FluidState.class);
                        }
                        m.setAccessible(true);
                        FluidState fs = Fluids.f_76191_.m_76145_();
                        if (level > 0 && fluid instanceof FlowingFluid) {
                            fs = fluid.m_75953_(level, false);
                            m.invoke((Object)fluid, world, pos, fs);
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        ModernLifeCommon.LOGGER.error("Fluid error", (Throwable)e);
                    }
                    world.m_46672_(pos, newState.m_60734_());
                }
            }, (long)(50 * this.m_5888_(newState).m_76152_().m_6718_((LevelReader)world)), TimeUnit.MILLISECONDS);
        } else {
            world.m_46672_(pos, newState.m_60734_());
        }
    }

    @Deprecated
    public FluidState m_5888_(BlockState state) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() && state.m_61143_(FLUIDTYPE) == FluidType.water) {
            return Fluids.f_76193_.m_76068_(false);
        }
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() && state.m_61143_(FLUIDTYPE) == FluidType.lava) {
            return Fluids.f_76195_.m_76068_(false);
        }
        if ((Integer)state.m_61143_((Property)LEVEL) > 0 && state.m_61143_(FLUIDTYPE) == FluidType.water) {
            return Fluids.f_76193_.m_75953_(((Integer)state.m_61143_((Property)LEVEL)).intValue(), false);
        }
        if ((Integer)state.m_61143_((Property)LEVEL) > 0 && state.m_61143_(FLUIDTYPE) == FluidType.lava) {
            return Fluids.f_76195_.m_75953_(((Integer)state.m_61143_((Property)LEVEL)).intValue(), false);
        }
        return Fluids.f_76191_.m_76145_();
    }

    public void m_6810_(BlockState oldState, Level p_196243_2_, BlockPos pos, BlockState newState, boolean p_196243_5_) {
        ModernLifeCommon.LOGGER.debug("Being changed to : " + newState);
        if (newState.m_60713_(Blocks.f_49990_) || newState.m_60713_(Blocks.f_50016_)) {
            ModernLifeCommon.LOGGER.debug("Respawn: " + oldState);
        }
        if (newState.m_60713_(Blocks.f_49991_)) {
            // empty if block
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, FACE, WATERLOGGED, LEVEL, FLUIDTYPE});
    }

    public VoxelShape m_5940_(BlockState bs, BlockGetter reader, BlockPos pos, CollisionContext sel) {
        switch ((AttachFace)bs.m_61143_((Property)FACE)) {
            case FLOOR: {
                return SHAPE_FLOOR_NORTH;
            }
            case WALL: {
                switch ((Direction)bs.m_61143_((Property)FACING)) {
                    case NORTH: {
                        return SHAPE_WALL_NORTH;
                    }
                    case EAST: {
                        return SHAPE_WALL_EAST;
                    }
                    case WEST: {
                        return SHAPE_WALL_WEST;
                    }
                    case SOUTH: {
                        return SHAPE_WALL_SOUTH;
                    }
                }
            }
            case CEILING: {
                return SHAPE_CEILING_NORTH;
            }
        }
        return SHAPE_FLOOR_NORTH;
    }

    public static enum FluidType implements StringRepresentable
    {
        water,
        lava;


        public String m_7912_() {
            return this.name().toLowerCase();
        }
    }
}

