/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.entity.DummyEntity;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SofaBlock
extends Block {
    protected static final VoxelShape SHAPE_SOUTH_SINGLE = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)17.0, (double)3.0), Block.m_49796_((double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)11.0, (double)16.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)16.0), Block.m_49796_((double)3.25, (double)4.0, (double)4.0, (double)12.75, (double)7.0, (double)15.0), Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)11.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_WEST_SINGLE = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH_SINGLE);
    protected static final VoxelShape SHAPE_NORTH_SINGLE = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WEST_SINGLE);
    protected static final VoxelShape SHAPE_EAST_SINGLE = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH_SINGLE);
    protected static final VoxelShape SHAPE_SOUTH_MIDDLE = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)17.0, (double)3.0), Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)7.0, (double)15.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_WEST_MIDDLE = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH_MIDDLE);
    protected static final VoxelShape SHAPE_NORTH_MIDDLE = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WEST_MIDDLE);
    protected static final VoxelShape SHAPE_EAST_MIDDLE = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH_MIDDLE);
    protected static final VoxelShape SHAPE_SOUTH_LEFT = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)17.0, (double)3.0), Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)11.0, (double)16.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)3.25, (double)4.0, (double)4.0, (double)16.0, (double)7.0, (double)15.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_WEST_LEFT = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH_LEFT);
    protected static final VoxelShape SHAPE_NORTH_LEFT = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WEST_LEFT);
    protected static final VoxelShape SHAPE_EAST_LEFT = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH_LEFT);
    protected static final VoxelShape SHAPE_SOUTH_RIGHT = Stream.of(Block.m_49796_((double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)11.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)17.0, (double)3.0), Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)12.75, (double)7.0, (double)15.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_WEST_RIGHT = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH_RIGHT);
    protected static final VoxelShape SHAPE_NORTH_RIGHT = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WEST_RIGHT);
    protected static final VoxelShape SHAPE_EAST_RIGHT = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH_RIGHT);
    protected static final VoxelShape SHAPE_SOUTH_CORNER = Stream.of(Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)15.0, (double)7.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)17.0, (double)3.0), Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)17.0, (double)16.0), Block.m_49796_((double)15.0, (double)4.0, (double)4.0, (double)16.0, (double)7.0, (double)15.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_WEST_CORNER = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH_CORNER);
    protected static final VoxelShape SHAPE_NORTH_CORNER = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WEST_CORNER);
    protected static final VoxelShape SHAPE_EAST_CORNER = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH_CORNER);
    public static final EnumProperty<SofaType> TYPE;
    public static final DirectionProperty FACING;

    public SofaBlock(BlockBehaviour.Properties p_i48377_1_) {
        super(p_i48377_1_);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)((Object)SofaType.single)));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(BlockState p_225533_1_, Level p_225533_2_, BlockPos p_225533_3_, Player player, InteractionHand p_225533_5_, BlockHitResult p_225533_6_) {
        if (!p_225533_2_.f_46443_) {
            DummyEntity dummy = DummyEntity.getEntity(0.23f, p_225533_2_, p_225533_3_, false);
            dummy.ride(player);
        }
        return InteractionResult.CONSUME;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction newFacing = context.m_8125_().m_122424_();
        BlockState state = this.getNewState(null, (LevelAccessor)context.m_43725_(), context.m_8083_(), newFacing);
        if (state == null) {
            state = this.m_49966_();
        }
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)newFacing);
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState updater, LevelAccessor world, BlockPos pos, BlockPos updaterPos) {
        return this.getNewState(state, world, pos, (Direction)state.m_61143_((Property)FACING));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, TYPE});
    }

    private BlockState getNewState(BlockState currentState, LevelAccessor world, BlockPos pos, Direction facing) {
        if (currentState == null) {
            currentState = this.m_49966_();
        }
        BlockState cwState = world.m_8055_(pos.m_121945_(facing.m_122427_()));
        BlockState ccwState = world.m_8055_(pos.m_121945_(facing.m_122428_()));
        BlockState frontState = world.m_8055_(pos.m_121945_(facing));
        int adjacentSofaCount = 0;
        boolean cwSofa = cwState.m_60713_((Block)this) && (cwState.m_61143_((Property)FACING) == facing || cwState.m_61143_(TYPE) == SofaType.corner);
        boolean ccwSofa = ccwState.m_60713_((Block)this) && (ccwState.m_61143_((Property)FACING) == facing || ccwState.m_61143_(TYPE) == SofaType.corner);
        boolean frontSofa = frontState.m_60713_((Block)this);
        if (cwSofa) {
            ++adjacentSofaCount;
        }
        if (ccwSofa) {
            ++adjacentSofaCount;
        }
        if (adjacentSofaCount >= 2) {
            return (BlockState)currentState.m_61124_(TYPE, (Comparable)((Object)SofaType.middle));
        }
        if (adjacentSofaCount == 1) {
            if (frontSofa) {
                BlockState adjacentSofa = null;
                adjacentSofa = cwState.m_60713_((Block)this) ? cwState : ccwState;
                if (adjacentSofa.m_61143_((Property)FACING) == facing) {
                    Direction withDirection = facing;
                    if (adjacentSofa != ccwState) {
                        withDirection = (Direction)frontState.m_61143_((Property)FACING);
                    }
                    return (BlockState)((BlockState)currentState.m_61124_(TYPE, (Comparable)((Object)SofaType.corner))).m_61124_((Property)FACING, (Comparable)withDirection);
                }
            }
            if (cwSofa) {
                return (BlockState)currentState.m_61124_(TYPE, (Comparable)((Object)SofaType.right));
            }
            if (ccwSofa) {
                return (BlockState)currentState.m_61124_(TYPE, (Comparable)((Object)SofaType.left));
            }
        }
        return (BlockState)currentState.m_61124_(TYPE, (Comparable)((Object)SofaType.single));
    }

    public VoxelShape m_5940_(BlockState bs, BlockGetter reader, BlockPos pos, CollisionContext sel) {
        if (bs.m_61143_(TYPE) == SofaType.single) {
            switch ((Direction)bs.m_61143_((Property)FACING)) {
                case NORTH: {
                    return SHAPE_NORTH_SINGLE;
                }
                case SOUTH: {
                    return SHAPE_SOUTH_SINGLE;
                }
                case EAST: {
                    return SHAPE_EAST_SINGLE;
                }
                case WEST: {
                    return SHAPE_WEST_SINGLE;
                }
            }
        } else if (bs.m_61143_(TYPE) == SofaType.middle) {
            switch ((Direction)bs.m_61143_((Property)FACING)) {
                case NORTH: {
                    return SHAPE_NORTH_MIDDLE;
                }
                case SOUTH: {
                    return SHAPE_SOUTH_MIDDLE;
                }
                case EAST: {
                    return SHAPE_EAST_MIDDLE;
                }
                case WEST: {
                    return SHAPE_WEST_MIDDLE;
                }
            }
        } else if (bs.m_61143_(TYPE) == SofaType.left) {
            switch ((Direction)bs.m_61143_((Property)FACING)) {
                case NORTH: {
                    return SHAPE_NORTH_LEFT;
                }
                case SOUTH: {
                    return SHAPE_SOUTH_LEFT;
                }
                case EAST: {
                    return SHAPE_EAST_LEFT;
                }
                case WEST: {
                    return SHAPE_WEST_LEFT;
                }
            }
        } else if (bs.m_61143_(TYPE) == SofaType.right) {
            switch ((Direction)bs.m_61143_((Property)FACING)) {
                case NORTH: {
                    return SHAPE_NORTH_RIGHT;
                }
                case SOUTH: {
                    return SHAPE_SOUTH_RIGHT;
                }
                case EAST: {
                    return SHAPE_EAST_RIGHT;
                }
                case WEST: {
                    return SHAPE_WEST_RIGHT;
                }
            }
        } else if (bs.m_61143_(TYPE) == SofaType.corner) {
            switch ((Direction)bs.m_61143_((Property)FACING)) {
                case NORTH: {
                    return SHAPE_NORTH_CORNER;
                }
                case SOUTH: {
                    return SHAPE_SOUTH_CORNER;
                }
                case EAST: {
                    return SHAPE_EAST_CORNER;
                }
                case WEST: {
                    return SHAPE_WEST_CORNER;
                }
            }
        }
        return SHAPE_NORTH_SINGLE;
    }

    static {
        FACING = BlockStateProperties.f_61374_;
        TYPE = EnumProperty.m_61587_((String)"type", SofaType.class);
    }

    public static enum SofaType implements StringRepresentable
    {
        single,
        middle,
        left,
        right,
        corner;


        public String m_7912_() {
            return this.name().toLowerCase();
        }
    }
}

