/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.core.ModernLifeConfig;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StreetLightBlock
extends Block {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final DirectionProperty FACING;
    public static final EnumProperty<PartType> PART;
    protected static final VoxelShape SHAPE_NORTH;
    protected static final VoxelShape SHAPE_EAST;
    protected static final VoxelShape SHAPE_SOUTH;
    protected static final VoxelShape SHAPE_WEST;
    protected static final VoxelShape SHAPE_NORTH_TOP;
    protected static final VoxelShape SHAPE_EAST_TOP;
    protected static final VoxelShape SHAPE_SOUTH_TOP;
    protected static final VoxelShape SHAPE_WEST_TOP;
    public static int MID_PART_COUNT;

    public StreetLightBlock(BlockBehaviour.Properties props) {
        super(props.m_60953_(StreetLightBlock::getLightLevel).m_60991_(new BlockBehaviour.StatePredicate(){

            public boolean m_61035_(BlockState state, BlockGetter reader, BlockPos pos) {
                return state.m_61143_(PART) == PartType.top;
            }
        }));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(PART, (Comparable)((Object)PartType.bottom)));
    }

    public static int getLightLevel(BlockState state) {
        if (state.m_61143_(PART) == PartType.top) {
            return 15;
        }
        return 0;
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        if (p_220053_1_.m_61143_(PART) == PartType.top) {
            return SHAPE_NORTH_TOP;
        }
        Direction lvt_5_1_ = (Direction)p_220053_1_.m_61143_((Property)FACING);
        switch (lvt_5_1_) {
            default: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case NORTH: 
        }
        return SHAPE_NORTH;
    }

    public BlockState m_7417_(BlockState p_196271_1_, Direction p_196271_2_, BlockState p_196271_3_, LevelAccessor p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        PartType lvt_7_1_ = (PartType)((Object)p_196271_1_.m_61143_(PART));
        if (lvt_7_1_ == PartType.mid) {
            if (!(p_196271_2_ != Direction.UP && p_196271_2_ != Direction.DOWN || p_196271_3_.m_60713_((Block)this))) {
                return Blocks.f_50016_.m_49966_();
            }
            return super.m_7417_(p_196271_1_, p_196271_2_, p_196271_3_, p_196271_4_, p_196271_5_, p_196271_6_);
        }
        if (p_196271_2_.m_122434_() == Direction.Axis.Y && lvt_7_1_ == PartType.bottom == (p_196271_2_ == Direction.UP)) {
            if (lvt_7_1_ == PartType.top) {
                if (p_196271_3_.m_60713_((Block)this)) {
                    return p_196271_1_;
                }
                return Blocks.f_50016_.m_49966_();
            }
            return p_196271_3_.m_60713_((Block)this) && p_196271_3_.m_61143_(PART) != lvt_7_1_ ? (BlockState)p_196271_1_.m_61124_((Property)FACING, (Comparable)((Direction)p_196271_3_.m_61143_((Property)FACING))) : Blocks.f_50016_.m_49966_();
        }
        return lvt_7_1_ == PartType.bottom && p_196271_2_ == Direction.DOWN && !p_196271_1_.m_60710_((LevelReader)p_196271_4_, p_196271_5_) ? Blocks.f_50016_.m_49966_() : super.m_7417_(p_196271_1_, p_196271_2_, p_196271_3_, p_196271_4_, p_196271_5_, p_196271_6_);
    }

    protected static void preventCreativeDropFromBottomPart(Level p_241471_0_, BlockPos p_241471_1_, BlockState p_241471_2_, Player p_241471_3_) {
        BlockPos blockpos;
        BlockState blockstate;
        PartType doubleblockhalf = (PartType)((Object)p_241471_2_.m_61143_(PART));
        if ((doubleblockhalf == PartType.mid || doubleblockhalf == PartType.top) && (blockstate = p_241471_0_.m_8055_(blockpos = p_241471_1_.m_7495_())).m_60734_() == p_241471_2_.m_60734_() && blockstate.m_61143_(PART) == PartType.bottom) {
            p_241471_0_.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            p_241471_0_.m_5898_(p_241471_3_, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
    }

    public void m_5707_(Level p_176208_1_, BlockPos p_176208_2_, BlockState p_176208_3_, Player p_176208_4_) {
        if (!p_176208_1_.f_46443_ && p_176208_4_.m_7500_()) {
            StreetLightBlock.preventCreativeDropFromBottomPart(p_176208_1_, p_176208_2_, p_176208_3_, p_176208_4_);
        }
        super.m_5707_(p_176208_1_, p_176208_2_, p_176208_3_, p_176208_4_);
    }

    public BlockState m_6843_(BlockState p_52790_, Rotation p_52791_) {
        return (BlockState)p_52790_.m_61124_((Property)FACING, (Comparable)p_52791_.m_55954_((Direction)p_52790_.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState p_52787_, Mirror p_52788_) {
        return p_52788_ == Mirror.NONE ? p_52787_ : p_52787_.m_60717_(p_52788_.m_54846_((Direction)p_52787_.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_196258_1_) {
        BlockPos lvt_2_1_ = p_196258_1_.m_8083_();
        if (lvt_2_1_.m_123342_() < p_196258_1_.m_43725_().m_151558_() && p_196258_1_.m_43725_().m_8055_(lvt_2_1_.m_7494_()).m_60629_(p_196258_1_)) {
            Level lvt_3_1_ = p_196258_1_.m_43725_();
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)p_196258_1_.m_8125_().m_122424_())).m_61124_(PART, (Comparable)((Object)PartType.bottom));
        }
        return null;
    }

    public void m_6402_(Level p_180633_1_, BlockPos p_180633_2_, BlockState p_180633_3_, LivingEntity p_180633_4_, ItemStack p_180633_5_) {
        Integer configPartCount = (Integer)ModernLifeConfig.SERVER.streetLightMiddlePartCount.get();
        if (configPartCount != null) {
            MID_PART_COUNT = configPartCount;
        }
        p_180633_1_.m_7731_(p_180633_2_.m_6630_(MID_PART_COUNT + 1), (BlockState)p_180633_3_.m_61124_(PART, (Comparable)((Object)PartType.top)), 3);
        for (int i = 0; i < MID_PART_COUNT; ++i) {
            int aboveIdx = MID_PART_COUNT - i;
            p_180633_1_.m_7731_(p_180633_2_.m_6630_(aboveIdx), (BlockState)p_180633_3_.m_61124_(PART, (Comparable)((Object)PartType.mid)), 3);
        }
    }

    public boolean hasXairBlocksAbove(LevelReader world, BlockPos pos, int x) {
        BlockPos currentPos = pos;
        for (int i = 0; i < x; ++i) {
            if (world.m_8055_(currentPos = currentPos.m_7494_()).m_60795_()) continue;
            return false;
        }
        return true;
    }

    public boolean m_7898_(BlockState p_196260_1_, LevelReader p_196260_2_, BlockPos p_196260_3_) {
        BlockPos lvt_4_1_ = p_196260_3_.m_7495_();
        BlockState lvt_5_1_ = p_196260_2_.m_8055_(lvt_4_1_);
        return p_196260_1_.m_61143_(PART) == PartType.bottom ? lvt_5_1_.m_60783_((BlockGetter)p_196260_2_, lvt_4_1_, Direction.UP) && this.hasXairBlocksAbove(p_196260_2_, p_196260_3_, MID_PART_COUNT + 1) : lvt_5_1_.m_60713_((Block)this);
    }

    public PushReaction getPistonPushReaction(BlockState p_149656_1_) {
        return PushReaction.DESTROY;
    }

    @OnlyIn(value=Dist.CLIENT)
    public long m_7799_(BlockState p_209900_1_, BlockPos p_209900_2_) {
        return Mth.m_14130_((int)p_209900_2_.m_123341_(), (int)p_209900_2_.m_6625_(p_209900_1_.m_61143_(PART) == PartType.bottom ? 0 : 1).m_123342_(), (int)p_209900_2_.m_123343_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.m_61104_(new Property[]{PART, FACING});
    }

    static {
        SHAPE_NORTH = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        SHAPE_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH);
        SHAPE_SOUTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_EAST);
        SHAPE_WEST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH);
        SHAPE_NORTH_TOP = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
        SHAPE_EAST_TOP = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH_TOP);
        SHAPE_SOUTH_TOP = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_EAST_TOP);
        SHAPE_WEST_TOP = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH_TOP);
        MID_PART_COUNT = 3;
        FACING = HorizontalDirectionalBlock.f_54117_;
        PART = EnumProperty.m_61587_((String)"part", PartType.class);
    }

    public static enum PartType implements StringRepresentable
    {
        bottom,
        mid,
        top;


        public String m_7912_() {
            return this.name().toLowerCase();
        }
    }
}

