/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks.gui;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeNetwork;
import com.dairymoose.modernlife.network.play.client.ServerboundPrintSizePacket;
import com.dairymoose.modernlife.util.CanvasData;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class CustomPrintScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation PRINTER_GUI = new ResourceLocation("modernlife", "textures/gui/gui_printer_custom.png");
    final int GUI_WIDTH = 80;
    final int GUI_HEIGHT = 110;
    BlockPos pos;
    private static final String PRINT_SIZE = "Canvas Resize";
    public static final int FIELD_START_X = 5;
    public static final int FIELD_START_RIGHT_X = 48;
    public static final int FIELD_START_Y = 20;
    public static final int FIELD_START_Y2 = 55;
    public static final int FIELD_START_Y3 = 88;
    public static final int INPUT_FIELD_WIDTH = 27;
    public static final int INPUT_FIELD_HEIGHT = 16;
    public static final int TEXT_START_OFFSET_X = 13;
    public static final int TEXT_START_OFFSET_Y = 3;
    public static int grayColor = 0x8B8B8B;
    public static int chosenX = -1;
    public static int chosenY = -1;
    private int chosenFieldId = -1;
    private static final int FIELD_ID_WIDTH = 0;
    private static final int FIELD_ID_HEIGHT = 1;
    private static final int FIELD_ID_X_OFFSET = 2;
    private static final int FIELD_ID_Y_OFFSET = 3;
    public static final int CANCEL_BUTTON_START_X = 56;
    public static final int CANCEL_BUTTON_START_Y = 68;
    public static final int ACCEPT_BUTTON_START_X = 56;
    public static final int ACCEPT_BUTTON_START_Y = 88;
    private float blockWidth = 1.0f;
    private float blockHeight = 1.0f;
    private float xOffset = 0.0f;
    private float yOffset = 0.0f;
    private int blockWidthInputLength = 0;
    private int blockHeightInputLength = 0;
    private int xOffsetInputLength = 0;
    private int yOffsetInputLength = 0;
    private boolean negateX = false;
    private boolean negateY = false;
    private EditBox widthEdit;
    private EditBox heightEdit;
    private EditBox xOffsetEdit;
    private EditBox yOffsetEdit;

    public EditBox newEditBox(int x, int y) {
        int startX = (this.f_96543_ - 80) / 2;
        int startY = (this.f_96544_ - 110) / 2;
        EditBox toReturn = null;
        if (toReturn == null) {
            toReturn = new EditBox(this.f_96547_, startX + x, startY + y, 29, 16, (Component)Component.m_237113_((String)""));
            toReturn.m_94199_(4);
            toReturn.m_94144_("0");
            toReturn.m_93692_(true);
        }
        this.m_142416_((GuiEventListener)toReturn);
        this.m_7522_((GuiEventListener)toReturn);
        return toReturn;
    }

    private static Component getComponentForTitle(String title) {
        return MutableComponent.m_237204_((ComponentContents)new LiteralContents(title)).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x404040)));
    }

    public CustomPrintScreen(BlockPos pos) {
        super(CustomPrintScreen.getComponentForTitle(PRINT_SIZE));
        CompoundTag tag;
        chosenX = -1;
        chosenY = -1;
        this.pos = pos;
        ItemStack itemStack = Minecraft.m_91087_().f_91074_.m_21205_();
        if (itemStack != null && itemStack.m_150930_((Item)CustomBlocks.ITEM_CANVAS.get()) && (tag = itemStack.m_41783_()) != null && tag.m_128441_("Size")) {
            int size = tag.m_128451_("Size");
            if (size == 0) {
                if (tag.m_128441_("BlockWidth") && tag.m_128441_("BlockHeight")) {
                    float blockWidth = tag.m_128457_("BlockWidth");
                    float blockHeight = tag.m_128457_("BlockHeight");
                    this.blockWidth = blockWidth;
                    this.blockHeight = blockHeight;
                }
                if (tag.m_128441_("xOffset") && tag.m_128441_("yOffset")) {
                    float xOffset = tag.m_128457_("xOffset");
                    float yOffset = tag.m_128457_("yOffset");
                    this.xOffset = xOffset;
                    this.yOffset = yOffset;
                }
            } else {
                this.xOffset = 0.0f;
                this.yOffset = 0.0f;
                if (size == 1) {
                    this.blockWidth = 1.0f;
                    this.blockHeight = 1.0f;
                } else if (size == 2) {
                    this.blockWidth = 1.5f;
                    this.blockHeight = 1.25f;
                    this.yOffset = 0.125f;
                } else if (size == 3) {
                    this.blockWidth = 2.0f;
                    this.blockHeight = 1.5f;
                    this.yOffset = 0.25f;
                } else if (size == 4) {
                    this.blockWidth = 3.0f;
                    this.blockHeight = 2.0f;
                    this.yOffset = 0.5f;
                } else if (size == 5) {
                    this.blockWidth = 1.625f;
                    this.blockHeight = 1.625f;
                } else if (size == 6) {
                    this.blockWidth = 2.25f;
                    this.blockHeight = 2.25f;
                } else if (size == 7) {
                    this.blockWidth = 3.0f;
                    this.blockHeight = 3.0f;
                }
            }
        }
    }

    public boolean m_6375_(double clickX, double clickY, int mouseButton) {
        int xStart = (this.f_96543_ - 80) / 2;
        int yStart = (this.f_96544_ - 110) / 2;
        int fieldStartX = xStart + 5;
        int fieldStartRightX = xStart + 48;
        int fieldStartY = yStart + 20;
        int fieldStartY2 = yStart + 55;
        int fieldStartY3 = yStart + 88;
        int fieldEndX = fieldStartX + 27;
        int fieldEndRightX = fieldStartRightX + 27;
        int fieldEndY = fieldStartY + 16;
        int fieldEndY2 = fieldStartY2 + 16;
        int fieldEndY3 = fieldStartY3 + 16;
        if (mouseButton == 0) {
            if (clickX >= (double)fieldStartX && clickX <= (double)fieldEndX) {
                if (clickY >= (double)fieldStartY && clickY <= (double)fieldEndY) {
                    this.chosenFieldId = 0;
                    this.setChosenFieldToZero();
                    chosenX = fieldStartX;
                    chosenY = fieldStartY;
                }
                if (clickY >= (double)fieldStartY2 && clickY <= (double)fieldEndY2) {
                    this.chosenFieldId = 2;
                    this.setChosenFieldToZero();
                    chosenX = fieldStartX;
                    chosenY = fieldStartY2;
                }
                if (clickY >= (double)fieldStartY3 && clickY <= (double)fieldEndY3) {
                    this.chosenFieldId = 3;
                    this.setChosenFieldToZero();
                    chosenX = fieldStartX;
                    chosenY = fieldStartY3;
                }
            }
            if (clickX >= (double)fieldStartRightX && clickX <= (double)fieldEndRightX && clickY >= (double)fieldStartY && clickY <= (double)fieldEndY) {
                this.chosenFieldId = 1;
                this.setChosenFieldToZero();
                chosenX = fieldStartRightX;
                chosenY = fieldStartY;
            }
        }
        return super.m_6375_(clickX, clickY, mouseButton);
    }

    public int getDigitCount(float f) {
        int count = 0;
        for (float remainder = f; remainder != 0.0f; remainder *= 10.0f) {
            int truncated = (int)remainder;
            ++count;
            if (truncated == 0) continue;
            remainder %= (float)truncated;
        }
        return count;
    }

    public float applyInputToFloatField(float field, float input, int inputCount) {
        int digits = inputCount;
        float fInput = input;
        for (int i = 0; i < digits; ++i) {
            fInput /= 10.0f;
        }
        return field += fInput;
    }

    public void addInputToChosenField(int input) {
        if (this.chosenFieldId == -1) {
            return;
        }
        if (this.chosenFieldId == 0) {
            this.blockWidth = this.applyInputToFloatField(this.blockWidth, input, this.blockWidthInputLength);
            this.blockWidth = ServerboundPrintSizePacket.sanitizeWidthHeight(this.blockWidth);
            ++this.blockWidthInputLength;
        }
        if (this.chosenFieldId == 1) {
            this.blockHeight = this.applyInputToFloatField(this.blockHeight, input, this.blockHeightInputLength);
            this.blockHeight = ServerboundPrintSizePacket.sanitizeWidthHeight(this.blockHeight);
            ++this.blockHeightInputLength;
        }
        if (this.chosenFieldId == 2) {
            this.xOffset = this.applyInputToFloatField(this.xOffset, input, this.xOffsetInputLength);
            this.xOffset = ServerboundPrintSizePacket.sanitizeOffset(this.xOffset);
            ++this.xOffsetInputLength;
        }
        if (this.chosenFieldId == 3) {
            this.yOffset = this.applyInputToFloatField(this.yOffset, input, this.yOffsetInputLength);
            this.yOffset = ServerboundPrintSizePacket.sanitizeOffset(this.yOffset);
            ++this.yOffsetInputLength;
        }
    }

    public void setChosenFieldToZero() {
        if (this.chosenFieldId == -1) {
            return;
        }
        if (this.chosenFieldId == 0) {
            this.blockWidth = 0.0f;
            this.blockWidthInputLength = 0;
        }
        if (this.chosenFieldId == 1) {
            this.blockHeight = 0.0f;
            this.blockHeightInputLength = 0;
        }
        if (this.chosenFieldId == 2) {
            this.xOffset = 0.0f;
            this.negateX = false;
            this.xOffsetInputLength = 1;
        }
        if (this.chosenFieldId == 3) {
            this.yOffset = 0.0f;
            this.negateY = false;
            this.yOffsetInputLength = 1;
        }
    }

    public void backspaceChosenField() {
        if (this.chosenFieldId == -1) {
            return;
        }
        if (this.chosenFieldId == 0) {
            this.blockWidth = (int)this.blockWidth;
            this.blockWidthInputLength = 1;
        }
        if (this.chosenFieldId == 1) {
            this.blockHeight = (int)this.blockHeight;
            this.blockHeightInputLength = 1;
        }
        if (this.chosenFieldId == 2) {
            this.xOffset = (int)this.xOffset;
            this.xOffsetInputLength = 1;
        }
        if (this.chosenFieldId == 3) {
            this.yOffset = (int)this.yOffset;
            this.yOffsetInputLength = 1;
        }
    }

    public void negateChosenField() {
        if (this.chosenFieldId == 2) {
            boolean bl = this.negateX = !this.negateX;
        }
        if (this.chosenFieldId == 3) {
            this.negateY = !this.negateY;
        }
    }

    public boolean m_7933_(int key, int p_96553_, int p_96554_) {
        boolean invalid;
        boolean bl = invalid = key >= 65 && key <= 90 || key >= 97 && key <= 122;
        if (!invalid) {
            return super.m_7933_(key, p_96553_, p_96554_);
        }
        return true;
    }

    protected void m_7856_() {
        int startX = (this.f_96543_ - 80) / 2;
        int startY = (this.f_96544_ - 110) / 2;
        CustomPrintScreen thisPrinter = this;
        this.widthEdit = this.newEditBox(5, 20);
        this.widthEdit.m_94144_(String.valueOf(this.blockWidth));
        this.heightEdit = this.newEditBox(48, 20);
        this.heightEdit.m_94144_(String.valueOf(this.blockHeight));
        this.xOffsetEdit = this.newEditBox(5, 55);
        this.xOffsetEdit.m_94144_(String.valueOf(this.xOffset));
        this.yOffsetEdit = this.newEditBox(5, 88);
        this.yOffsetEdit.m_94144_(String.valueOf(this.yOffset));
        this.m_142416_((GuiEventListener)new ImageButton(startX + 56, startY + 68, 20, 18, 215, 0, 19, PRINTER_GUI, new Button.OnPress(){

            public void m_93750_(Button arg0) {
                Minecraft.m_91087_().m_91152_(null);
            }
        }));
        CustomPrintScreen cps = this;
        this.m_142416_((GuiEventListener)new ImageButton(startX + 56, startY + 88, 20, 18, 236, 0, 19, PRINTER_GUI, new Button.OnPress(){

            public void m_93750_(Button arg0) {
                ItemStack itemStack = Minecraft.m_91087_().f_91074_.m_21205_();
                if (itemStack != null && (itemStack.m_150930_((Item)CustomBlocks.ITEM_CANVAS.get()) && itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("UniqueId") || itemStack.m_150930_((Item)CustomBlocks.ITEM_CAMERA.get()))) {
                    boolean good = true;
                    try {
                        CustomPrintScreen.this.blockWidth = Float.parseFloat(CustomPrintScreen.this.widthEdit.m_94155_());
                        CustomPrintScreen.this.blockHeight = Float.parseFloat(CustomPrintScreen.this.heightEdit.m_94155_());
                        CustomPrintScreen.this.xOffset = Float.parseFloat(CustomPrintScreen.this.xOffsetEdit.m_94155_());
                        CustomPrintScreen.this.yOffset = Float.parseFloat(CustomPrintScreen.this.yOffsetEdit.m_94155_());
                        CustomPrintScreen.this.blockWidth = ServerboundPrintSizePacket.sanitizeWidthHeight(CustomPrintScreen.this.blockWidth);
                        CustomPrintScreen.this.blockHeight = ServerboundPrintSizePacket.sanitizeWidthHeight(CustomPrintScreen.this.blockHeight);
                        CustomPrintScreen.this.xOffset = ServerboundPrintSizePacket.sanitizeOffset(CustomPrintScreen.this.xOffset);
                        CustomPrintScreen.this.yOffset = ServerboundPrintSizePacket.sanitizeOffset(CustomPrintScreen.this.yOffset);
                    }
                    catch (Exception ex) {
                        good = false;
                        LOGGER.error("Error parsing input values from string to float", (Throwable)ex);
                    }
                    if (good) {
                        float nX = CustomPrintScreen.this.xOffset;
                        if (CustomPrintScreen.this.negateX) {
                            nX = -nX;
                        }
                        float nY = CustomPrintScreen.this.yOffset;
                        if (CustomPrintScreen.this.negateY) {
                            nY = -nY;
                        }
                        ModernLifeNetwork.INSTANCE.sendToServer((Object)new ServerboundPrintSizePacket(CustomPrintScreen.this.blockWidth, CustomPrintScreen.this.blockHeight, nX, nY, CustomPrintScreen.this.pos));
                    }
                }
                Minecraft.m_91087_().m_91152_(null);
            }
        }));
    }

    public boolean m_7043_() {
        return false;
    }

    private void drawCenteredStringNoShadow(GuiGraphics graphics, Font font, Component p_238472_2_, int p_238472_3_, int p_238472_4_, int p_238472_5_) {
        FormattedCharSequence lvt_6_1_ = p_238472_2_.m_7532_();
        graphics.drawString(font, lvt_6_1_, (float)(p_238472_3_ - font.m_92724_(lvt_6_1_) / 2), (float)p_238472_4_, p_238472_5_, false);
    }

    public void m_88315_(GuiGraphics graphics, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        int xStart = (this.f_96543_ - 80) / 2;
        int yStart = (this.f_96544_ - 110) / 2;
        graphics.m_280218_(PRINTER_GUI, xStart, yStart, 0, 0, 80, 110);
        int fieldStartX = xStart + 5;
        int fieldStartRightX = xStart + 48;
        int fieldStartY = yStart + 20;
        int fieldStartY2 = yStart + 55;
        int fieldStartY3 = yStart + 88;
        int r = CanvasData.getRValue(grayColor);
        int g = CanvasData.getGValue(grayColor);
        int b = CanvasData.getBValue(grayColor);
        float fR = (float)r / 255.0f;
        float fG = (float)g / 255.0f;
        float fB = (float)b / 255.0f;
        RenderSystem.setShaderColor((float)fR, (float)fG, (float)fB, (float)1.0f);
        graphics.m_280218_(PRINTER_GUI, fieldStartX, fieldStartY, 5, 20, 27, 16);
        graphics.m_280218_(PRINTER_GUI, fieldStartRightX, fieldStartY, 48, 20, 27, 16);
        graphics.m_280218_(PRINTER_GUI, fieldStartX, fieldStartY2, 5, 55, 27, 16);
        graphics.m_280218_(PRINTER_GUI, fieldStartX, fieldStartY3, 5, 88, 27, 16);
        if (chosenX > 0 && chosenY > 0) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.m_280218_(PRINTER_GUI, chosenX, chosenY, 5, 20, 27, 16);
        }
        DecimalFormat df = new DecimalFormat("##.##");
        String textWidth = df.format(this.blockWidth);
        String textHeight = df.format(this.blockHeight);
        float nX = this.xOffset;
        if (this.negateX) {
            nX = -nX;
        }
        float nY = this.yOffset;
        if (this.negateY) {
            nY = -nY;
        }
        String textXOffset = df.format(nX);
        String textYOffset = df.format(nY);
        this.drawCenteredStringNoShadow(graphics, this.f_96541_.f_91062_, (Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(textWidth)), fieldStartX + 13, fieldStartY + 3, 0);
        this.drawCenteredStringNoShadow(graphics, this.f_96541_.f_91062_, (Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(textHeight)), fieldStartRightX + 13, fieldStartY + 3, 0);
        this.drawCenteredStringNoShadow(graphics, this.f_96541_.f_91062_, (Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(textXOffset)), fieldStartX + 13, fieldStartY2 + 3, 0);
        this.drawCenteredStringNoShadow(graphics, this.f_96541_.f_91062_, (Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(textYOffset)), fieldStartX + 13, fieldStartY3 + 3, 0);
        super.m_88315_(graphics, p_230430_2_, p_230430_3_, p_230430_4_);
    }
}

