/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks.gui;

import com.dairymoose.modernlife.blocks.gui.EaselScreen;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.util.CanvasData;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class EaselCustomSizeScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation PRINTER_GUI = new ResourceLocation("modernlife", "textures/gui/gui_easel_custom_size.png");
    final int GUI_WIDTH = 80;
    final int GUI_HEIGHT = 58;
    BlockPos pos;
    Level level;
    private static final String PRINT_SIZE = "Canvas Resize";
    public static final int FIELD_START_X = 5;
    public static final int FIELD_START_RIGHT_X = 48;
    public static final int FIELD_START_Y = 20;
    public static final int INPUT_FIELD_WIDTH = 27;
    public static final int INPUT_FIELD_HEIGHT = 16;
    public static final int TEXT_START_OFFSET_X = 13;
    public static final int TEXT_START_OFFSET_Y = 3;
    public static int grayColor = 0x8B8B8B;
    public static int chosenX = -1;
    public static int chosenY = -1;
    private int chosenFieldId = -1;
    private static final int FIELD_ID_WIDTH = 0;
    private static final int FIELD_ID_HEIGHT = 1;
    private static final int FIELD_ID_X_OFFSET = 2;
    private static final int FIELD_ID_Y_OFFSET = 3;
    public static final int CANCEL_BUTTON_START_X = 13;
    public static final int CANCEL_BUTTON_START_Y = 37;
    public static final int ACCEPT_BUTTON_START_X = 47;
    public static final int ACCEPT_BUTTON_START_Y = 37;
    private int texWidth = 64;
    private int texHeight = 64;
    private int blockWidthInputLength = 0;
    private int blockHeightInputLength = 0;
    private boolean negateX = false;
    private boolean negateY = false;

    private static Component getComponentForTitle(String title) {
        return MutableComponent.m_237204_((ComponentContents)new LiteralContents(title)).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x404040)));
    }

    private void goToEaselScreen() {
        EaselScreen screen = new EaselScreen(this.level, this.pos);
        screen.setTextureSize(this.texWidth, this.texHeight);
        screen.setBlockPos(this.pos);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    public EaselCustomSizeScreen(Level level, BlockPos pos) {
        super(EaselCustomSizeScreen.getComponentForTitle(PRINT_SIZE));
        chosenX = -1;
        chosenY = -1;
        this.pos = pos;
    }

    public boolean m_6375_(double clickX, double clickY, int mouseButton) {
        int xStart = (this.f_96543_ - 80) / 2;
        int yStart = (this.f_96544_ - 58) / 2;
        int fieldStartX = xStart + 5;
        int fieldStartRightX = xStart + 48;
        int fieldStartY = yStart + 20;
        int fieldEndX = fieldStartX + 27;
        int fieldEndRightX = fieldStartRightX + 27;
        int fieldEndY = fieldStartY + 16;
        if (mouseButton == 0) {
            if (clickX >= (double)fieldStartX && clickX <= (double)fieldEndX && clickY >= (double)fieldStartY && clickY <= (double)fieldEndY) {
                this.chosenFieldId = 0;
                this.setChosenFieldToZero();
                chosenX = fieldStartX;
                chosenY = fieldStartY;
            }
            if (clickX >= (double)fieldStartRightX && clickX <= (double)fieldEndRightX && clickY >= (double)fieldStartY && clickY <= (double)fieldEndY) {
                this.chosenFieldId = 1;
                this.setChosenFieldToZero();
                chosenX = fieldStartRightX;
                chosenY = fieldStartY;
            }
        }
        return super.m_6375_(clickX, clickY, mouseButton);
    }

    public int applyInputToIntegerField(int field, int input, int inputCount) {
        field *= 10;
        return field += input;
    }

    public static int sanitizeInput(int input) {
        if (input < 0) {
            return 0;
        }
        if (input > 1000) {
            return 1000;
        }
        return input;
    }

    public void addInputToChosenField(int input) {
        if (this.chosenFieldId == -1) {
            return;
        }
        if (this.chosenFieldId == 0) {
            this.texWidth = this.applyInputToIntegerField(this.texWidth, input, this.blockWidthInputLength);
            this.texWidth = EaselCustomSizeScreen.sanitizeInput(this.texWidth);
            ++this.blockWidthInputLength;
        }
        if (this.chosenFieldId == 1) {
            this.texHeight = this.applyInputToIntegerField(this.texHeight, input, this.blockHeightInputLength);
            this.texHeight = EaselCustomSizeScreen.sanitizeInput(this.texHeight);
            ++this.blockHeightInputLength;
        }
    }

    public void setChosenFieldToZero() {
        if (this.chosenFieldId == -1) {
            return;
        }
        if (this.chosenFieldId == 0) {
            this.texWidth = 0;
            this.blockWidthInputLength = 0;
        }
        if (this.chosenFieldId == 1) {
            this.texHeight = 0;
            this.blockHeightInputLength = 0;
        }
    }

    public void backspaceChosenField() {
        if (this.chosenFieldId == -1) {
            return;
        }
        if (this.chosenFieldId == 0) {
            this.texWidth /= 10;
            this.blockWidthInputLength = 1;
        }
        if (this.chosenFieldId == 1) {
            this.texHeight /= 10;
            this.blockHeightInputLength = 1;
        }
    }

    public void negateChosenField() {
        if (this.chosenFieldId == 2) {
            boolean bl = this.negateX = !this.negateX;
        }
        if (this.chosenFieldId == 3) {
            this.negateY = !this.negateY;
        }
    }

    public boolean m_7933_(int key, int p_231046_2_, int p_231046_3_) {
        ModernLifeCommon.LOGGER.debug("key press: " + key);
        if (key == 261) {
            this.setChosenFieldToZero();
        } else if (key == 259) {
            this.backspaceChosenField();
        } else if (key == 48 || key >= 49 && key <= 57) {
            int digit = Character.digit(key, 10);
            this.addInputToChosenField(digit);
        } else if (key == 45) {
            this.negateChosenField();
        } else if (key == 257) {
            return true;
        }
        return super.m_7933_(key, p_231046_2_, p_231046_3_);
    }

    protected void m_7856_() {
        int startX = (this.f_96543_ - 80) / 2;
        int startY = (this.f_96544_ - 58) / 2;
        final EaselCustomSizeScreen thisPrinter = this;
        this.m_142416_((GuiEventListener)new ImageButton(startX + 13, startY + 37, 20, 18, 215, 0, 19, PRINTER_GUI, new Button.OnPress(){

            public void m_93750_(Button arg0) {
                Minecraft.m_91087_().m_91152_(null);
            }
        }));
        this.m_142416_((GuiEventListener)new ImageButton(startX + 47, startY + 37, 20, 18, 236, 0, 19, PRINTER_GUI, new Button.OnPress(){

            public void m_93750_(Button arg0) {
                thisPrinter.goToEaselScreen();
            }
        }));
    }

    public boolean m_7043_() {
        return false;
    }

    private void drawCenteredStringNoShadow(GuiGraphics graphics, Font font, Component p_238472_2_, int p_238472_3_, int p_238472_4_, int p_238472_5_) {
        FormattedCharSequence lvt_6_1_ = p_238472_2_.m_7532_();
        graphics.drawString(font, lvt_6_1_, (float)(p_238472_3_ - font.m_92724_(lvt_6_1_) / 2), (float)p_238472_4_, p_238472_5_, false);
    }

    public void m_88315_(GuiGraphics graphics, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        int xStart = (this.f_96543_ - 80) / 2;
        int yStart = (this.f_96544_ - 58) / 2;
        graphics.m_280218_(PRINTER_GUI, xStart, yStart, 0, 0, 80, 58);
        int fieldStartX = xStart + 5;
        int fieldStartRightX = xStart + 48;
        int fieldStartY = yStart + 20;
        int r = CanvasData.getRValue(grayColor);
        int g = CanvasData.getGValue(grayColor);
        int b = CanvasData.getBValue(grayColor);
        float fR = (float)r / 255.0f;
        float fG = (float)g / 255.0f;
        float fB = (float)b / 255.0f;
        RenderSystem.setShaderColor((float)fR, (float)fG, (float)fB, (float)1.0f);
        graphics.m_280218_(PRINTER_GUI, fieldStartX, fieldStartY, 5, 20, 27, 16);
        graphics.m_280218_(PRINTER_GUI, fieldStartRightX, fieldStartY, 48, 20, 27, 16);
        if (chosenX > 0 && chosenY > 0) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.m_280218_(PRINTER_GUI, chosenX, chosenY, 5, 20, 27, 16);
        }
        String widthText = String.valueOf(this.texWidth);
        String heightText = String.valueOf(this.texHeight);
        this.drawCenteredStringNoShadow(graphics, this.f_96541_.f_91062_, (Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(widthText)), fieldStartX + 13, fieldStartY + 3, 0);
        this.drawCenteredStringNoShadow(graphics, this.f_96541_.f_91062_, (Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(heightText)), fieldStartRightX + 13, fieldStartY + 3, 0);
        super.m_88315_(graphics, p_230430_2_, p_230430_3_, p_230430_4_);
    }
}

