/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks.gui;

import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.core.ModernLifeNetwork;
import com.dairymoose.modernlife.network.play.client.ServerboundWirelessChannelPacket;
import com.dairymoose.modernlife.tileentities.IChannelHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class WirelessPowerScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation WIRELESS_POWER_UI = new ResourceLocation("modernlife", "textures/gui/wireless_power_ui.png");
    final int GUI_WIDTH = 80;
    final int GUI_HEIGHT = 68;
    private BlockPos wirelessBlock;
    private int currentChannel;
    private ImageButton accept;

    public WirelessPowerScreen(BlockPos wirelessBlock, int currentChannel) {
        super((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Wireless Power")).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x404040))));
        this.wirelessBlock = wirelessBlock;
        this.currentChannel = currentChannel;
    }

    protected void m_7856_() {
        ModernLifeCommon.LOGGER.debug("in init!");
        int startX = (this.f_96543_ - 80) / 2;
        int startY = (this.f_96544_ - 68) / 2;
        final WirelessPowerScreen wps = this;
        this.m_142416_((GuiEventListener)new ImageButton(startX + 42, startY + 34, 14, 13, 81, 0, 14, WIRELESS_POWER_UI, new Button.OnPress(){

            public void m_93750_(Button arg0) {
                --wps.currentChannel;
                wps.sanitizeCurrentChannel();
            }
        }));
        this.m_142416_((GuiEventListener)new ImageButton(startX + 42, startY + 20, 14, 13, 96, 0, 14, WIRELESS_POWER_UI, new Button.OnPress(){

            public void m_93750_(Button arg0) {
                ++wps.currentChannel;
                wps.sanitizeCurrentChannel();
            }
        }));
        this.m_142416_((GuiEventListener)new ImageButton(startX + 20, startY + 50, 14, 13, 111, 0, 14, WIRELESS_POWER_UI, new Button.OnPress(){

            public void m_93750_(Button arg0) {
                Minecraft.m_91087_().m_91152_(null);
            }
        }));
        this.accept = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(startX + 47, startY + 50, 14, 13, 126, 0, 14, WIRELESS_POWER_UI, new Button.OnPress(){

            public void m_93750_(Button arg0) {
                BlockEntity tileEntity = Minecraft.m_91087_().f_91073_.m_7702_(wps.wirelessBlock);
                if (tileEntity instanceof IChannelHolder) {
                    IChannelHolder channelHolder = (IChannelHolder)tileEntity;
                    channelHolder.setCurrentChannel(wps.currentChannel);
                }
                ServerboundWirelessChannelPacket packet = new ServerboundWirelessChannelPacket(wps.currentChannel, wps.wirelessBlock);
                ModernLifeNetwork.INSTANCE.sendToServer((Object)packet);
                Minecraft.m_91087_().m_91152_(null);
            }
        }));
    }

    public boolean m_7043_() {
        return false;
    }

    public void sanitizeCurrentChannel() {
        if (this.currentChannel < 0) {
            this.currentChannel = 0;
        }
        if (this.currentChannel > 9999) {
            this.currentChannel = 9999;
        }
    }

    public boolean m_6050_(double a, double b, double c) {
        if (c > 0.0) {
            ++this.currentChannel;
            this.sanitizeCurrentChannel();
        } else {
            --this.currentChannel;
            this.sanitizeCurrentChannel();
        }
        return super.m_6050_(a, b, c);
    }

    public boolean m_7933_(int key, int p_231046_2_, int p_231046_3_) {
        ModernLifeCommon.LOGGER.debug("key press: " + key);
        if (key == 264) {
            --this.currentChannel;
        } else if (key == 265) {
            ++this.currentChannel;
        } else if (key == 267) {
            this.currentChannel -= 10;
        } else if (key == 266) {
            this.currentChannel += 10;
        } else if (key == 261) {
            this.currentChannel = 0;
        } else if (key == 259) {
            this.currentChannel /= 10;
        } else if (key == 48 || key >= 49 && key <= 57) {
            this.currentChannel *= 10;
            int digit = Character.digit(key, 10);
            this.currentChannel += digit;
        } else if (key == 257) {
            this.accept.m_5691_();
            return true;
        }
        this.sanitizeCurrentChannel();
        return super.m_7933_(key, p_231046_2_, p_231046_3_);
    }

    private void drawCenteredStringNoShadow(GuiGraphics graphics, Font font, Component p_238472_2_, int p_238472_3_, int p_238472_4_, int p_238472_5_) {
        FormattedCharSequence lvt_6_1_ = p_238472_2_.m_7532_();
        graphics.drawString(font, lvt_6_1_, (float)(p_238472_3_ - font.m_92724_(lvt_6_1_) / 2), (float)p_238472_4_, p_238472_5_, false);
    }

    public void m_88315_(GuiGraphics graphics, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        this.m_280273_(graphics);
        int lvt_5_1_ = (this.f_96543_ - 80) / 2;
        int lvt_6_1_ = (this.f_96544_ - 68) / 2;
        graphics.m_280218_(WIRELESS_POWER_UI, lvt_5_1_, lvt_6_1_, 0, 0, 80, 68);
        this.drawCenteredStringNoShadow(graphics, this.f_96541_.f_91062_, (Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(String.valueOf(this.currentChannel))).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0))), lvt_5_1_ + 22, lvt_6_1_ + 28, 0);
        super.m_88315_(graphics, p_230430_2_, p_230430_3_, p_230430_4_);
    }
}

