/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.core;

import com.dairymoose.entity.DummyEntity;
import com.dairymoose.entity.RenderableBlock;
import com.dairymoose.modernlife.blocks.gui.HBlockPos;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeNetwork;
import com.dairymoose.modernlife.network.play.client.ClientboundWinchDummyPacket;
import com.dairymoose.modernlife.tileentities.WinchBlockEntity;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockVolume {
    private static final Logger LOGGER = LogManager.getLogger();
    public int minX;
    public int minY;
    public int minZ;
    public int maxX;
    public int maxY;
    public int maxZ;
    public boolean valid = false;
    public static boolean shouldFloat = false;
    public static DummyEntity dummy = null;

    public BlockVolume(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public BlockVolume(Level level, BlockPos root, Block anchorBlock) {
        BlockState state = level.m_8055_(root);
        if (state.m_60713_(anchorBlock)) {
            LinkedList<HBlockPos> toVisit = new LinkedList<HBlockPos>();
            HashSet<HBlockPos> visited = new HashSet<HBlockPos>();
            this.valid = true;
            this.minX = root.m_123341_();
            this.minY = root.m_123342_();
            this.minZ = root.m_123343_();
            this.maxX = root.m_123341_();
            this.maxY = root.m_123342_();
            this.maxZ = root.m_123343_();
            toVisit.add(new HBlockPos(root));
            while (!toVisit.isEmpty()) {
                HBlockPos currentPos = (HBlockPos)((Object)toVisit.remove());
                int x = currentPos.m_123341_();
                int y = currentPos.m_123342_();
                int z = currentPos.m_123343_();
                if (x < this.minX) {
                    this.minX = x;
                }
                if (y < this.minY) {
                    this.minY = y;
                }
                if (z < this.minZ) {
                    this.minZ = z;
                }
                if (x > this.maxX) {
                    this.maxX = x;
                }
                if (y > this.maxY) {
                    this.maxY = y;
                }
                if (z > this.maxZ) {
                    this.maxZ = z;
                }
                HBlockPos northPos = new HBlockPos(currentPos.m_122012_());
                HBlockPos eastPos = new HBlockPos(currentPos.m_122029_());
                HBlockPos southPos = new HBlockPos(currentPos.m_122019_());
                HBlockPos westPos = new HBlockPos(currentPos.m_122024_());
                HBlockPos upPos = new HBlockPos(currentPos.m_7494_());
                HBlockPos downPos = new HBlockPos(currentPos.m_7495_());
                BlockState northState = level.m_8055_((BlockPos)northPos);
                BlockState eastState = level.m_8055_((BlockPos)eastPos);
                BlockState southState = level.m_8055_((BlockPos)southPos);
                BlockState westState = level.m_8055_((BlockPos)westPos);
                BlockState upState = level.m_8055_((BlockPos)upPos);
                BlockState downState = level.m_8055_((BlockPos)downPos);
                HBlockPos hPos = null;
                hPos = northPos;
                if (!visited.contains((Object)hPos) && northState.m_60713_(anchorBlock)) {
                    visited.add(hPos);
                    toVisit.add(hPos);
                }
                if (!visited.contains((Object)(hPos = eastPos)) && eastState.m_60713_(anchorBlock)) {
                    visited.add(hPos);
                    toVisit.add(hPos);
                }
                if (!visited.contains((Object)(hPos = southPos)) && southState.m_60713_(anchorBlock)) {
                    visited.add(hPos);
                    toVisit.add(hPos);
                }
                if (!visited.contains((Object)(hPos = westPos)) && westState.m_60713_(anchorBlock)) {
                    visited.add(hPos);
                    toVisit.add(hPos);
                }
                if (!visited.contains((Object)(hPos = upPos)) && upState.m_60713_(anchorBlock)) {
                    visited.add(hPos);
                    toVisit.add(hPos);
                }
                if (visited.contains((Object)(hPos = downPos)) || !downState.m_60713_(anchorBlock)) continue;
                visited.add(hPos);
                toVisit.add(hPos);
            }
        }
    }

    private boolean isWithinVolume(BlockPos pos) {
        return pos.m_123341_() >= this.minX && pos.m_123341_() <= this.maxX && pos.m_123342_() >= this.minY && pos.m_123342_() <= this.maxY && pos.m_123343_() >= this.minZ && pos.m_123343_() <= this.maxZ;
    }

    private boolean isValidSourceBlock(BlockState sourceState) {
        return (sourceState.m_60713_((Block)CustomBlocks.BLOCK_PHOTON.get()) || !sourceState.m_155947_()) && sourceState.m_60819_().m_76178_();
    }

    private boolean isValidDestBlock(BlockState destinationState, boolean destroyChain, boolean destIsChain) {
        return (destinationState.m_60713_((Block)CustomBlocks.BLOCK_PHOTON.get()) || !destinationState.m_155947_()) && (destinationState.m_60795_() || destroyChain && destIsChain) && destinationState.m_60819_().m_76178_();
    }

    private boolean canMoveLayer(BlockPos cornerPos, boolean increaseXYZ, Level level, BiFunction<BlockState, BlockPos, BlockPos> posShifter, BlockState shifterState, boolean destroyChain, WinchBlockEntity winchBlockEntity) {
        int xIterations = this.maxX - this.minX + 1;
        int zIterations = this.maxZ - this.minZ + 1;
        for (int x = 0; x < xIterations; ++x) {
            for (int z = 0; z < zIterations; ++z) {
                boolean destIsChain;
                BlockPos currentPos = null;
                currentPos = increaseXYZ ? new BlockPos(cornerPos.m_123341_() + x, cornerPos.m_123342_(), cornerPos.m_123343_() + z) : new BlockPos(cornerPos.m_123341_() - x, cornerPos.m_123342_(), cornerPos.m_123343_() - z);
                BlockPos destination = posShifter.apply(shifterState, currentPos);
                BlockState sourceState = level.m_8055_(currentPos);
                BlockState destinationState = level.m_8055_(destination);
                if (this.isValidDestBlock(destinationState, destroyChain, destIsChain = destinationState.m_60713_(Blocks.f_50184_))) {
                    if (this.isValidSourceBlock(sourceState)) {
                        int chainSlot;
                        if (!destroyChain || !destIsChain || (chainSlot = winchBlockEntity.getOpenChainSlot()) != -1) continue;
                        return false;
                    }
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public void moveEntities(Level level, BlockPos destination, BlockState shifterState, BiFunction<BlockState, BlockPos, BlockPos> posShifter) {
        BlockPos entityTargetPosition = posShifter.apply(shifterState, destination);
        Vec3 entityTargetPositionVec = new Vec3((double)entityTargetPosition.m_123341_(), (double)entityTargetPosition.m_123342_(), (double)entityTargetPosition.m_123343_());
        Vec3 destinationVec = new Vec3((double)destination.m_123341_() + 0.5, (double)destination.m_123342_(), (double)destination.m_123343_() + 0.5);
        Vec3 diffVec = entityTargetPositionVec.m_82546_(destinationVec);
        List destEntities = level.m_45933_(null, new AABB((double)destination.m_123341_(), (double)destination.m_123342_(), (double)destination.m_123343_(), (double)destination.m_123341_() + 0.5, (double)destination.m_123342_() + 0.5, (double)destination.m_123343_() + 0.5));
        for (Entity e : destEntities) {
            Vec3 delta = e.m_20184_();
            ((Player)level.m_6907_().get(0)).m_5661_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("destinationVec=" + destinationVec)), false);
            e.m_20219_(destinationVec);
        }
    }

    public void moveEntitiesAboveSource(Set<Integer> movedEntities, Level level, BlockPos src, BlockPos dest, BlockState shifterState, BiFunction<BlockState, BlockPos, BlockPos> posShifter, boolean doShift) {
        BlockPos destination = dest;
        if (doShift) {
            destination = posShifter.apply(shifterState, dest);
        }
        Vec3 destinationVec = new Vec3((double)destination.m_123341_() + 0.5, (double)destination.m_123342_(), (double)destination.m_123343_() + 0.5);
        BlockPos abovePos = dest.m_7494_();
        BlockPos belowPos = dest.m_7495_();
        List destEntities = level.m_45976_(Entity.class, new AABB((double)abovePos.m_123341_(), (double)abovePos.m_123342_() - 0.5, (double)abovePos.m_123343_(), (double)abovePos.m_123341_() + 1.0, (double)abovePos.m_123342_() + 1.8, (double)abovePos.m_123343_() + 1.0));
        if (!level.m_8055_(abovePos).m_60795_()) {
            return;
        }
        if (!level.m_8055_(src).m_60795_()) {
            return;
        }
        BlockPos newPos = dest;
        List otherEntities = level.m_6443_(Entity.class, new AABB((double)abovePos.m_123341_(), (double)abovePos.m_123342_() - 0.9, (double)abovePos.m_123343_(), (double)abovePos.m_123341_() + 1.0, (double)abovePos.m_123342_() + 1.8, (double)abovePos.m_123343_() + 1.0), x -> {
            if (x instanceof Player || x instanceof Boat) {
                return false;
            }
            return x.m_20182_().m_193103_(Direction.Axis.Y, 0.0).m_82531_((double)abovePos.m_123341_(), 0.0, (double)abovePos.m_123343_()) <= 2.25;
        });
        List boatEntities = level.m_6443_(Boat.class, new AABB((double)abovePos.m_123341_() + 0.3, (double)abovePos.m_123342_() - 1.8, (double)abovePos.m_123343_() + 0.3, (double)abovePos.m_123341_() + 0.7, (double)abovePos.m_123342_() + 1.8, (double)abovePos.m_123343_() + 0.7), x -> x.m_20182_().m_193103_(Direction.Axis.Y, 0.0).m_82531_((double)abovePos.m_123341_(), 0.0, (double)abovePos.m_123343_()) <= 2.25);
        destEntities.addAll(otherEntities);
        destEntities.addAll(boatEntities);
        for (Entity e : destEntities) {
            if (movedEntities.contains(e.m_19879_())) continue;
            movedEntities.add(e.m_19879_());
            if (e.m_20202_() != null) continue;
            double destX = e.m_20185_();
            BlockPos eInitialPos = e.m_20183_();
            BlockPos eFinalPos = posShifter.apply(shifterState, eInitialPos);
            int yDiffShifted = eFinalPos.m_123342_() - eInitialPos.m_123342_();
            double destY = e.m_20186_() + (double)yDiffShifted;
            double destZ = e.m_20189_();
            e.m_20248_(destX, destY, destZ);
            e.m_217006_(destX, destY, destZ);
        }
    }

    public boolean shiftBlocks(Level level, BiFunction<BlockState, BlockPos, BlockPos> posShifter, BlockState shifterState, boolean destroyChain, WinchBlockEntity winchBlockEntity) {
        if (posShifter == null) {
            return false;
        }
        if (shifterState == null) {
            return false;
        }
        BlockPos minPos = new BlockPos(this.minX, this.minY, this.minZ);
        BlockPos maxPos = new BlockPos(this.maxX, this.maxY, this.maxZ);
        BlockPos shiftedMinPos = posShifter.apply(shifterState, minPos);
        BlockPos shiftedMaxPos = posShifter.apply(shifterState, maxPos);
        if (this.isWithinVolume(shiftedMinPos) && this.isWithinVolume(shiftedMaxPos)) {
            return false;
        }
        boolean increaseXYZ = false;
        BlockPos startingPos = null;
        if (this.isWithinVolume(shiftedMinPos)) {
            startingPos = maxPos;
            increaseXYZ = false;
        } else {
            startingPos = minPos;
            increaseXYZ = true;
        }
        HashSet<Integer> movedEntities = new HashSet<Integer>();
        BlockPos cornerPos = startingPos;
        int yIterations = this.maxY - this.minY + 1;
        for (int y = 0; y < yIterations; ++y) {
            int xIterations = this.maxX - this.minX + 1;
            int zIterations = this.maxZ - this.minZ + 1;
            if (!this.canMoveLayer(cornerPos, increaseXYZ, level, posShifter, shifterState, destroyChain, winchBlockEntity)) {
                return false;
            }
            for (int x = 0; x < xIterations; ++x) {
                for (int z = 0; z < zIterations; ++z) {
                    boolean destIsChain;
                    BlockPos currentPos = null;
                    currentPos = increaseXYZ ? new BlockPos(cornerPos.m_123341_() + x, cornerPos.m_123342_(), cornerPos.m_123343_() + z) : new BlockPos(cornerPos.m_123341_() - x, cornerPos.m_123342_(), cornerPos.m_123343_() - z);
                    BlockPos destination = posShifter.apply(shifterState, currentPos);
                    if (increaseXYZ) {
                        this.moveEntitiesAboveSource(movedEntities, level, currentPos, destination, shifterState, posShifter, !increaseXYZ);
                    }
                    BlockState sourceState = level.m_8055_(currentPos);
                    BlockState destinationState = level.m_8055_(destination);
                    if (this.isValidDestBlock(destinationState, destroyChain, destIsChain = destinationState.m_60713_(Blocks.f_50184_))) {
                        if (this.isValidSourceBlock(sourceState)) {
                            if (destroyChain && destIsChain) {
                                int chainSlot = winchBlockEntity.getOpenChainSlot();
                                if (chainSlot == -1) {
                                    return false;
                                }
                                ItemStack itemStack = winchBlockEntity.m_8020_(chainSlot);
                                if (itemStack.m_150930_(Items.f_42026_)) {
                                    itemStack.m_41769_(1);
                                } else {
                                    ItemStack newChain = new ItemStack(new ItemLike(){

                                        public Item m_5456_() {
                                            return Items.f_42026_;
                                        }
                                    });
                                    winchBlockEntity.m_6836_(chainSlot, newChain);
                                }
                            }
                            level.m_7731_(destination, sourceState, 2);
                            level.m_7731_(currentPos, Blocks.f_50016_.m_49966_(), 2);
                            level.m_46672_(destination, level.m_8055_(destination).m_60734_());
                            level.m_46672_(currentPos, Blocks.f_50016_);
                            if (increaseXYZ) continue;
                            this.moveEntitiesAboveSource(movedEntities, level, currentPos, destination, shifterState, posShifter, !increaseXYZ);
                            continue;
                        }
                        return false;
                    }
                    return false;
                }
            }
            cornerPos = increaseXYZ ? new BlockPos(cornerPos.m_123341_(), cornerPos.m_123342_() + 1, cornerPos.m_123343_()) : new BlockPos(cornerPos.m_123341_(), cornerPos.m_123342_() - 1, cornerPos.m_123343_());
        }
        if (!destroyChain) {
            int chainSlot = winchBlockEntity.getNextChainSlot();
            if (chainSlot == -1) {
                return false;
            }
            ItemStack itemStack = winchBlockEntity.m_8020_(chainSlot);
            if (itemStack.m_150930_(Items.f_42026_)) {
                itemStack.m_41774_(1);
            }
        }
        return true;
    }

    public boolean shiftBlocksWithDummyEntity(Level level, BiFunction<BlockState, BlockPos, BlockPos> posShifter, BlockState shifterState, boolean destroyChain, WinchBlockEntity winchBlockEntity) {
        if (posShifter == null) {
            return false;
        }
        if (shifterState == null) {
            return false;
        }
        BlockPos minPos = new BlockPos(this.minX, this.minY, this.minZ);
        BlockPos maxPos = new BlockPos(this.maxX, this.maxY, this.maxZ);
        BlockPos shiftedMinPos = posShifter.apply(shifterState, minPos);
        BlockPos shiftedMaxPos = posShifter.apply(shifterState, maxPos);
        if (this.isWithinVolume(shiftedMinPos) && this.isWithinVolume(shiftedMaxPos)) {
            return false;
        }
        boolean increaseXYZ = false;
        BlockPos startingPos = null;
        if (this.isWithinVolume(shiftedMinPos)) {
            startingPos = maxPos;
            increaseXYZ = false;
        } else {
            startingPos = minPos;
            increaseXYZ = true;
        }
        HashSet<Integer> movedEntities = new HashSet<Integer>();
        BlockPos cornerPos = startingPos;
        int yIterations = this.maxY - this.minY + 1;
        if (dummy == null && !level.f_46443_) {
            dummy = DummyEntity.getEntity(0.5f, level, startingPos, false);
            ModernLifeNetwork.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundWinchDummyPacket(dummy.m_19879_(), winchBlockEntity.m_58899_()));
        }
        if (dummy != null && BlockVolume.dummy.renderables.isEmpty()) {
            int xIterations = this.maxX - this.minX + 1;
            int zIterations = this.maxZ - this.minZ + 1;
            for (int y = 0; y < yIterations; ++y) {
                if (!this.canMoveLayer(cornerPos, increaseXYZ, level, posShifter, shifterState, destroyChain, winchBlockEntity)) {
                    // empty if block
                }
                for (int x = 0; x < xIterations; ++x) {
                    for (int z = 0; z < zIterations; ++z) {
                        int chainSlot;
                        BlockPos currentPos = null;
                        currentPos = increaseXYZ ? new BlockPos(cornerPos.m_123341_() + x, cornerPos.m_123342_(), cornerPos.m_123343_() + z) : new BlockPos(cornerPos.m_123341_() - x, cornerPos.m_123342_(), cornerPos.m_123343_() - z);
                        BlockPos destination = posShifter.apply(shifterState, currentPos);
                        this.moveEntitiesAboveSource(movedEntities, level, currentPos, destination, shifterState, posShifter, !increaseXYZ);
                        BlockState sourceState = level.m_8055_(currentPos);
                        BlockState destinationState = level.m_8055_(destination);
                        boolean destIsChain = destinationState.m_60713_(Blocks.f_50184_);
                        if (destroyChain && destIsChain && (chainSlot = winchBlockEntity.getOpenChainSlot()) != -1) {
                            ItemStack itemStack = winchBlockEntity.m_8020_(chainSlot);
                            if (itemStack.m_150930_(Items.f_42026_)) {
                                itemStack.m_41769_(1);
                            } else {
                                ItemStack newChain = new ItemStack(new ItemLike(){

                                    public Item m_5456_() {
                                        return Items.f_42026_;
                                    }
                                });
                                winchBlockEntity.m_6836_(chainSlot, newChain);
                            }
                        }
                        if (!level.f_46443_ || dummy == null) continue;
                        BlockVolume.dummy.renderables.add(new RenderableBlock(dummy, currentPos, sourceState));
                    }
                }
                cornerPos = increaseXYZ ? new BlockPos(cornerPos.m_123341_(), cornerPos.m_123342_() + 1, cornerPos.m_123343_()) : new BlockPos(cornerPos.m_123341_(), cornerPos.m_123342_() - 1, cornerPos.m_123343_());
            }
            shouldFloat = false;
            Minecraft.m_91087_().f_91074_.m_20334_(0.0, 0.125, 0.0);
            dummy.m_20334_(0.0, 0.125, 0.0);
        } else if (level.f_46443_ && dummy != null) {
            BlockPos dummyPos = dummy.m_20183_();
            if (!this.canMoveLayer(dummyPos, increaseXYZ, level, posShifter, shifterState, destroyChain, winchBlockEntity)) {
                // empty if block
            }
            for (RenderableBlock renderableBlock : BlockVolume.dummy.renderables) {
            }
        }
        return true;
    }

    public String toString() {
        return "BlockVolume [minX=" + this.minX + ", minY=" + this.minY + ", minZ=" + this.minZ + ", maxX=" + this.maxX + ", maxY=" + this.maxY + ", maxZ=" + this.maxZ + "]";
    }
}

