/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.core;

import com.dairymoose.modernlife.blocks.ModernBookshelfBlock;
import com.dairymoose.modernlife.blocks.OakPostBlock;
import com.dairymoose.modernlife.core.BlockVolume;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeClient;
import com.dairymoose.modernlife.core.ModernLifeConfig;
import com.dairymoose.modernlife.core.ModernLifeConfigPrepopulator;
import com.dairymoose.modernlife.core.ModernLifeCraftingFlags;
import com.dairymoose.modernlife.core.ModernLifeNetwork;
import com.dairymoose.modernlife.items.CameraItem;
import com.dairymoose.modernlife.items.FlashlightItem;
import com.dairymoose.modernlife.network.play.client.ClientboundBulletHolePacket;
import com.dairymoose.modernlife.network.play.client.ClientboundFlashlightUpdatePacket;
import com.dairymoose.modernlife.network.play.client.ClientboundMultipartCanvasPacket;
import com.dairymoose.modernlife.network.play.client.ClientboundWinchDummyPacket;
import com.dairymoose.modernlife.network.play.client.ServerboundBikeDismountPacket;
import com.dairymoose.modernlife.network.play.client.ServerboundBookCancelPacket;
import com.dairymoose.modernlife.network.play.client.ServerboundCameraPacket;
import com.dairymoose.modernlife.network.play.client.ServerboundCanvasChecksumPacket;
import com.dairymoose.modernlife.network.play.client.ServerboundCanvasCopyRequestPacket;
import com.dairymoose.modernlife.network.play.client.ServerboundCanvasPacket;
import com.dairymoose.modernlife.network.play.client.ServerboundChainsawTargetPacket;
import com.dairymoose.modernlife.network.play.client.ServerboundChessStatePacket;
import com.dairymoose.modernlife.network.play.client.ServerboundFuelLevelPacket;
import com.dairymoose.modernlife.network.play.client.ServerboundGuitarPacket;
import com.dairymoose.modernlife.network.play.client.ServerboundHitscanPacket;
import com.dairymoose.modernlife.network.play.client.ServerboundMultipartCameraPacket;
import com.dairymoose.modernlife.network.play.client.ServerboundMultipartEaselPacket;
import com.dairymoose.modernlife.network.play.client.ServerboundPrintSizePacket;
import com.dairymoose.modernlife.network.play.client.ServerboundRadiatorPacket;
import com.dairymoose.modernlife.network.play.client.ServerboundRequestCanvasPacket;
import com.dairymoose.modernlife.network.play.client.ServerboundStopUsingCameraPacket;
import com.dairymoose.modernlife.network.play.client.ServerboundTrashCanPacket;
import com.dairymoose.modernlife.network.play.client.ServerboundWirelessChannelPacket;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModernLifeCommon {
    public static final String MODID = "modernlife";
    private int flashlightTickCounter = 0;
    private int speedometerTickCounter = 0;
    public static int winchTickCounter = 0;
    public static int clientTickCounter = 0;
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"modernlife");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"modernlife");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"modernlife");
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"modernlife");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"modernlife");
    public static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"modernlife");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"modernlife");
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    public static final Logger LOGGER = LogManager.getLogger();
    private BlockItem itemOakPost;
    private OakPostBlock blockOakPost;
    private final boolean shouldUseNotifyNeighborLogic = false;
    private static long nextUniqueCanvasId = 1L;
    private static ModernLifeCraftingFlags craftingFlags;
    public static int FLASHLIGHT_DURATION_MINUTES;
    public static CreativeModeTab ModernLifeCreativeTab;
    public static long serverTickCounter;
    static boolean wantToShutdownPendingImageUpdateThread;
    private static ExecutorService pendingImageUpdateThread;
    public static ConcurrentLinkedQueue<PendingImageUpdate> pendingImageUpdates;
    private boolean awaitingBookScreenCancel = false;
    ExecutorService containerCheckThread = Executors.newScheduledThreadPool(1);
    AbstractContainerMenu lastContainer = null;
    public boolean isFloating = false;
    public Vec3 lastPos = null;
    public static String ServerLevelFolderName;
    private ExecutorService pngChecksumThread = Executors.newCachedThreadPool();
    private ExecutorService recomputeThreadpool = null;
    public static AtomicLong checksumCompletedCount;
    public static long checksumsToCompute;
    private static boolean serverIsStopping;

    public ModernLifeCommon() {
        LOGGER.debug(CustomBlocks.BLOCK_RADIATOR);
        ModernLifeConfigPrepopulator prepop = new ModernLifeConfigPrepopulator();
        try {
            prepop.parseFile(MODID, "common", ModernLifeConfig.COMMON.flashlightLightLevel, ModernLifeConfig.COMMON.flashlightFullChargeDuration);
        }
        catch (Exception e) {
            LOGGER.error("Config pre-populator error", (Throwable)e);
        }
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::addItemsToCreativeTab);
        MinecraftForge.EVENT_BUS.register((Object)this);
        craftingFlags = new ModernLifeCraftingFlags();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModernLifeConfig.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ModernLifeConfig.clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ModernLifeConfig.serverSpec);
        try {
            Integer durationConfig = ModernLifeConfig.COMMON.flashlightFullChargeDuration.getValue();
            if (durationConfig != null) {
                FLASHLIGHT_DURATION_MINUTES = durationConfig;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error loading flashlight config", (Throwable)e);
        }
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        BLOCK_ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        SOUND_EVENTS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        CONTAINERS.register(FMLJavaModLoadingContext.get().getModEventBus());
        CREATIVE_TABS.register(FMLJavaModLoadingContext.get().getModEventBus());
        int msgId = 0;
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, ServerboundCanvasPacket.class, ServerboundCanvasPacket::m_5779_, ServerboundCanvasPacket::new, ServerboundCanvasPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, ServerboundGuitarPacket.class, ServerboundGuitarPacket::m_5779_, ServerboundGuitarPacket::new, ServerboundGuitarPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, ServerboundWirelessChannelPacket.class, ServerboundWirelessChannelPacket::m_5779_, ServerboundWirelessChannelPacket::new, ServerboundWirelessChannelPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, ServerboundBikeDismountPacket.class, ServerboundBikeDismountPacket::m_5779_, ServerboundBikeDismountPacket::new, ServerboundBikeDismountPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, ServerboundTrashCanPacket.class, ServerboundTrashCanPacket::m_5779_, ServerboundTrashCanPacket::new, ServerboundTrashCanPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, ServerboundChainsawTargetPacket.class, ServerboundChainsawTargetPacket::m_5779_, ServerboundChainsawTargetPacket::new, ServerboundChainsawTargetPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, ServerboundRadiatorPacket.class, ServerboundRadiatorPacket::m_5779_, ServerboundRadiatorPacket::new, ServerboundRadiatorPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, ClientboundFlashlightUpdatePacket.class, ClientboundFlashlightUpdatePacket::m_5779_, ClientboundFlashlightUpdatePacket::new, ClientboundFlashlightUpdatePacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, ServerboundChessStatePacket.class, ServerboundChessStatePacket::m_5779_, ServerboundChessStatePacket::new, ServerboundChessStatePacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, ServerboundCameraPacket.class, ServerboundCameraPacket::m_5779_, ServerboundCameraPacket::new, ServerboundCameraPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, ServerboundMultipartCameraPacket.class, ServerboundMultipartCameraPacket::m_5779_, ServerboundMultipartCameraPacket::new, ServerboundMultipartCameraPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, ServerboundMultipartEaselPacket.class, ServerboundMultipartEaselPacket::m_5779_, ServerboundMultipartEaselPacket::new, ServerboundMultipartEaselPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, ClientboundMultipartCanvasPacket.class, ClientboundMultipartCanvasPacket::m_5779_, ClientboundMultipartCanvasPacket::new, ClientboundMultipartCanvasPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, ServerboundRequestCanvasPacket.class, ServerboundRequestCanvasPacket::m_5779_, ServerboundRequestCanvasPacket::new, ServerboundRequestCanvasPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, ServerboundPrintSizePacket.class, ServerboundPrintSizePacket::m_5779_, ServerboundPrintSizePacket::new, ServerboundPrintSizePacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, ServerboundStopUsingCameraPacket.class, ServerboundStopUsingCameraPacket::m_5779_, ServerboundStopUsingCameraPacket::new, ServerboundStopUsingCameraPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, ServerboundHitscanPacket.class, ServerboundHitscanPacket::m_5779_, ServerboundHitscanPacket::new, ServerboundHitscanPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, ClientboundBulletHolePacket.class, ClientboundBulletHolePacket::m_5779_, ClientboundBulletHolePacket::new, ClientboundBulletHolePacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, ServerboundFuelLevelPacket.class, ServerboundFuelLevelPacket::m_5779_, ServerboundFuelLevelPacket::new, ServerboundFuelLevelPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, ClientboundWinchDummyPacket.class, ClientboundWinchDummyPacket::m_5779_, ClientboundWinchDummyPacket::new, ClientboundWinchDummyPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, ServerboundBookCancelPacket.class, ServerboundBookCancelPacket::m_5779_, ServerboundBookCancelPacket::new, ServerboundBookCancelPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, ServerboundCanvasCopyRequestPacket.class, ServerboundCanvasCopyRequestPacket::m_5779_, ServerboundCanvasCopyRequestPacket::new, ServerboundCanvasCopyRequestPacket::handle);
        ModernLifeNetwork.INSTANCE.registerMessage(msgId++, ServerboundCanvasChecksumPacket.class, ServerboundCanvasChecksumPacket::m_5779_, ServerboundCanvasChecksumPacket::new, ServerboundCanvasChecksumPacket::handle);
    }

    private void setup(FMLCommonSetupEvent event) {
        ModernLifeConfig.reinit();
    }

    private void addItemsToCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (CustomBlocks.MODERN_LIFE_CREATIVE.get() != null && event.getTab() == CustomBlocks.MODERN_LIFE_CREATIVE.get()) {
            Field[] allFields;
            for (Field f : allFields = CustomBlocks.class.getDeclaredFields()) {
                if (f.getType() != RegistryObject.class) continue;
                try {
                    RegistryObject value = (RegistryObject)f.get(null);
                    if (value == null || !(value.get() instanceof Item)) continue;
                    LOGGER.debug("Value is: " + value.get());
                    event.accept((Supplier)value);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    LOGGER.error("Error registering items with creative tab", (Throwable)e);
                }
            }
        }
    }

    public int materialColorToTintColor(int materialColorRgb) {
        int r = materialColorRgb & 0xFF;
        int g = (materialColorRgb & 0xFF00) >> 8;
        int b = (materialColorRgb & 0xFF0000) >> 16;
        return materialColorRgb & 0xFF000000 | r << 16 | g << 8 | b;
    }

    @SubscribeEvent
    public void onInteractEventServer(PlayerInteractEvent interactEvent) {
        if (!interactEvent.getLevel().f_46443_) {
            ItemStack itemStack;
            Boolean result = CameraItem.usingCameraServer.get(interactEvent.getEntity());
            if (result != null && result.booleanValue() && !(interactEvent instanceof PlayerInteractEvent.RightClickItem) && interactEvent != null && interactEvent.isCancelable()) {
                interactEvent.setCanceled(true);
            }
            if (interactEvent.getEntity() != null && (itemStack = interactEvent.getEntity().m_21205_()) != null && itemStack.m_41720_() == CustomBlocks.ITEM_HANDGUN.get() && (interactEvent instanceof PlayerInteractEvent.LeftClickBlock || interactEvent instanceof PlayerInteractEvent.LeftClickEmpty) && interactEvent != null && interactEvent.isCancelable()) {
                interactEvent.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onAttackEvent(AttackEntityEvent e) {
        ItemStack itemStack;
        if (e.getEntity() != null && (itemStack = e.getEntity().m_21205_()) != null && itemStack.m_41720_() == CustomBlocks.ITEM_HANDGUN.get() && e != null && e.isCancelable()) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent serverTick) {
        if (serverTick.phase == TickEvent.Phase.START) {
            ++serverTickCounter;
            if (BlockVolume.dummy != null) {
                Vec3 dummyPos = BlockVolume.dummy.m_20182_();
                double newDummyY = dummyPos.f_82480_ + 0.125;
                BlockVolume.dummy.m_217006_(dummyPos.f_82479_, newDummyY, dummyPos.f_82481_);
            }
            if (!serverIsStopping) {
                if (((Boolean)ModernLifeConfig.SERVER.useDedicatedThreadForCameraUpdates.get()).booleanValue()) {
                    if (pendingImageUpdateThread == null) {
                        wantToShutdownPendingImageUpdateThread = false;
                        pendingImageUpdateThread = Executors.newFixedThreadPool(1);
                        pendingImageUpdateThread.execute(new PendingImageUpdateThread());
                    }
                } else {
                    wantToShutdownPendingImageUpdateThread = true;
                    if (serverTickCounter % (long)((Integer)ModernLifeConfig.SERVER.cameraUpdateRateLimit.get()).intValue() == 0L) {
                        ModernLifeCommon.processPendingImageUpdateQueue();
                    }
                }
            }
        }
        if (serverTick.phase == TickEvent.Phase.END) {
            ++this.flashlightTickCounter;
            ++winchTickCounter;
        }
    }

    private static void processPendingImageUpdateQueue() {
        if (pendingImageUpdates != null && !pendingImageUpdates.isEmpty()) {
            for (int i = 0; i < (Integer)ModernLifeConfig.SERVER.cameraUpdatesPerRateLimitTick.get(); ++i) {
                if (pendingImageUpdates.isEmpty()) continue;
                try {
                    PendingImageUpdate pending = (PendingImageUpdate)pendingImageUpdates.remove();
                    if (pending == null) continue;
                    ServerboundMultipartCameraPacket.pushImageUpdateImmediate(pending.uniqueId, pending.player);
                    continue;
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
        }
    }

    private void cleanupCanvasData(ItemStack itemStack) {
        if (itemStack != null & itemStack.m_41720_() == CustomBlocks.ITEM_CANVAS.get()) {
            LOGGER.debug("cleanup canvas data");
            if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("UniqueId")) {
                long uniqueId = itemStack.m_41783_().m_128454_("UniqueId");
                ServerboundMultipartCameraPacket.deletePng(uniqueId);
            }
        }
    }

    @SubscribeEvent
    public void onItemDestroyedEvent(PlayerDestroyItemEvent destroyEvent) {
        if (destroyEvent != null) {
            ItemStack itemStack = destroyEvent.getOriginal();
        }
    }

    @SubscribeEvent
    public void onItemExpiredEvent(ItemExpireEvent expireEvent) {
        if (expireEvent.getEntity() != null) {
            ItemStack itemStack = expireEvent.getEntity().m_32055_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent clientTick) {
        if (clientTick.phase == TickEvent.Phase.START) {
            ++clientTickCounter;
        }
        if (clientTick.phase == TickEvent.Phase.END) {
            ++this.speedometerTickCounter;
        }
    }

    private void awaitBookInHand(Player player) {
        ItemStack pickedBook;
        if (player.m_9236_().f_46443_ && ModernBookshelfBlock.clientAwaitingBook != null && ItemStack.m_150942_((ItemStack)(pickedBook = ModernBookshelfBlock.clientAwaitingBook), (ItemStack)player.m_21120_(InteractionHand.MAIN_HAND))) {
            ModernBookshelfBlock.clientAwaitingBook = null;
            try {
                pickedBook.m_41682_(player.m_9236_(), player, InteractionHand.MAIN_HAND);
            }
            catch (Exception e) {
                LOGGER.error("Use book error", (Throwable)e);
            }
        }
    }

    private void awaitBookScreen(Player player) {
        if (player.m_9236_().f_46443_) {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (this.awaitingBookScreenCancel && screen == null) {
                this.awaitingBookScreenCancel = false;
                ServerboundBookCancelPacket bookCancelPacket = new ServerboundBookCancelPacket(ModernBookshelfBlock.oldItemSlot, ModernBookshelfBlock.lastBlockPos);
                ModernLifeNetwork.INSTANCE.sendToServer((Object)bookCancelPacket);
                return;
            }
            long timestamp = System.currentTimeMillis();
            long timeDiff = timestamp - ModernBookshelfBlock.usedBookTimestamp;
            if (screen != null && timeDiff <= 1000L && !(screen instanceof PauseScreen)) {
                ModernBookshelfBlock.usedBookTimestamp = 0L;
                this.awaitingBookScreenCancel = true;
            }
        }
    }

    private void requestContainerImages(Player player) {
        if (player.m_9236_().f_46443_) {
            if (player != Minecraft.m_91087_().f_91074_) {
                return;
            }
            final AbstractContainerMenu menu = player.f_36096_;
            if (menu != null && menu != this.lastContainer) {
                this.lastContainer = menu;
                this.containerCheckThread.submit(new Runnable(){

                    @Override
                    public void run() {
                        LOGGER.debug("check container for images: " + menu);
                        NonNullList items = menu.m_38927_();
                        if (items != null) {
                            for (int i = 0; i < items.size(); ++i) {
                                ItemStack itemStack = (ItemStack)items.get(i);
                                if (itemStack == null || itemStack.m_41720_() != CustomBlocks.ITEM_CANVAS.get() || itemStack.m_41783_() == null || !itemStack.m_41783_().m_128441_("UniqueId")) continue;
                                long uniqueId = itemStack.m_41783_().m_128454_("UniqueId");
                                ModernLifeClient.getCanvasData(uniqueId);
                            }
                        }
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public void playerTickEvent(TickEvent.PlayerTickEvent pte) {
        if (pte.side == LogicalSide.SERVER && pte.phase == TickEvent.Phase.START && !pte.player.m_9236_().f_46443_) {
            boolean usedFlashlight = false;
            player = pte.player;
            Boolean result = FlashlightItem.usingFlashlight.get(player);
            if (result != null && result.booleanValue()) {
                ItemStack flashlight = null;
                if (player.m_21205_().m_41720_().equals(CustomBlocks.ITEM_FLASHLIGHT.get())) {
                    flashlight = player.m_21205_();
                } else if (player.m_21206_().m_41720_().equals(CustomBlocks.ITEM_FLASHLIGHT.get())) {
                    flashlight = player.m_21206_();
                }
                if (flashlight != null) {
                    ((Item)CustomBlocks.ITEM_FLASHLIGHT.get()).m_5929_(player.m_9236_(), (LivingEntity)player, flashlight, this.flashlightTickCounter);
                    usedFlashlight = true;
                } else {
                    ((FlashlightItem)((Object)CustomBlocks.ITEM_FLASHLIGHT.get())).removePhoton((LivingEntity)player);
                }
            }
        } else if (pte.side == LogicalSide.CLIENT && pte.phase == TickEvent.Phase.START && pte.player.m_9236_().f_46443_) {
            if (BlockVolume.shouldFloat) {
                Vec3 delta = pte.player.m_20184_();
                if (!this.isFloating) {
                    this.isFloating = true;
                    pte.player.m_20334_(delta.f_82479_, 0.125, delta.f_82481_);
                } else {
                    pte.player.m_20334_(delta.f_82479_, 0.125, delta.f_82481_);
                }
            } else {
                this.isFloating = false;
            }
            this.awaitBookInHand(pte.player);
            this.requestContainerImages(pte.player);
            this.awaitBookScreen(pte.player);
            boolean usedSpeedometer = false;
            player = pte.player;
            ItemStack speedometer = null;
            if (player.m_21205_().m_41720_().equals(CustomBlocks.ITEM_SPEEDOMETER.get())) {
                speedometer = player.m_21205_();
            } else if (player.m_21206_().m_41720_().equals(CustomBlocks.ITEM_SPEEDOMETER.get())) {
                speedometer = player.m_21206_();
            }
            if (speedometer != null && pte.player.equals((Object)Minecraft.m_91087_().f_91074_)) {
                ((Item)CustomBlocks.ITEM_SPEEDOMETER.get()).m_5929_(player.m_9236_(), (LivingEntity)player, speedometer, this.speedometerTickCounter);
                usedSpeedometer = true;
            }
        }
        if (pte.side == LogicalSide.CLIENT && pte.phase == TickEvent.Phase.START && pte.player.m_9236_().f_46443_ && Minecraft.m_91087_().f_91074_ == pte.player && BlockVolume.dummy != null) {
            Vec3 dummyPos = BlockVolume.dummy.m_20182_();
            double newDummyY = dummyPos.f_82480_ + 0.125;
            BlockVolume.dummy.m_20248_(dummyPos.f_82479_, newDummyY, dummyPos.f_82481_);
            Vec3 currentPos = pte.player.m_20182_();
            Vec3 solidGround = BlockVolume.dummy.getEntitySolidGround((Entity)pte.player);
            boolean didCollide = false;
            double posX = currentPos.f_82479_;
            double posY = currentPos.f_82480_;
            double posZ = currentPos.f_82481_;
            if (BlockVolume.dummy.isEntityColliding((Entity)pte.player)) {
                didCollide = true;
                if (this.lastPos != null) {
                    posX = this.lastPos.f_82479_;
                    posY = this.lastPos.f_82480_;
                    posZ = this.lastPos.f_82481_;
                }
            }
            if (solidGround != null) {
                pte.player.m_6853_(true);
                pte.player.m_20248_(posX, solidGround.f_82480_, posZ);
                pte.player.m_183634_();
                Vec3 delta = pte.player.m_20184_();
                pte.player.m_20334_(delta.f_82479_, 0.0, delta.f_82481_);
            } else if (didCollide) {
                pte.player.m_20248_(posX, posY, posZ);
            }
            if (!didCollide) {
                this.lastPos = currentPos;
            }
        }
    }

    public static synchronized long getNextCanvasId() {
        long toReturn = nextUniqueCanvasId++;
        String subFolder = ServerboundMultipartCameraPacket.getSubFolderPrepend();
        File canvasInfo = new File(subFolder + "canvasInfo.txt");
        try {
            FileWriter fw = new FileWriter(canvasInfo);
            String toWrite = String.valueOf(nextUniqueCanvasId);
            fw.write(toWrite);
            fw.close();
        }
        catch (IOException e) {
            LOGGER.debug("Error writing to canvasInfo.txt");
        }
        ServerboundMultipartCameraPacket.ensurePngLockSize(toReturn + 1L);
        return toReturn;
    }

    public static void ensureDirectory(String directory) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        Path path;
        if (event != null && event.getServer() != null && (path = event.getServer().m_129843_(LevelResource.f_78182_)) != null && !(ServerLevelFolderName = path.toString()).isEmpty() && !(ServerLevelFolderName = ServerLevelFolderName.replace('\\', '/')).endsWith("/")) {
            ServerLevelFolderName = ServerLevelFolderName + "/";
        }
        String subFolder = ServerboundMultipartCameraPacket.getSubFolderPrepend();
        LOGGER.debug("use folder: " + subFolder);
        File canvasInfo = new File(subFolder + "canvasInfo.txt");
        if (canvasInfo.exists()) {
            try {
                FileReader fr = new FileReader(canvasInfo);
                BufferedReader br = new BufferedReader(fr);
                String line = br.readLine();
                nextUniqueCanvasId = Long.valueOf(line);
                ServerboundMultipartCameraPacket.ensurePngLockSize(nextUniqueCanvasId);
            }
            catch (IOException | NumberFormatException e) {
                LOGGER.error("canvasInfo.txt not found", (Throwable)e);
            }
        }
        if (((Boolean)ModernLifeConfig.SERVER.loadAllImagesOnStartup.get()).booleanValue()) {
            final ModernLifeCommon thisCls = this;
            if (this.pngChecksumThread == null) {
                this.pngChecksumThread = Executors.newCachedThreadPool();
            }
            this.pngChecksumThread.submit(new Runnable(){

                @Override
                public void run() {
                    thisCls.recomputePngChecksums();
                    while (ModernLifeCommon.this.recomputeThreadpool != null) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            LOGGER.error("Interrupted during recomputeThreadpool wait", (Throwable)e);
                        }
                    }
                    ModernLifeCommon.this.pngChecksumThread.shutdown();
                    ModernLifeCommon.this.pngChecksumThread = null;
                }
            });
        }
    }

    public static int recomputeOneChecksum(long uniqueId) {
        LOGGER.debug("Recompute checksum for uniqueId=" + uniqueId);
        ServerboundMultipartCameraPacket.PngSizeHolder sizeHolder = new ServerboundMultipartCameraPacket.PngSizeHolder();
        byte[] compressed = ServerboundMultipartCameraPacket.loadPng(uniqueId, sizeHolder);
        int hashCode = ModernLifeCommon.getHashCodeForBytes(compressed);
        compressed = null;
        ServerboundMultipartCameraPacket.CanvasHashCodeData chcd = new ServerboundMultipartCameraPacket.CanvasHashCodeData();
        chcd.hashCode = hashCode;
        chcd.timestamp = System.currentTimeMillis();
        ServerboundMultipartCameraPacket.canvasHashCodes.put(uniqueId, chcd);
        return hashCode;
    }

    private void recomputePngChecksums() {
        if (this.recomputeThreadpool == null) {
            this.recomputeThreadpool = Executors.newFixedThreadPool((Integer)ModernLifeConfig.SERVER.loadImagesThreadpoolSize.get());
        }
        checksumCompletedCount.set(0L);
        long nextCanvasId = nextUniqueCanvasId;
        checksumsToCompute = nextCanvasId - 1L;
        HashSet<Long> uncomputedChecksums = new HashSet<Long>();
        for (long uniqueId = 1L; uniqueId < nextCanvasId; ++uniqueId) {
            ServerboundMultipartCameraPacket.CanvasHashCodeData chcd = ServerboundMultipartCameraPacket.canvasHashCodes.get(uniqueId);
            if (chcd != null) continue;
            uncomputedChecksums.add(uniqueId);
        }
        checksumsToCompute = uncomputedChecksums.size();
        LOGGER.info("Start checksum threadpool for size=" + checksumsToCompute);
        for (Long uniqueId : uncomputedChecksums) {
            final long recomputeUniqueId = uniqueId;
            this.recomputeThreadpool.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        ModernLifeCommon.recomputeOneChecksum(recomputeUniqueId);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Error computing checksum for uniqueId=" + recomputeUniqueId, (Throwable)ex);
                    }
                    finally {
                        long completed = checksumCompletedCount.incrementAndGet();
                        LOGGER.debug("Finished checksum for uniqueId=" + recomputeUniqueId + ", threadpool completed count=" + completed + " of total: " + checksumsToCompute);
                        if (completed == checksumsToCompute) {
                            LOGGER.info("Shutdown checksum threadpool after computing checksum count=" + checksumsToCompute);
                            ModernLifeCommon.this.recomputeThreadpool.shutdown();
                            ModernLifeCommon.this.recomputeThreadpool = null;
                        }
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        serverIsStopping = true;
        try {
            wantToShutdownPendingImageUpdateThread = true;
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.pngChecksumThread != null) {
                this.pngChecksumThread.shutdownNow();
                this.pngChecksumThread = null;
            }
            if (this.recomputeThreadpool != null) {
                this.recomputeThreadpool.shutdownNow();
                this.recomputeThreadpool = null;
            }
            if (pendingImageUpdateThread != null) {
                pendingImageUpdateThread.shutdownNow();
                pendingImageUpdateThread = null;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error force-stopping threadpools", (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MinecraftServer server = serverPlayer.m_20194_();
            Collection recipes = server.m_129894_().m_44051_();
            ArrayList<Recipe> modRecipes = new ArrayList<Recipe>();
            for (Recipe recipe : recipes) {
                if (!MODID.equals(recipe.m_6423_().m_135827_())) continue;
                modRecipes.add(recipe);
            }
            serverPlayer.m_7281_(modRecipes);
        }
    }

    @SubscribeEvent
    public void onNotifyNeighbor(BlockEvent.NeighborNotifyEvent event) {
        String updatedBlockName = null;
        Block updatedBlock = null;
        try {
            updatedBlock = event.getLevel().m_8055_(event.getPos()).m_60734_();
            if (updatedBlock != null) {
                updatedBlockName = BuiltInRegistries.f_256975_.m_7981_((Object)updatedBlock).m_135815_();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while checking block in onNotifyNeighbor");
        }
        ServerLevel world = null;
        if (event.getLevel() instanceof ServerLevel) {
            world = (ServerLevel)event.getLevel();
        }
    }

    public static int getHashCodeForBytes(byte[] data) {
        return Arrays.hashCode(data);
    }

    static {
        FLASHLIGHT_DURATION_MINUTES = 25;
        ModernLifeCreativeTab = null;
        serverTickCounter = 0L;
        wantToShutdownPendingImageUpdateThread = false;
        pendingImageUpdateThread = null;
        pendingImageUpdates = new ConcurrentLinkedQueue();
        ServerLevelFolderName = null;
        checksumCompletedCount = new AtomicLong(0L);
        checksumsToCompute = 0L;
        serverIsStopping = false;
    }

    private static class PendingImageUpdateThread
    implements Runnable {
        private long lastRunServerTickCounter = -1L;

        private PendingImageUpdateThread() {
        }

        @Override
        public void run() {
            LOGGER.info("Started PendingImageUpdateThread");
            while (true) {
                if (wantToShutdownPendingImageUpdateThread) {
                    LOGGER.info("Stopping PendingImageUpdateThread");
                    pendingImageUpdates.clear();
                    if (pendingImageUpdateThread != null) {
                        pendingImageUpdateThread.shutdown();
                        pendingImageUpdateThread = null;
                    }
                    return;
                }
                long tickDiff = serverTickCounter - this.lastRunServerTickCounter;
                if (this.lastRunServerTickCounter == -1L || tickDiff >= (long)((Integer)ModernLifeConfig.SERVER.cameraUpdateRateLimit.get()).intValue() && !pendingImageUpdates.isEmpty()) {
                    this.lastRunServerTickCounter = serverTickCounter;
                    ModernLifeCommon.processPendingImageUpdateQueue();
                }
                try {
                    Thread.sleep(1L);
                    continue;
                }
                catch (InterruptedException e) {
                    LOGGER.error("PendingImageUpdateThread interrupted", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    public static class PendingImageUpdate {
        public long uniqueId;
        public ServerPlayer player;

        public PendingImageUpdate(long uniqueId, ServerPlayer player) {
            this.uniqueId = uniqueId;
            this.player = player;
        }
    }
}

