/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.core;

import com.dairymoose.modernlife.blocks.ModernBookshelfBlock;
import com.dairymoose.modernlife.core.CsvSourcedHashSet;
import com.dairymoose.modernlife.core.ModernLifeClient;
import com.dairymoose.modernlife.core.ModernLifeClientConfig;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.core.ModernLifeCommonConfig;
import com.dairymoose.modernlife.core.ModernLifeCraftingFlags;
import com.dairymoose.modernlife.core.ModernLifeServerConfig;
import com.dairymoose.modernlife.network.play.client.ServerboundMultipartCameraPacket;
import com.dairymoose.modernlife.tileentities.SeedSpreaderBlockEntity;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="modernlife", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModernLifeConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ForgeConfigSpec serverSpec;
    public static final ModernLifeServerConfig SERVER;
    public static final ForgeConfigSpec clientSpec;
    public static final ModernLifeClientConfig CLIENT;
    public static final ForgeConfigSpec commonSpec;
    public static final ModernLifeCommonConfig COMMON;

    private static void addConfigElement(ForgeConfigSpec.BooleanValue configElement) {
        List path = configElement.getPath();
        String key = (String)path.get(path.size() - 1);
        ModernLifeCraftingFlags.putFlag(key, (Boolean)configElement.get());
    }

    public static void reinit() {
        Integer ssThrowCd;
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableChainsaw);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableFlashlight);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableBicycle);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableSpeedometer);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableCamera);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableCanvas);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableEasel);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableGuitar);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableGuitarAmplifier);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableChessBoard);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enablePavedRoad);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableRoadMarker);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableRefrigerator);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableTrashCan);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableSeedSpreader);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableDeluxeBed);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableExtractor);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableGrate);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableMicrowave);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableStove);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableTurntable);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableToilet);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableRadiator);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enablePowerTransmitter);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enablePowerReceiver);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableMirror);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableCctvCamera);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableCctvScreen);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableAlarmClock);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableWallShelf);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableHandgun);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableMotorboat);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableWinch);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableBookshelf);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enablePhotocopier);
        ModernLifeConfig.addConfigElement(ModernLifeConfig.COMMON.enableWarningAlarm);
        ServerboundMultipartCameraPacket.cameraImageExtension = (Boolean)ModernLifeConfig.COMMON.usePngExtensionForCamera.get() != false ? ServerboundMultipartCameraPacket.cameraImageExtension_PNG : ServerboundMultipartCameraPacket.cameraImageExtension_JPG;
        LOGGER.info("Using camera extension: " + ServerboundMultipartCameraPacket.cameraImageExtension);
        ServerboundMultipartCameraPacket.easelImageExtension = (Boolean)ModernLifeConfig.COMMON.usePngExtensionForEasel.get() != false ? ServerboundMultipartCameraPacket.cameraImageExtension_PNG : ServerboundMultipartCameraPacket.cameraImageExtension_JPG;
        LOGGER.info("Using easel extension: " + ServerboundMultipartCameraPacket.easelImageExtension);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

            @Override
            public void run() {
                ModernLifeClient.CanvasPreviewComponent.CANVAS_TOOLTIP_W = (Integer)ModernLifeConfig.CLIENT.canvasPreviewPixelWidth.get();
                ModernLifeClient.CanvasPreviewComponent.SMALL_CANVAS_TOOLTIP_W = (Integer)ModernLifeConfig.CLIENT.smallCanvasPreviewPixelWidth.get();
            }
        });
        if (serverSpec.isLoaded() && (ssThrowCd = (Integer)ModernLifeConfig.SERVER.seedSpreaderThrowCooldown.get()) != null) {
            SeedSpreaderBlockEntity.RECENT_LOCATIONS_EXPIRY_MS = ssThrowCd;
        }
        try {
            ModernBookshelfBlock.whitelist = new CsvSourcedHashSet((String)ModernLifeConfig.COMMON.bookshelfWhitelist.get());
            ModernBookshelfBlock.blacklist = new CsvSourcedHashSet((String)ModernLifeConfig.COMMON.bookshelfBlacklist.get());
            ModernBookshelfBlock.textToSearch = new CsvSourcedHashSet((String)ModernLifeConfig.COMMON.bookshelfSearchText.get());
            ModernBookshelfBlock.textToAvoid = new CsvSourcedHashSet((String)ModernLifeConfig.COMMON.bookshelfAvoidText.get());
            SeedSpreaderBlockEntity.whitelist = new CsvSourcedHashSet((String)ModernLifeConfig.SERVER.seedSpreaderWhitelist.get());
        }
        catch (Exception e) {
            ModernLifeCommon.LOGGER.error("Config reinit error", (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onConfigReloaded(ModConfigEvent.Reloading event) {
        if (commonSpec.isLoaded()) {
            ModernLifeConfig.reinit();
        }
    }

    static {
        Pair pair1 = new ForgeConfigSpec.Builder().configure(ModernLifeServerConfig::new);
        serverSpec = (ForgeConfigSpec)pair1.getRight();
        SERVER = (ModernLifeServerConfig)pair1.getLeft();
        Pair pair2 = new ForgeConfigSpec.Builder().configure(ModernLifeClientConfig::new);
        clientSpec = (ForgeConfigSpec)pair2.getRight();
        CLIENT = (ModernLifeClientConfig)pair2.getLeft();
        Pair pair3 = new ForgeConfigSpec.Builder().configure(ModernLifeCommonConfig::new);
        commonSpec = (ForgeConfigSpec)pair3.getRight();
        COMMON = (ModernLifeCommonConfig)pair3.getLeft();
    }
}

