/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.items;

import com.dairymoose.modernlife.blocks.RoadMarkerBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RoadMarkerItem
extends Item {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Block[] roadMarkers = new Block[]{(Block)CustomBlocks.BLOCK_ROAD_MARKER_WHITE.get(), (Block)CustomBlocks.BLOCK_ROAD_MARKER_YELLOW.get(), (Block)CustomBlocks.BLOCK_ROAD_MARKER_DOUBLE_YELLOW.get(), (Block)CustomBlocks.BLOCK_ROAD_MARKER_WHITE_SHOULDER_LEFT.get(), (Block)CustomBlocks.BLOCK_ROAD_MARKER_WHITE_SHOULDER_RIGHT.get(), (Block)CustomBlocks.BLOCK_ROAD_MARKER_WHITE_CORNER_LEFT.get(), (Block)CustomBlocks.BLOCK_ROAD_MARKER_WHITE_CORNER_RIGHT.get()};
    private static final Block[] roadMarkersIncline = new Block[]{(Block)CustomBlocks.BLOCK_ROAD_MARKER_WHITE_INCLINE.get(), (Block)CustomBlocks.BLOCK_ROAD_MARKER_YELLOW_INCLINE.get(), (Block)CustomBlocks.BLOCK_ROAD_MARKER_DOUBLE_YELLOW_INCLINE.get(), (Block)CustomBlocks.BLOCK_ROAD_MARKER_WHITE_SHOULDER_LEFT_INCLINE.get(), (Block)CustomBlocks.BLOCK_ROAD_MARKER_WHITE_SHOULDER_RIGHT_INCLINE.get(), (Block)CustomBlocks.BLOCK_ROAD_MARKER_WHITE_CORNER_LEFT_INCLINE.get(), (Block)CustomBlocks.BLOCK_ROAD_MARKER_WHITE_CORNER_RIGHT_INCLINE.get()};
    public static Map<Player, Integer> selectedMarker = new HashMap<Player, Integer>();
    private static final int DEFAULT_MARKER = 0;

    public RoadMarkerItem(Item.Properties p_i48530_4_) {
        super(p_i48530_4_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack p_77624_1_, @Nullable Level p_77624_2_, List<Component> text, TooltipFlag p_77624_4_) {
        text.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("* Right click paved road to apply currently selected road marker")));
        text.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("* Right click elsewhere to toggle between available road markers")));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        if (world.f_46443_) return InteractionResult.CONSUME;
        BlockState bs = world.m_8055_(context.m_8083_());
        if (bs.m_60713_((Block)CustomBlocks.BLOCK_PAVED_ROAD.get()) || bs.m_60713_((Block)CustomBlocks.BLOCK_PAVED_ROAD_RAMP.get())) {
            boolean didAction = false;
            BlockPos above = context.m_8083_().m_7494_();
            BlockState aboveBs = world.m_8055_(above);
            if (world.m_8055_(above).m_60795_()) {
                Integer marker = selectedMarker.get(context.m_43723_());
                if (marker == null) {
                    marker = 0;
                }
                if (bs.m_60713_((Block)CustomBlocks.BLOCK_PAVED_ROAD.get())) {
                    world.m_46597_(above, (BlockState)roadMarkers[marker].m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_()));
                } else {
                    world.m_46597_(above, (BlockState)roadMarkersIncline[marker].m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_()));
                }
                world.m_5594_(null, above, SoundEvents.f_12340_, SoundSource.BLOCKS, 1.0f, 1.6f);
                didAction = true;
                ItemStack itemStack = context.m_43722_();
                itemStack.m_41622_(1, (LivingEntity)context.m_43723_(), x -> {});
            } else if (aboveBs.m_60734_() instanceof RoadMarkerBlock) {
                world.m_46597_(above, Blocks.f_50016_.m_49966_());
                world.m_5594_(null, above, SoundEvents.f_12340_, SoundSource.BLOCKS, 1.0f, 1.6f);
                didAction = true;
            }
            if (!didAction) return InteractionResult.CONSUME;
        }
        this.toggleSelectedMarker(context.m_43723_());
        return InteractionResult.CONSUME;
    }

    void toggleSelectedMarker(Player player) {
        Integer marker = selectedMarker.get(player);
        if (marker == null) {
            marker = 0;
        }
        marker = marker + 1;
        marker = marker % roadMarkers.length;
        selectedMarker.put(player, marker);
        player.m_213846_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Using marker: ")).m_7220_((Component)Component.m_237115_((String)roadMarkers[marker].m_7705_())));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand p_77659_3_) {
        ItemStack itemStack = player.m_21120_(p_77659_3_);
        if (!world.f_46443_) {
            this.toggleSelectedMarker(player);
        }
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }
}

