/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.items.FlashlightItem;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientboundFlashlightUpdatePacket
implements Packet<ClientGamePacketListener> {
    private int playerId;
    private boolean flashlightState;
    private static final Logger LOGGER = LogManager.getLogger();

    public ClientboundFlashlightUpdatePacket() {
    }

    public ClientboundFlashlightUpdatePacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public ClientboundFlashlightUpdatePacket(int playerId, boolean flashlightState) {
        this.playerId = playerId;
        this.flashlightState = flashlightState;
    }

    public void read(FriendlyByteBuf p_148837_1_) {
        this.playerId = p_148837_1_.readInt();
        this.flashlightState = p_148837_1_.readBoolean();
    }

    public void m_5779_(FriendlyByteBuf p_148840_1_) {
        p_148840_1_.writeInt(this.playerId);
        p_148840_1_.writeBoolean(this.flashlightState);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> this.handle((ClientGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_()));
        ctx.get().setPacketHandled(true);
    }

    public void handle(final ClientGamePacketListener handler) {
        ModernLifeCommon.LOGGER.debug("Handle ClientboundFlashlightUpdatePacket");
        if (this.playerId < 0) {
            return;
        }
        if (handler instanceof ClientPacketListener) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                @Override
                public void run() {
                    ClientPacketListener clientHandler = (ClientPacketListener)handler;
                    ClientLevel world = clientHandler.m_105147_();
                    Entity entity = world.m_6815_(ClientboundFlashlightUpdatePacket.this.playerId);
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        FlashlightItem.usingFlashlight.put(player, ClientboundFlashlightUpdatePacket.this.flashlightState);
                    }
                }
            });
        }
    }
}

