/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.entity.BicycleEntity;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerboundBikeDismountPacket
implements Packet<ServerGamePacketListener> {
    private Vec3 position;
    private float velocity;
    private float jumpStep;
    private float downward_velocity;
    private int bikeId;
    private static final Logger LOGGER = LogManager.getLogger();

    public ServerboundBikeDismountPacket() {
    }

    public ServerboundBikeDismountPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public ServerboundBikeDismountPacket(Vec3 position, float jumpStep, float velocity, float downward_velocity, int bikeId) {
        this.position = position;
        this.jumpStep = jumpStep;
        this.velocity = velocity;
        this.downward_velocity = downward_velocity;
        this.bikeId = bikeId;
    }

    public void read(FriendlyByteBuf p_148837_1_) {
        double x = p_148837_1_.readDouble();
        double y = p_148837_1_.readDouble();
        double z = p_148837_1_.readDouble();
        this.jumpStep = p_148837_1_.readFloat();
        this.position = new Vec3(x, y, z);
        this.velocity = p_148837_1_.readFloat();
        this.downward_velocity = p_148837_1_.readFloat();
        this.bikeId = p_148837_1_.readInt();
    }

    public void m_5779_(FriendlyByteBuf p_148840_1_) {
        p_148840_1_.writeDouble(this.position.f_82479_);
        p_148840_1_.writeDouble(this.position.f_82480_);
        p_148840_1_.writeDouble(this.position.f_82481_);
        p_148840_1_.writeFloat(this.jumpStep);
        p_148840_1_.writeFloat(this.velocity);
        p_148840_1_.writeFloat(this.downward_velocity);
        p_148840_1_.writeInt(this.bikeId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((ServerGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_());
        });
        ctx.get().setPacketHandled(true);
    }

    public void handle(ServerGamePacketListener p_148833_1_) {
        ModernLifeCommon.LOGGER.debug("Handle ServerboundBikeDismountPacket");
        if (this.velocity > 0.42f || this.velocity < -0.14f || this.bikeId < 0) {
            return;
        }
        if (p_148833_1_ instanceof ServerGamePacketListenerImpl) {
            ServerGamePacketListenerImpl serverHandler = (ServerGamePacketListenerImpl)p_148833_1_;
            Level world = serverHandler.f_9743_.m_9236_();
            ModernLifeCommon.LOGGER.debug("world = " + world);
            if (world != null) {
                BicycleEntity bike;
                ModernLifeCommon.LOGGER.debug("velocity = " + this.velocity + ", bikeId=" + this.bikeId);
                Entity entity = world.m_6815_(this.bikeId);
                if (entity instanceof BicycleEntity && world.m_46749_((bike = (BicycleEntity)entity).m_20183_()) && world.m_46749_(BlockPos.m_274561_((double)this.position.f_82479_, (double)this.position.f_82480_, (double)this.position.f_82481_))) {
                    bike.m_6034_(this.position.f_82479_, this.position.f_82480_, this.position.f_82481_);
                    bike.setJumpStep(this.jumpStep);
                    bike.setVelocity(this.velocity);
                    bike.setDownwardVelocity(this.downward_velocity);
                    bike.recentDismount = true;
                }
            }
        }
    }
}

