/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.core.ModernLifeConfig;
import com.dairymoose.modernlife.core.ModernLifeNetwork;
import com.dairymoose.modernlife.network.play.client.ClientboundMultipartCanvasPacket;
import com.dairymoose.modernlife.util.CanvasData;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerboundMultipartCameraPacket
implements Packet<ServerGamePacketListener> {
    private int texWidth;
    private int texHeight;
    private int seqNo;
    private boolean last;
    private byte[] image;
    private static final Logger LOGGER = LogManager.getLogger();
    private static long lastPacketTimestamp = 0L;
    private static int incomingPacketCounter = 0;
    private static long reenableCamera = 0L;
    public static String cameraImageExtension = ".png";
    public static String easelImageExtension = ".png";
    public static String cameraImageExtension_JPG = ".jpg";
    public static String cameraImageExtension_PNG = ".png";
    private boolean provideInstantCanvas = false;
    private static Map<Player, List<ServerboundMultipartCameraPacket>> cameraPackets = new HashMap<Player, List<ServerboundMultipartCameraPacket>>();
    public static Map<Long, CanvasHashCodeData> canvasHashCodes = new HashMap<Long, CanvasHashCodeData>();
    private static Object pngLocksArrayAccessor = new Object();
    private static Object[] pngLocks = new Object[0];
    static boolean didCameraExtError = false;

    public static int MAX_IMAGE_LENGTH(int textureSize) {
        return textureSize * textureSize * 3;
    }

    public ServerboundMultipartCameraPacket() {
    }

    public ServerboundMultipartCameraPacket(int seqNo, boolean last, byte[] image, int texWidth, int texHeight) {
        this.seqNo = seqNo;
        this.last = last;
        this.image = image;
        this.texWidth = texWidth;
        this.texHeight = texHeight;
    }

    public ServerboundMultipartCameraPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public void read(FriendlyByteBuf buffer) {
        this.seqNo = buffer.readInt();
        this.last = buffer.readBoolean();
        this.image = buffer.m_130052_();
        this.texWidth = buffer.readInt();
        this.texHeight = buffer.readInt();
    }

    public void m_5779_(FriendlyByteBuf buffer) {
        buffer.writeInt(this.seqNo);
        buffer.writeBoolean(this.last);
        buffer.m_130087_(this.image);
        buffer.writeInt(this.texWidth);
        buffer.writeInt(this.texHeight);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((ServerGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_());
        });
        ctx.get().setPacketHandled(true);
    }

    private ServerboundMultipartCameraPacket getLastPacket(List<ServerboundMultipartCameraPacket> packets) {
        for (ServerboundMultipartCameraPacket packet : packets) {
            if (!packet.last) continue;
            return packet;
        }
        return null;
    }

    public static void pushImageUpdate(long uniqueId, ServerPlayer player) {
        if ((Integer)ModernLifeConfig.SERVER.cameraUpdateRateLimit.get() == 0) {
            ServerboundMultipartCameraPacket.pushImageUpdateImmediate(uniqueId, player);
        } else {
            ModernLifeCommon.pendingImageUpdates.add(new ModernLifeCommon.PendingImageUpdate(uniqueId, player));
        }
    }

    public static void pushImageUpdateImmediate(long uniqueId, ServerPlayer player) {
        int MAX_IMAGE_PART = 30000;
        PngSizeHolder sizeHolder = new PngSizeHolder();
        byte[] compressed = ServerboundMultipartCameraPacket.loadPng(uniqueId, sizeHolder);
        CanvasHashCodeData chcd = new CanvasHashCodeData();
        chcd.hashCode = ModernLifeCommon.getHashCodeForBytes(compressed);
        chcd.timestamp = System.currentTimeMillis();
        canvasHashCodes.put(uniqueId, chcd);
        if (compressed != null) {
            ArrayList<byte[]> parts = new ArrayList<byte[]>();
            int i = 0;
            while ((double)i < Math.ceil((float)compressed.length / (float)MAX_IMAGE_PART)) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                int startIndex = i * MAX_IMAGE_PART;
                int bytesToWrite = Math.min(compressed.length - startIndex, MAX_IMAGE_PART);
                stream.write(compressed, startIndex, bytesToWrite);
                byte[] part = stream.toByteArray();
                parts.add(part);
                ++i;
            }
            int series = ClientboundMultipartCanvasPacket.seriesCounter.incrementAndGet();
            for (int i2 = 0; i2 < parts.size(); ++i2) {
                int seqNo = i2 + 1;
                boolean last = false;
                if (seqNo == parts.size()) {
                    last = true;
                }
                PacketDistributor.PacketTarget target = PacketDistributor.ALL.noArg();
                if (player != null) {
                    target = PacketDistributor.PLAYER.with(() -> player);
                }
                ModernLifeNetwork.INSTANCE.send(target, (Object)new ClientboundMultipartCanvasPacket(series, uniqueId, seqNo, last, (byte[])parts.get(i2), sizeHolder.width, sizeHolder.height, new BlockPos(1, 1, 1)));
            }
        } else {
            ModernLifeCommon.LOGGER.error("Failed to get updateTag png for ID=" + uniqueId);
        }
    }

    public static void pushImageUpdate(ItemStack itemStack) {
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("UniqueId")) {
            long uniqueId = itemStack.m_41783_().m_128454_("UniqueId");
            ServerboundMultipartCameraPacket.pushImageUpdate(uniqueId, null);
        }
    }

    public static String getSubFolderPrepend() {
        String folderName = null;
        folderName = ClientboundMultipartCanvasPacket.getFolderPath();
        Object subFolder = "";
        if (folderName != null && !((String)(subFolder = folderName)).endsWith("/")) {
            subFolder = (String)subFolder + "/";
        }
        return subFolder;
    }

    private static void addTextEntry(IIOMetadata metadata, String key, String value) throws IIOInvalidTreeException {
        IIOMetadataNode textEntry = new IIOMetadataNode("TextEntry");
        textEntry.setAttribute("keyword", key);
        textEntry.setAttribute("value", value);
        IIOMetadataNode text = new IIOMetadataNode("Text");
        text.appendChild(textEntry);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
        root.appendChild(text);
        metadata.mergeTree("javax_imageio_1.0", root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensurePngLockSize(long minSize) {
        if (pngLocks == null || (long)pngLocks.length < minSize) {
            Object object = pngLocksArrayAccessor;
            synchronized (object) {
                if (pngLocks == null || (long)pngLocks.length < minSize) {
                    pngLocks = new Object[(int)minSize];
                    for (int i = 0; i < pngLocks.length; ++i) {
                        ServerboundMultipartCameraPacket.pngLocks[i] = new Object();
                    }
                }
            }
        }
    }

    public static void saveImage(long uniqueId, byte[] stitchedImage, int w, int h) {
        ServerboundMultipartCameraPacket.savePng(uniqueId, stitchedImage, w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePng(long uniqueId, byte[] stitchedImage, int w, int h) {
        BufferedImage bufferedImage = new BufferedImage(w, h, 1);
        CanvasData canvasData = new CanvasData();
        canvasData.setTextureSize(w, h);
        canvasData.fromCompressedNbt(stitchedImage);
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int rgbPixel = canvasData.getRgbPixel(x, y);
                bufferedImage.setRGB(x, y, rgbPixel);
            }
        }
        String subFolder = ServerboundMultipartCameraPacket.getSubFolderPrepend();
        String ext = cameraImageExtension;
        if (w <= 256 && h <= 256) {
            ext = easelImageExtension;
        }
        String extWithoutDot = ext.substring(1);
        ModernLifeCommon.LOGGER.debug("save to: " + subFolder + " as type: " + extWithoutDot);
        File outputFile = new File(subFolder + "canvas" + uniqueId + ext);
        ServerboundMultipartCameraPacket.ensurePngLockSize(uniqueId + 1L);
        Object object = pngLocks[(int)uniqueId];
        synchronized (object) {
            try {
                if ("png".equals(extWithoutDot)) {
                    ImageIO.write((RenderedImage)bufferedImage, extWithoutDot, outputFile);
                } else {
                    try {
                        float quality = 1.0f;
                        quality = w <= 256 && h <= 256 ? ((Double)ModernLifeConfig.COMMON.smallImageJpgQuality.get()).floatValue() : ((Double)ModernLifeConfig.COMMON.largeImageJpgQuality.get()).floatValue();
                        ImageWriter writer = ImageIO.getImageWritersByFormatName("jpeg").next();
                        ImageWriteParam param = writer.getDefaultWriteParam();
                        param.setCompressionMode(2);
                        param.setCompressionQuality(quality);
                        writer.setOutput(ImageIO.createImageOutputStream(outputFile));
                        writer.write(null, new IIOImage(bufferedImage, null, null), param);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Failed to create JPG image", (Throwable)ex);
                    }
                }
            }
            catch (IOException e) {
                ModernLifeCommon.LOGGER.error("Error saving stitched image to disk with ID=" + uniqueId, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyPng(long uniqueId) {
        String subFolder = ServerboundMultipartCameraPacket.getSubFolderPrepend();
        long nextUniqueId = ModernLifeCommon.getNextCanvasId();
        File inputFile = ServerboundMultipartCameraPacket.getPngOrJpgFile(uniqueId, subFolder);
        File outputFile = new File(subFolder + "canvas" + nextUniqueId + cameraImageExtension);
        if (inputFile.exists()) {
            ServerboundMultipartCameraPacket.ensurePngLockSize(uniqueId + 1L);
            Object object = pngLocks[(int)uniqueId];
            synchronized (object) {
                try {
                    FileUtils.copyFile((File)inputFile, (File)outputFile);
                }
                catch (IOException e) {
                    ModernLifeCommon.LOGGER.error("Failed to copy file: " + inputFile + " to: " + outputFile);
                    return -1L;
                }
                return nextUniqueId;
            }
        }
        return -1L;
    }

    public static boolean deletePng(long uniqueId) {
        String subFolder = ServerboundMultipartCameraPacket.getSubFolderPrepend();
        File inputFile = ServerboundMultipartCameraPacket.getPngOrJpgFile(uniqueId, subFolder);
        if (inputFile.exists()) {
            return inputFile.delete();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadPng(long uniqueId, PngSizeHolder sizeHolder) {
        if (sizeHolder == null) {
            return null;
        }
        String subFolder = ServerboundMultipartCameraPacket.getSubFolderPrepend();
        File inputFile = ServerboundMultipartCameraPacket.getPngOrJpgFile(uniqueId, subFolder);
        BufferedImage image = null;
        if (inputFile.exists()) {
            ServerboundMultipartCameraPacket.ensurePngLockSize(uniqueId + 1L);
            Object object = pngLocks[(int)uniqueId];
            synchronized (object) {
                try {
                    image = ImageIO.read(inputFile);
                }
                catch (IOException e) {
                    ModernLifeCommon.LOGGER.error("Error reading saved png from disk with ID=" + uniqueId, (Throwable)e);
                }
            }
        }
        ModernLifeCommon.LOGGER.error("Canvas png did not exist for unique ID=" + uniqueId);
        if (image != null) {
            sizeHolder.width = image.getWidth();
            sizeHolder.height = image.getHeight();
            byte[] canvasData = ServerboundMultipartCameraPacket.toCanvasDataFromPng(image);
            image.flush();
            image = null;
            return canvasData;
        }
        return null;
    }

    private static File getPngOrJpgFile(long uniqueId, String subFolder) {
        String ext;
        File inputFile = new File(subFolder + "canvas" + uniqueId + cameraImageExtension);
        if (!inputFile.exists() && (inputFile = new File(subFolder + "canvas" + uniqueId + (ext = cameraImageExtension_PNG.equals(ext = cameraImageExtension) ? cameraImageExtension_JPG : cameraImageExtension_PNG))).exists() && !didCameraExtError) {
            didCameraExtError = true;
            LOGGER.error("Camera extension is set to " + cameraImageExtension + " by config, but found image of type: " + ext + " for file: " + inputFile);
        }
        return inputFile;
    }

    public static byte[] toCanvasDataFromPng(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            ModernLifeCommon.LOGGER.error("bufferedImage was null");
            return null;
        }
        if (bufferedImage.getWidth() <= 0 || bufferedImage.getHeight() <= 0) {
            ModernLifeCommon.LOGGER.error("Unexpected image size");
            return null;
        }
        int maxVal = 2048;
        Integer configInt = (Integer)ModernLifeConfig.SERVER.maxImageSizePixels.get();
        if (configInt != null) {
            maxVal = configInt;
        }
        if (bufferedImage.getWidth() > maxVal || bufferedImage.getHeight() > maxVal) {
            ModernLifeCommon.LOGGER.error("Image dimensions are too large");
            return null;
        }
        CanvasData canvasData = new CanvasData();
        canvasData.setTextureSize(bufferedImage.getWidth(), bufferedImage.getHeight());
        canvasData.initImage();
        ModernLifeCommon.LOGGER.debug("width = " + bufferedImage.getWidth());
        ModernLifeCommon.LOGGER.debug("height = " + bufferedImage.getHeight());
        ModernLifeCommon.LOGGER.debug("type = " + bufferedImage.getType());
        for (int x = 0; x < bufferedImage.getWidth(); ++x) {
            for (int y = 0; y < bufferedImage.getHeight(); ++y) {
                int rgb = bufferedImage.getRGB(x, y);
                canvasData.setRgbPixel(x, y, rgb);
            }
        }
        byte[] ret = canvasData.toCompressedNbt();
        canvasData.cleanup();
        return ret;
    }

    public void handle(ServerGamePacketListener p_148833_1_) {
        ModernLifeCommon.LOGGER.debug("Handle ServerboundMultipartCameraPacket");
        if (p_148833_1_ instanceof ServerGamePacketListenerImpl) {
            ServerGamePacketListenerImpl serverHandler = (ServerGamePacketListenerImpl)p_148833_1_;
            CompoundTag nbt = new CompoundTag();
            ServerLevel world = serverHandler.f_9743_.m_284548_();
            ModernLifeCommon.LOGGER.debug("world = " + (Level)world);
            if (world != null) {
                List<ServerboundMultipartCameraPacket> packets = cameraPackets.get(serverHandler.f_9743_);
                if (packets == null) {
                    packets = new ArrayList<ServerboundMultipartCameraPacket>();
                    cameraPackets.put((Player)serverHandler.f_9743_, packets);
                }
                packets.add(this);
                ServerboundMultipartCameraPacket lastPacket = this.getLastPacket(packets);
                byte[] stitchedImage = null;
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                if (lastPacket != null && packets.size() == lastPacket.seqNo) {
                    packets.sort(new Comparator<ServerboundMultipartCameraPacket>(){

                        @Override
                        public int compare(ServerboundMultipartCameraPacket var1, ServerboundMultipartCameraPacket var2) {
                            return var1.seqNo - var2.seqNo;
                        }
                    });
                    for (ServerboundMultipartCameraPacket packet : packets) {
                        try {
                            stream.write(packet.image);
                        }
                        catch (IOException e) {
                            ModernLifeCommon.LOGGER.debug("error writing image part", (Throwable)e);
                        }
                    }
                    stitchedImage = stream.toByteArray();
                }
                if (stitchedImage != null) {
                    ModernLifeCommon.LOGGER.debug("image length = " + stitchedImage.length);
                }
                int maxTexSizeW = 512;
                int maxTexSizeH = 512;
                Integer configIntW = (Integer)ModernLifeConfig.COMMON.cameraResolutionW.get();
                Integer configIntH = (Integer)ModernLifeConfig.COMMON.cameraResolutionH.get();
                if (configIntW != null) {
                    maxTexSizeW = configIntW;
                }
                if (configIntH != null) {
                    maxTexSizeH = configIntH;
                }
                if (stitchedImage != null && stitchedImage.length != 0 && stitchedImage.length <= ServerboundMultipartCameraPacket.MAX_IMAGE_LENGTH(maxTexSizeW) && this.texWidth <= maxTexSizeW && this.texHeight <= maxTexSizeH) {
                    packets.clear();
                    long currentTimestamp = System.currentTimeMillis();
                    long timeDiff = currentTimestamp - lastPacketTimestamp;
                    long timeDiffReenableCamera = currentTimestamp - reenableCamera;
                    if (timeDiffReenableCamera >= 0L) {
                        if (this.provideInstantCanvas) {
                            ItemStack itemStack = new ItemStack(new ItemLike(){

                                public Item m_5456_() {
                                    return (Item)CustomBlocks.ITEM_CANVAS.get();
                                }
                            });
                            long uniqueId = ModernLifeCommon.getNextCanvasId();
                            itemStack.m_41784_().m_128356_("UniqueId", uniqueId);
                            ServerboundMultipartCameraPacket.saveImage(uniqueId, stitchedImage, this.texWidth, this.texHeight);
                            if (this.texWidth > 0) {
                                itemStack.m_41783_().m_128405_("TextureSize", this.texWidth);
                                itemStack.m_41783_().m_128405_("TextureWidth", this.texWidth);
                                itemStack.m_41783_().m_128405_("TextureHeight", this.texHeight);
                            }
                            serverHandler.f_9743_.m_36356_(itemStack);
                        } else {
                            ItemStack itemStack = serverHandler.f_9743_.m_21205_();
                            if (itemStack.m_41720_() == CustomBlocks.ITEM_CAMERA.get() && itemStack.m_41773_() < itemStack.m_41776_()) {
                                Tag imageListTag = itemStack.m_41784_().m_128423_("ImageList");
                                ListTag imageList = null;
                                imageList = imageListTag instanceof ListTag ? (ListTag)imageListTag : new ListTag();
                                CompoundTag imageNbt = new CompoundTag();
                                long uniqueId = ModernLifeCommon.getNextCanvasId();
                                ServerboundMultipartCameraPacket.saveImage(uniqueId, stitchedImage, this.texWidth, this.texHeight);
                                imageNbt.m_128356_("UniqueId", uniqueId);
                                imageList.add((Object)imageNbt);
                                itemStack.m_41784_().m_128365_("ImageList", (Tag)imageList);
                                if (this.texWidth > 0) {
                                    itemStack.m_41783_().m_128405_("TextureSize", this.texWidth);
                                    itemStack.m_41783_().m_128405_("TextureWidth", this.texWidth);
                                    itemStack.m_41783_().m_128405_("TextureHeight", this.texHeight);
                                }
                                itemStack.m_220157_(1, RandomSource.m_216327_(), null);
                                ServerboundMultipartCameraPacket.pushImageUpdate(uniqueId, serverHandler.f_9743_);
                            }
                        }
                    }
                } else if (stitchedImage != null) {
                    packets.clear();
                    ModernLifeCommon.LOGGER.error("incoming image (" + this.texWidth + "/" + this.texHeight + "/" + maxTexSizeW + "/" + maxTexSizeH + ") is too big: " + stitchedImage.length + "/" + ServerboundMultipartCameraPacket.MAX_IMAGE_LENGTH(maxTexSizeW));
                }
            }
        }
    }

    public byte[] getImage() {
        return this.image;
    }

    public static class PngSizeHolder {
        public int width;
        public int height;
    }

    public static class CanvasHashCodeData {
        public Integer hashCode;
        public long timestamp;
    }
}

