/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.network.play.client;

import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.network.play.client.ServerboundMultipartCameraPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerboundRequestCanvasPacket
implements Packet<ServerGamePacketListener> {
    private long uniqueId;
    private static final Logger LOGGER = LogManager.getLogger();
    private static Map<Player, Map<Long, RequestInfo>> requestTimestamps = new HashMap<Player, Map<Long, RequestInfo>>();

    public ServerboundRequestCanvasPacket() {
    }

    public ServerboundRequestCanvasPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public ServerboundRequestCanvasPacket(long uniqueId) {
        this.uniqueId = uniqueId;
    }

    public void read(FriendlyByteBuf packet) {
        this.uniqueId = packet.readLong();
    }

    public void m_5779_(FriendlyByteBuf packet) {
        packet.writeLong(this.uniqueId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((ServerGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_());
        });
        ctx.get().setPacketHandled(true);
    }

    public void handle(ServerGamePacketListener p_148833_1_) {
        ModernLifeCommon.LOGGER.debug("Handle ServerboundRequestCanvasPacket");
        if (this.uniqueId <= 0L) {
            return;
        }
        if (p_148833_1_ instanceof ServerGamePacketListenerImpl) {
            ServerGamePacketListenerImpl serverHandler = (ServerGamePacketListenerImpl)p_148833_1_;
            long currentTime = System.currentTimeMillis();
            long timestamp = 0L;
            Map<Long, RequestInfo> requestMap = requestTimestamps.get(serverHandler.f_9743_);
            if (requestMap != null) {
                RequestInfo requestInfo = requestMap.get(this.uniqueId);
                if (requestInfo != null) {
                    timestamp = requestInfo.timestamp;
                }
            } else {
                requestMap = new HashMap<Long, RequestInfo>();
            }
            long timeDiff = currentTime - timestamp;
            if (timeDiff >= 30000L) {
                RequestInfo requestInfo = new RequestInfo();
                requestInfo.timestamp = currentTime;
                requestMap.put(this.uniqueId, requestInfo);
                requestTimestamps.put((Player)serverHandler.f_9743_, requestMap);
                ServerboundMultipartCameraPacket.pushImageUpdate(this.uniqueId, serverHandler.f_9743_);
                ModernLifeCommon.LOGGER.debug("sent reply to canvas request");
            }
        }
    }

    private static class RequestInfo {
        long timestamp;

        private RequestInfo() {
        }
    }
}

