/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.renderer.tileentity;

import com.dairymoose.modernlife.blocks.CanvasBlock;
import com.dairymoose.modernlife.core.ModernLifeConfig;
import com.dairymoose.modernlife.tileentities.AlarmClockBlockEntity;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class AlarmClockBlockEntityRenderer
implements BlockEntityRenderer<AlarmClockBlockEntity> {
    private static final Logger LOGGER = LogManager.getLogger();
    int currentPos = 0;
    private PoseStack currentStack = null;
    private static final int X_START = 44;
    private static final int X_INCREMENT = -13;
    private static final int Y_START = 13;
    private static final int MID_X_ADJUST = 2;
    private static final int MID_Y_ADJUST = -1;
    private static final int COLON_GAP = -4;
    private static final int COLON_X = 27;
    private static final int COLON_Y = 13;
    private static final int MOON_X = 54;
    private static final int MOON_Y = 3;
    private static final int PM_X = 51;
    private static final int PM_Y = 20;
    private static final long TIME_DIFFERENCE = 6000L;
    private static final long TIME_FULL_DAY = 24000L;
    private static final int TIME_UNITS_PER_MINUTE = 1000;

    public AlarmClockBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    private void resetCurrentPos() {
        this.currentPos = 0;
    }

    private void renderRect(PoseStack matrixStack, int x, int y, int width, int height) {
        int alpha = 255;
        int r = 249;
        int g = 8;
        int b = 40;
        Integer alarmClockTextColorR = (Integer)ModernLifeConfig.CLIENT.alarmClockTextColorR.get();
        Integer alarmClockTextColorG = (Integer)ModernLifeConfig.CLIENT.alarmClockTextColorG.get();
        Integer alarmClockTextColorB = (Integer)ModernLifeConfig.CLIENT.alarmClockTextColorB.get();
        if (alarmClockTextColorR != null) {
            r = alarmClockTextColorR;
        }
        if (alarmClockTextColorG != null) {
            g = alarmClockTextColorG;
        }
        if (alarmClockTextColorB != null) {
            b = alarmClockTextColorB;
        }
        int combinedColor = alpha << 24 | r << 16 | g << 8 | b;
        if (Minecraft.m_91087_().m_91269_().m_110104_() != null) {
            GuiGraphics graphics = new GuiGraphics(Minecraft.m_91087_(), Minecraft.m_91087_().m_91269_().m_110104_());
            graphics.m_280168_().m_166856_();
            graphics.m_280168_().m_252931_(matrixStack.m_85850_().m_252922_());
            graphics.m_285944_(RenderType.m_285907_(), x + width, y + height, x, y, combinedColor);
        }
    }

    private int getNewX() {
        int newX = 44 + this.currentPos * -13;
        if (this.currentPos >= 2) {
            newX -= 4;
        }
        return newX;
    }

    private int getNewY() {
        return 13;
    }

    private void renderTopRight() {
        int newX = this.getNewX();
        int newY = this.getNewY();
        this.renderRect(this.currentStack, newX, newY, 2, 8);
    }

    private void renderTop() {
        int newX = this.getNewX();
        int newY = this.getNewY();
        this.renderRect(this.currentStack, newX + 2, newY + 9 + -1, 7, 2);
    }

    private void renderTopLeft() {
        int newX = this.getNewX();
        int newY = this.getNewY();
        this.renderRect(this.currentStack, newX + 9, newY, 2, 8);
    }

    private void renderMid() {
        int newX = this.getNewX();
        int newY = this.getNewY();
        this.renderRect(this.currentStack, newX + 2, newY + -1, 7, 2);
    }

    private void renderBottomRight() {
        int newX = this.getNewX();
        int newY = this.getNewY();
        this.renderRect(this.currentStack, newX, newY - 9, 2, 8);
    }

    private void renderBottom() {
        int newX = this.getNewX();
        int newY = this.getNewY();
        this.renderRect(this.currentStack, newX + 2, newY - 9 + -1, 7, 2);
    }

    private void renderBottomLeft() {
        int newX = this.getNewX();
        int newY = this.getNewY();
        this.renderRect(this.currentStack, newX + 9, newY - 9, 2, 8);
    }

    private void renderColon() {
        this.renderRect(this.currentStack, 27, 13, 2, 2);
        this.renderRect(this.currentStack, 27, 9, 2, 2);
    }

    private void renderMoon() {
        this.renderRect(this.currentStack, 54, 3, 1, 1);
        this.renderRect(this.currentStack, 53, 3, 1, 1);
        this.renderRect(this.currentStack, 55, 2, 1, 1);
        this.renderRect(this.currentStack, 55, 1, 1, 1);
        this.renderRect(this.currentStack, 52, 2, 1, 1);
        this.renderRect(this.currentStack, 52, 1, 1, 1);
        this.renderRect(this.currentStack, 54, 0, 1, 1);
        this.renderRect(this.currentStack, 53, 0, 1, 1);
    }

    private void renderPmDot() {
        this.renderRect(this.currentStack, 51, 20, 4, 4);
    }

    private void renderNumber(int no) {
        if (no == 1) {
            this.renderTopRight();
            this.renderBottomRight();
        } else if (no == 2) {
            this.renderTop();
            this.renderTopRight();
            this.renderMid();
            this.renderBottomLeft();
            this.renderBottom();
        } else if (no == 3) {
            this.renderTop();
            this.renderTopRight();
            this.renderMid();
            this.renderBottomRight();
            this.renderBottom();
        } else if (no == 4) {
            this.renderTopLeft();
            this.renderTopRight();
            this.renderMid();
            this.renderBottomRight();
        } else if (no == 5) {
            this.renderTop();
            this.renderTopLeft();
            this.renderMid();
            this.renderBottomRight();
            this.renderBottom();
        } else if (no == 6) {
            this.renderTop();
            this.renderTopLeft();
            this.renderMid();
            this.renderBottomRight();
            this.renderBottom();
            this.renderBottomLeft();
        } else if (no == 7) {
            this.renderTop();
            this.renderTopRight();
            this.renderBottomRight();
        } else if (no == 8) {
            this.renderTopLeft();
            this.renderTop();
            this.renderTopRight();
            this.renderMid();
            this.renderBottom();
            this.renderBottomLeft();
            this.renderBottomRight();
        } else if (no == 9) {
            this.renderTopLeft();
            this.renderTop();
            this.renderTopRight();
            this.renderMid();
            this.renderBottom();
            this.renderBottomRight();
        } else if (no == 0) {
            this.renderTopLeft();
            this.renderTop();
            this.renderTopRight();
            this.renderBottom();
            this.renderBottomLeft();
            this.renderBottomRight();
        }
        ++this.currentPos;
    }

    private void renderTime(int hour, int minute) {
        int hourLeftDigit = hour / 10;
        int hourRightDigit = hour % 10;
        if (hourLeftDigit > 0) {
            this.renderNumber(hourLeftDigit);
        } else {
            ++this.currentPos;
        }
        this.renderNumber(hourRightDigit);
        int minuteLeftDigit = minute / 10;
        int minuteRightDigit = minute % 10;
        this.renderNumber(minuteLeftDigit);
        this.renderNumber(minuteRightDigit);
        this.renderColon();
    }

    public void render(AlarmClockBlockEntity tileEntity, float v, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int lightmap, int i1) {
        int hour;
        Boolean configMoonIndicator;
        long currentTime;
        switch ((Direction)tileEntity.m_58900_().m_61143_((Property)CanvasBlock.FACING)) {
            case EAST: {
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                break;
            }
            case WEST: {
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                matrixStack.m_252880_(-1.0f, 0.0f, 1.0f);
                break;
            }
            case NORTH: {
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                matrixStack.m_252880_(0.0f, 0.0f, 1.0f);
                break;
            }
            case SOUTH: {
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                matrixStack.m_252880_(-1.0f, 0.0f, 0.0f);
            }
        }
        matrixStack.m_252880_(0.0f, 0.0f, -0.815f);
        matrixStack.m_85841_(0.01f, 0.01f, 0.01f);
        matrixStack.m_252880_(10.0f, 0.0f, 0.0f);
        matrixStack.m_252880_(11.8f, 3.2f, 0.0f);
        RenderSystem.enableDepthTest();
        this.currentStack = matrixStack;
        this.resetCurrentPos();
        long dayTime = Minecraft.m_91087_().f_91073_.m_46468_();
        long displayTime = currentTime = (dayTime + 6000L) % 24000L;
        Boolean config24Hours = (Boolean)ModernLifeConfig.CLIENT.clock24HoursMode.get();
        if (!(config24Hours != null && config24Hours.booleanValue() || currentTime < 12000L)) {
            this.renderPmDot();
            displayTime = currentTime - 12000L;
        }
        if ((configMoonIndicator = (Boolean)ModernLifeConfig.CLIENT.moonIndicator.get()) != null && configMoonIndicator.booleanValue() && (currentTime >= 18542L || currentTime < 5460L)) {
            this.renderMoon();
        }
        if ((hour = (int)displayTime / 1000) == 0) {
            hour = 12;
        }
        int minute = 60 * ((int)displayTime % 1000) / 1000;
        this.renderTime(hour, minute);
    }
}

