/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.renderer.tileentity;

import com.dairymoose.modernlife.blocks.gui.chess.BishopPiece;
import com.dairymoose.modernlife.blocks.gui.chess.KingPiece;
import com.dairymoose.modernlife.blocks.gui.chess.KnightPiece;
import com.dairymoose.modernlife.blocks.gui.chess.PawnPiece;
import com.dairymoose.modernlife.blocks.gui.chess.Piece;
import com.dairymoose.modernlife.blocks.gui.chess.QueenPiece;
import com.dairymoose.modernlife.blocks.gui.chess.RookPiece;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.network.play.client.ServerboundChessStatePacket;
import com.dairymoose.modernlife.tileentities.ChessBoardBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ChessBoardBlockEntityRenderer
implements BlockEntityRenderer<ChessBoardBlockEntity> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ItemStack IS_ROOK = new ItemStack(new ItemLike(){

        public Item m_5456_() {
            return (Item)CustomBlocks.ITEM_CHESS_ROOK.get();
        }
    });
    private static final ItemStack IS_BISHOP = new ItemStack(new ItemLike(){

        public Item m_5456_() {
            return (Item)CustomBlocks.ITEM_CHESS_BISHOP.get();
        }
    });
    private static final ItemStack IS_PAWN = new ItemStack(new ItemLike(){

        public Item m_5456_() {
            return (Item)CustomBlocks.ITEM_CHESS_PAWN.get();
        }
    });
    private static final ItemStack IS_KNIGHT = new ItemStack(new ItemLike(){

        public Item m_5456_() {
            return (Item)CustomBlocks.ITEM_CHESS_KNIGHT.get();
        }
    });
    private static final ItemStack IS_KING = new ItemStack(new ItemLike(){

        public Item m_5456_() {
            return (Item)CustomBlocks.ITEM_CHESS_KING.get();
        }
    });
    private static final ItemStack IS_QUEEN = new ItemStack(new ItemLike(){

        public Item m_5456_() {
            return (Item)CustomBlocks.ITEM_CHESS_QUEEN.get();
        }
    });
    private static final ItemStack IS_ROOK_W = new ItemStack(new ItemLike(){

        public Item m_5456_() {
            return (Item)CustomBlocks.ITEM_CHESS_ROOK_W.get();
        }
    });
    private static final ItemStack IS_BISHOP_W = new ItemStack(new ItemLike(){

        public Item m_5456_() {
            return (Item)CustomBlocks.ITEM_CHESS_BISHOP_W.get();
        }
    });
    private static final ItemStack IS_PAWN_W = new ItemStack(new ItemLike(){

        public Item m_5456_() {
            return (Item)CustomBlocks.ITEM_CHESS_PAWN_W.get();
        }
    });
    private static final ItemStack IS_KNIGHT_W = new ItemStack(new ItemLike(){

        public Item m_5456_() {
            return (Item)CustomBlocks.ITEM_CHESS_KNIGHT_W.get();
        }
    });
    private static final ItemStack IS_KING_W = new ItemStack(new ItemLike(){

        public Item m_5456_() {
            return (Item)CustomBlocks.ITEM_CHESS_KING_W.get();
        }
    });
    private static final ItemStack IS_QUEEN_W = new ItemStack(new ItemLike(){

        public Item m_5456_() {
            return (Item)CustomBlocks.ITEM_CHESS_QUEEN_W.get();
        }
    });
    public static Map<BlockPos, GameState> stateMap = new HashMap<BlockPos, GameState>();
    private static final float WHITE_OVERLAY_PACK_VALUE = 0.5f;

    public ChessBoardBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void renderPiece(ItemStack toRender, int x, int y, PoseStack matrixStack, int lightmap, int overlay, MultiBufferSource iRenderTypeBuffer) {
        matrixStack.m_85836_();
        double xStart = 0.225;
        double yStart = 0.12;
        double zStart = 0.225;
        double gridSize = 0.0782;
        matrixStack.m_85837_(xStart + (double)x * gridSize, yStart, zStart + (double)y * gridSize);
        matrixStack.m_85841_(0.12f, 0.12f, 0.12f);
        Minecraft.m_91087_().m_91291_().m_269128_(toRender, ItemDisplayContext.FIXED, lightmap, overlay, matrixStack, iRenderTypeBuffer, (Level)Minecraft.m_91087_().f_91073_, 0);
        matrixStack.m_85849_();
    }

    private void defaultPiecesOneSide(int startY, int yIncrement, PoseStack matrixStack, int lightmap, int overlay, MultiBufferSource iRenderTypeBuffer, boolean isWhite) {
        this.renderPiece(isWhite ? IS_ROOK_W : IS_ROOK, 0, startY, matrixStack, lightmap, overlay, iRenderTypeBuffer);
        this.renderPiece(isWhite ? IS_KNIGHT_W : IS_KNIGHT, 1, startY, matrixStack, lightmap, overlay, iRenderTypeBuffer);
        this.renderPiece(isWhite ? IS_BISHOP_W : IS_BISHOP, 2, startY, matrixStack, lightmap, overlay, iRenderTypeBuffer);
        this.renderPiece(isWhite ? IS_KING_W : IS_KING, 3, startY, matrixStack, lightmap, overlay, iRenderTypeBuffer);
        this.renderPiece(isWhite ? IS_QUEEN_W : IS_QUEEN, 4, startY, matrixStack, lightmap, overlay, iRenderTypeBuffer);
        this.renderPiece(isWhite ? IS_BISHOP_W : IS_BISHOP, 5, startY, matrixStack, lightmap, overlay, iRenderTypeBuffer);
        this.renderPiece(isWhite ? IS_KNIGHT_W : IS_KNIGHT, 6, startY, matrixStack, lightmap, overlay, iRenderTypeBuffer);
        this.renderPiece(isWhite ? IS_ROOK_W : IS_ROOK, 7, startY, matrixStack, lightmap, overlay, iRenderTypeBuffer);
        for (int i = 0; i < 8; ++i) {
            this.renderPiece(isWhite ? IS_PAWN_W : IS_PAWN, i, startY + yIncrement, matrixStack, lightmap, overlay, iRenderTypeBuffer);
        }
    }

    public void defaultBoardState(PoseStack matrixStack, int lightmap, int overlay, MultiBufferSource iRenderTypeBuffer) {
        this.defaultPiecesOneSide(0, 1, matrixStack, lightmap, overlay, iRenderTypeBuffer, false);
        this.defaultPiecesOneSide(7, -1, matrixStack, lightmap, overlay, iRenderTypeBuffer, true);
    }

    public ItemStack getItemStackForPiece(Piece p, boolean isWhite) {
        ItemStack pieceType = null;
        if (p instanceof RookPiece) {
            pieceType = isWhite ? IS_ROOK_W : IS_ROOK;
        } else if (p instanceof BishopPiece) {
            pieceType = isWhite ? IS_BISHOP_W : IS_BISHOP;
        } else if (p instanceof PawnPiece) {
            pieceType = isWhite ? IS_PAWN_W : IS_PAWN;
        } else if (p instanceof KnightPiece) {
            pieceType = isWhite ? IS_KNIGHT_W : IS_KNIGHT;
        } else if (p instanceof KingPiece) {
            pieceType = isWhite ? IS_KING_W : IS_KING;
        } else if (p instanceof QueenPiece) {
            pieceType = isWhite ? IS_QUEEN_W : IS_QUEEN;
        }
        return pieceType;
    }

    public void nbtBoardState(PoseStack matrixStack, int lightmap, int overlay, MultiBufferSource iRenderTypeBuffer, GameState gameState) {
        int y;
        int x;
        ItemStack pieceType;
        boolean mirrorBoard = gameState.isWhiteTurn;
        for (Piece p : gameState.blackPieces) {
            pieceType = this.getItemStackForPiece(p, false);
            if (pieceType == null) continue;
            x = p.x;
            y = p.y;
            if (mirrorBoard) {
                x = 7 - x;
                y = 7 - y;
            }
            this.renderPiece(pieceType, x, y, matrixStack, lightmap, overlay, iRenderTypeBuffer);
        }
        for (Piece p : gameState.whitePieces) {
            pieceType = this.getItemStackForPiece(p, true);
            if (pieceType == null) continue;
            x = p.x;
            y = p.y;
            if (mirrorBoard) {
                x = 7 - x;
                y = 7 - y;
            }
            this.renderPiece(pieceType, x, y, matrixStack, lightmap, overlay, iRenderTypeBuffer);
        }
    }

    public void render(ChessBoardBlockEntity tileEntity, float v, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int lightmap, int overlay) {
        ItemStack itemStack;
        if (!tileEntity.m_7983_() && (itemStack = tileEntity.m_8020_(0)).m_41720_() == CustomBlocks.ITEM_CHESS_BOARD.get()) {
            CompoundTag nbt = itemStack.m_41783_();
            if (nbt != null && nbt.m_128441_("BoardState")) {
                int newHash;
                GameState gameState = stateMap.get(tileEntity.m_58899_());
                if (gameState == null) {
                    gameState = new GameState();
                    stateMap.put(tileEntity.m_58899_(), gameState);
                }
                if ((newHash = nbt.hashCode()) != gameState.lastHash) {
                    ModernLifeCommon.LOGGER.debug("check nbt: " + newHash + "/" + gameState.lastHash);
                    ModernLifeCommon.LOGGER.debug("nbt=" + nbt);
                    gameState.lastHash = newHash;
                    ServerboundChessStatePacket packet = ServerboundChessStatePacket.fromNbt(nbt);
                    gameState.whitePieces = new ArrayList<Piece>(packet.whitePieces);
                    gameState.blackPieces = new ArrayList<Piece>(packet.blackPieces);
                    gameState.isWhiteTurn = packet.isWhiteTurn;
                }
                this.nbtBoardState(matrixStack, lightmap, overlay, iRenderTypeBuffer, gameState);
            } else {
                this.defaultBoardState(matrixStack, lightmap, overlay, iRenderTypeBuffer);
            }
        }
    }

    public class GameState {
        private int lastHash = 0;
        private List<Piece> whitePieces;
        private List<Piece> blackPieces;
        private boolean isWhiteTurn = true;
    }
}

