/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.renderer.tileentity;

import com.dairymoose.modernlife.blocks.CanvasBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeClient;
import com.dairymoose.modernlife.tileentities.CCTVCameraBlockEntity;
import com.dairymoose.modernlife.tileentities.MirrorBlockEntity;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class MirrorBlockEntityRenderer
implements BlockEntityRenderer<MirrorBlockEntity> {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean ignoreRender = false;
    public static RenderTarget mirrorFramebuffer = null;
    public static Map<BlockPos, MirrorBlockEntity> mirrorMap = new HashMap<BlockPos, MirrorBlockEntity>();
    private boolean insetIntoMirror = true;

    private void renderTexture(float size, PoseStack matrixStack, int lightmap, boolean flipX) {
        this.renderTextureRect(size, size, matrixStack, lightmap, flipX);
    }

    public MirrorBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    private void renderTextureRect(float width, float height, PoseStack matrixStack, int lightmap, boolean flipX) {
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f poseMatrix = matrixStack.m_85850_().m_252922_();
        float uMin = 0.0f;
        float uMax = 1.0f;
        if (flipX) {
            uMin = 1.0f;
            uMax = 0.0f;
        }
        builder.m_252986_(poseMatrix, 0.0f, height, 0.0f).m_7421_(uMin, 1.0f).m_85969_(lightmap).m_5752_();
        builder.m_252986_(poseMatrix, width, height, 0.0f).m_7421_(uMax, 1.0f).m_85969_(lightmap).m_5752_();
        builder.m_252986_(poseMatrix, width, 0.0f, 0.0f).m_7421_(uMax, 0.0f).m_85969_(lightmap).m_5752_();
        builder.m_252986_(poseMatrix, 0.0f, 0.0f, 0.0f).m_7421_(uMin, 0.0f).m_85969_(lightmap).m_5752_();
        RenderSystem.enableDepthTest();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
    }

    public void render(MirrorBlockEntity tileEntity, float v, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int lightmap, int overlayColor) {
        if (this.ignoreRender) {
            return;
        }
        if (mirrorFramebuffer == null) {
            return;
        }
        mirrorMap.put(tileEntity.m_58899_(), tileEntity);
        if (ModernLifeClient.getChosenMirror() != tileEntity) {
            return;
        }
        matrixStack.m_85836_();
        switch ((Direction)tileEntity.m_58900_().m_61143_((Property)CanvasBlock.FACING)) {
            case EAST: {
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                break;
            }
            case WEST: {
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                matrixStack.m_252880_(-1.0f, 0.0f, 1.0f);
                break;
            }
            case NORTH: {
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                matrixStack.m_252880_(0.0f, 0.0f, 1.0f);
                break;
            }
            case SOUTH: {
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                matrixStack.m_252880_(-1.0f, 0.0f, 0.0f);
            }
        }
        matrixStack.m_252880_(0.0f, 0.0f, -0.0623f);
        if (this.insetIntoMirror) {
            matrixStack.m_252880_(0.05f, 0.05f, 0.0f);
        }
        int w = Minecraft.m_91087_().m_91268_().m_85441_();
        int h = Minecraft.m_91087_().m_91268_().m_85442_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem._setShaderTexture((int)0, (int)mirrorFramebuffer.m_83975_());
        float size = 1.0f;
        if (this.insetIntoMirror) {
            size = 0.9f;
        }
        if (tileEntity.m_58900_().m_60734_() == CustomBlocks.BLOCK_TALL_MIRROR.get()) {
            matrixStack.m_252880_(0.0f, 0.05f, 0.0f);
            this.renderTextureRect(0.9f, 1.85f, matrixStack, lightmap, false);
        } else if (tileEntity.m_58900_().m_60734_() == CustomBlocks.BLOCK_LARGE_MIRROR.get()) {
            matrixStack.m_252880_(-0.5f, 0.05f, 0.0f);
            this.renderTexture(1.8f, matrixStack, lightmap, false);
        } else if (tileEntity.m_58900_().m_60734_() == CustomBlocks.BLOCK_MASSIVE_MIRROR.get()) {
            matrixStack.m_252880_(-0.9f, 0.05f, 0.0f);
            this.renderTextureRect(2.7f, 1.85f, matrixStack, lightmap, false);
        } else if (tileEntity.m_58900_().m_60734_() == CustomBlocks.BLOCK_CCTV_SCREEN.get()) {
            if (ModernLifeClient.cctvCurrentCamera != null) {
                matrixStack.m_85837_(0.0, 0.0, (double)-0.001f);
                this.renderTexture(size, matrixStack, lightmap, true);
                if (CCTVCameraBlockEntity.cctvCameras.size() > 0) {
                    matrixStack.m_85836_();
                    matrixStack.m_252880_(0.87f, 0.1f, -0.01f);
                    float scaleValue = -0.01f;
                    matrixStack.m_85841_(scaleValue, scaleValue, scaleValue);
                    int camValue = tileEntity.cctvScreenCurrentCameraDisplayValue + 1;
                    String camText = "CAM" + String.valueOf(camValue);
                    GuiGraphics graphics = new GuiGraphics(Minecraft.m_91087_(), Minecraft.m_91087_().m_91269_().m_110104_());
                    graphics.m_280168_().m_166856_();
                    graphics.m_280168_().m_252931_(matrixStack.m_85850_().m_252922_());
                    graphics.drawString(Minecraft.m_91087_().f_91062_, camText, 0.0f, 0.0f, 0xFFFFFF, true);
                    matrixStack.m_85849_();
                }
            }
        } else {
            this.renderTexture(size, matrixStack, lightmap, false);
        }
        matrixStack.m_85849_();
    }
}

