/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.tileentities;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import com.dairymoose.modernlife.network.play.client.ServerboundWirelessChannelPacket;
import com.dairymoose.modernlife.tileentities.IChannelHolder;
import com.dairymoose.modernlife.tileentities.PowerReceiverBlockEntity;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PowerTransmitterBlockEntity
extends BlockEntity
implements IChannelHolder {
    public static Map<Integer, Set<PowerTransmitterBlockEntity>> perChannelPowerTransmitters = new ConcurrentHashMap<Integer, Set<PowerTransmitterBlockEntity>>();
    private int currentChannel = 0;
    public static final BlockEntityType<PowerTransmitterBlockEntity> POWER_TRANSMITTER = BlockEntityType.Builder.m_155273_(PowerTransmitterBlockEntity::new, (Block[])new Block[]{(Block)CustomBlocks.BLOCK_POWER_TRANSMITTER.get()}).m_58966_(null);
    private static final Logger LOGGER = LogManager.getLogger();

    public String toString() {
        return "(channel=" + this.getCurrentChannel() + ", pos=" + this.m_58899_() + ")";
    }

    public void updateReceivers(Level world) {
        Set<PowerReceiverBlockEntity> receivers = PowerReceiverBlockEntity.perChannelPowerReceivers.get(this.currentChannel);
        if (receivers != null) {
            ServerboundWirelessChannelPacket.purgeRemovedChannelHolders(receivers);
            for (PowerReceiverBlockEntity receiver : receivers) {
                ModernLifeCommon.LOGGER.debug("issued update to " + receiver.m_58899_());
                if (!world.m_46749_(receiver.m_58899_())) continue;
                world.m_46672_(receiver.m_58899_(), receiver.m_58900_().m_60734_());
                for (Direction d : Direction.values()) {
                    world.m_46672_(receiver.m_58899_().m_121945_(d), receiver.m_58900_().m_60734_());
                }
            }
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128405_("channel", this.currentChannel);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        if (tag.m_128441_("channel")) {
            this.currentChannel = tag.m_128451_("channel");
        }
        super.handleUpdateTag(tag);
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128405_("channel", this.currentChannel);
        ModernLifeCommon.LOGGER.debug("save with channel=" + this.currentChannel + " at pos=" + this.m_58899_());
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("channel")) {
            this.currentChannel = nbt.m_128451_("channel");
            this.addToChannel(this.currentChannel);
        }
        ModernLifeCommon.LOGGER.debug("load with channel=" + this.currentChannel);
    }

    public void m_6596_() {
        super.m_6596_();
        ModernLifeCommon.LOGGER.debug("setChanged");
    }

    public boolean equals(Object other) {
        if (other instanceof PowerTransmitterBlockEntity) {
            PowerTransmitterBlockEntity otherTransmitter = (PowerTransmitterBlockEntity)other;
            return this.m_58899_().equals((Object)otherTransmitter.m_58899_());
        }
        return false;
    }

    public int hashCode() {
        return this.m_58899_().hashCode();
    }

    public void addToChannel(int channel) {
        ModernLifeCommon.LOGGER.debug("adding transmitter at " + this.m_58899_() + " with channel: " + this.currentChannel);
        Set<PowerTransmitterBlockEntity> entities = perChannelPowerTransmitters.get(channel);
        if (entities == null) {
            entities = new HashSet<PowerTransmitterBlockEntity>();
            perChannelPowerTransmitters.put(channel, entities);
        }
        ModernLifeCommon.LOGGER.debug("add " + this + " to channel " + channel + " with BlockPos=" + this.m_58899_());
        entities.add(this);
        ModernLifeCommon.LOGGER.debug("transmitter count = " + perChannelPowerTransmitters.size());
    }

    public void removeFromChannel(int channel) {
        ModernLifeCommon.LOGGER.debug("removing transmitter at " + this.m_58899_() + " with channel: " + this.currentChannel);
        Set<PowerTransmitterBlockEntity> entities = perChannelPowerTransmitters.get(channel);
        if (entities == null) {
            entities = new HashSet<PowerTransmitterBlockEntity>();
            perChannelPowerTransmitters.put(channel, entities);
        }
        ModernLifeCommon.LOGGER.debug("remove " + this);
        entities.remove(this);
        ModernLifeCommon.LOGGER.debug("transmitter count = " + perChannelPowerTransmitters.size());
    }

    public PowerTransmitterBlockEntity(BlockPos pos, BlockState state) {
        super(POWER_TRANSMITTER, pos, state);
        ModernLifeCommon.LOGGER.debug("PowerTransmitterBlockEntity CONSTRUCTOR");
    }

    @Override
    public int getCurrentChannel() {
        return this.currentChannel;
    }

    @Override
    public void setCurrentChannel(int newChannel) {
        this.m_6596_();
        this.removeFromChannel(this.currentChannel);
        this.updateReceivers(this.m_58904_());
        this.currentChannel = newChannel;
        this.addToChannel(this.currentChannel);
        this.updateReceivers(this.m_58904_());
    }
}

