/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.tileentities;

import com.dairymoose.modernlife.blocks.RadiatorBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RadiatorBlockEntity
extends BlockEntity {
    public static final BlockEntityType<RadiatorBlockEntity> RADIATOR = BlockEntityType.Builder.m_155273_(RadiatorBlockEntity::new, (Block[])new Block[]{(Block)CustomBlocks.BLOCK_RADIATOR.get()}).m_58966_(null);
    private static final Logger LOGGER = LogManager.getLogger();
    private double multLow = 1.0;
    private double multMed = 1.6;
    private double multHigh = 2.56;
    final int LOW_DIAMETER = 9;
    final int MED_DIAMETER = 13;
    final int HIGH_DIAMETER = 19;

    public RadiatorBlockEntity(BlockPos pos, BlockState state) {
        super(RADIATOR, pos, state);
    }

    private void meltTargetedSpot(ServerLevel world, BlockPos targetPos, double meltMult) {
        double meltChance = 1.0 / targetPos.m_123331_((Vec3i)this.m_58899_());
        meltChance *= 1.0;
        meltChance *= meltMult;
        if (Math.random() >= meltChance) {
            return;
        }
        BlockState targetBlockState = world.m_8055_(targetPos);
        if (targetBlockState.m_60713_(Blocks.f_50126_) || targetBlockState.m_60713_(Blocks.f_50354_) || targetBlockState.m_60713_(Blocks.f_50568_) || targetBlockState.m_60713_(Blocks.f_50449_)) {
            world.m_46597_(targetPos, Blocks.f_49990_.m_49966_());
            world.m_46586_(targetPos, Blocks.f_49990_, targetPos);
        } else if (targetBlockState.m_60713_(Blocks.f_50125_) || targetBlockState.m_60713_(Blocks.f_50127_)) {
            Optional snowyValue = targetBlockState.m_61145_((Property)BlockStateProperties.f_61451_);
            world.m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 0.5, (double)targetPos.m_123343_() + 0.5, 0, 0.0, 0.0, 0.0, 0.0);
            world.m_46961_(targetPos, false);
        }
    }

    public void meltSnow(int meltDiameter, double meltMult, int n) {
        for (int i = 0; i < n; ++i) {
            int xOffset = (int)((double)meltDiameter * Math.random()) - meltDiameter / 2;
            int zOffset = (int)((double)meltDiameter * Math.random()) - meltDiameter / 2;
            Level level = this.m_58904_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel world = (ServerLevel)level;
            BlockPos targetPos = new BlockPos(this.m_58899_().m_123341_() + xOffset, this.m_58899_().m_123342_(), this.m_58899_().m_123343_() + zOffset);
            this.meltTargetedSpot(world, targetPos, meltMult);
            this.meltTargetedSpot(world, targetPos.m_7495_(), meltMult);
            this.meltTargetedSpot(world, targetPos.m_7495_().m_7495_(), meltMult);
            this.meltTargetedSpot(world, targetPos.m_7494_(), meltMult);
            this.meltTargetedSpot(world, targetPos.m_7494_().m_7494_(), meltMult);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, RadiatorBlockEntity entity) {
        entity.tick();
    }

    public void tick() {
        RadiatorBlock.HeatType heat = (RadiatorBlock.HeatType)((Object)this.m_58900_().m_61143_(RadiatorBlock.HEAT));
        switch (heat) {
            case off: {
                break;
            }
            case low: {
                this.meltSnow(9, this.multLow, 1);
                break;
            }
            case medium: {
                this.meltSnow(13, this.multMed, 2);
                break;
            }
            case high: {
                this.meltSnow(19, this.multHigh, 5);
            }
        }
    }
}

