/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.tileentities;

import com.dairymoose.modernlife.blocks.ShowerHeadBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShowerHeadBlockEntity
extends BlockEntity {
    public static final BlockEntityType<ShowerHeadBlockEntity> SHOWER_HEAD = BlockEntityType.Builder.m_155273_(ShowerHeadBlockEntity::new, (Block[])new Block[]{(Block)CustomBlocks.BLOCK_SHOWER_HEAD.get()}).m_58966_(null);
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean running = false;
    private int tickCount = 0;
    private int waterEscalateTicks = 15;
    private int currentParticleCount = 0;
    private int maxParticleCount = 20;
    private int soundStartTick = 25;

    public void startRunning() {
        this.tickCount = 0;
        this.running = true;
    }

    public void stopRunning() {
        if (this.tickCount > 0) {
            this.tickCount = 35;
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128379_("running", this.running);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        if (tag.m_128441_("running")) {
            this.running = tag.m_128471_("running");
        }
        super.handleUpdateTag(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection conn, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null && tag.m_128441_("running")) {
            this.running = tag.m_128471_("running");
        }
    }

    public void m_142466_(CompoundTag p_230337_2_) {
        super.m_142466_(p_230337_2_);
        if (p_230337_2_.m_128441_("running")) {
            this.running = p_230337_2_.m_128471_("running");
        }
    }

    protected void m_183515_(CompoundTag p_189515_1_) {
        p_189515_1_.m_128379_("running", this.running);
    }

    public ShowerHeadBlockEntity(BlockPos pos, BlockState state) {
        super(SHOWER_HEAD, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ShowerHeadBlockEntity entity) {
        entity.tick();
    }

    public void tick() {
        if (this.f_58857_.f_46443_) {
            int particleCount = this.currentParticleCount;
            double horzSpread = 0.2;
            double verticalSpread = 0.37;
            double xStart = 0.5;
            double yStart = 0.51;
            double zStart = 0.65;
            if (this.m_58900_().m_61143_((Property)ShowerHeadBlock.FACING) == Direction.SOUTH) {
                xStart = 1.0 - xStart;
                zStart = 1.0 - zStart;
            } else if (this.m_58900_().m_61143_((Property)ShowerHeadBlock.FACING) == Direction.EAST) {
                xStartOriginal = xStart;
                xStart = 1.0 - zStart;
                zStart = 1.0 - xStartOriginal;
            } else if (this.m_58900_().m_61143_((Property)ShowerHeadBlock.FACING) == Direction.WEST) {
                xStartOriginal = xStart;
                xStart = zStart;
                zStart = xStartOriginal;
            }
            if (this.running) {
                if (this.tickCount == 0) {
                    this.currentParticleCount = 0;
                }
                if (this.tickCount % this.waterEscalateTicks == 0 && this.currentParticleCount < this.maxParticleCount) {
                    ++this.currentParticleCount;
                }
                BlockPos pos = this.m_58899_();
                if (this.tickCount % 2 == 0) {
                    for (int i = 0; i < particleCount; ++i) {
                        if (this.f_58857_.m_46472_() == Level.f_46429_) {
                            double smokeRandom = 0.02;
                            if (this.tickCount % 6 != 0) continue;
                            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + xStart + (Math.random() * horzSpread - horzSpread / 2.0), (double)pos.m_123342_() + yStart - Math.random() * verticalSpread, (double)pos.m_123343_() + zStart + (Math.random() * horzSpread - horzSpread / 2.0), Math.random() * smokeRandom - smokeRandom / 2.0, Math.random() * smokeRandom - smokeRandom / 2.0, Math.random() * smokeRandom - smokeRandom / 2.0);
                            continue;
                        }
                        this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123804_, (double)pos.m_123341_() + xStart + (Math.random() * horzSpread - horzSpread / 2.0), (double)pos.m_123342_() + yStart - Math.random() * verticalSpread, (double)pos.m_123343_() + zStart + (Math.random() * horzSpread - horzSpread / 2.0), 0.0, 1.0, 0.0);
                    }
                }
                if (this.tickCount % 10 == 0 && this.tickCount > this.soundStartTick) {
                    float soundRandom = 0.7f;
                    this.f_58857_.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12540_, SoundSource.BLOCKS, 1.0f, 1.0f + (float)(Math.random() * (double)soundRandom - (double)(soundRandom / 2.0f)), false);
                }
            } else if (this.tickCount > 0) {
                BlockPos pos = this.m_58899_();
                if (this.f_58857_.m_46472_() == Level.f_46429_) {
                    double smokeRandom = 0.02;
                    if (this.tickCount % 6 == 0) {
                        this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + xStart + (Math.random() * horzSpread - horzSpread / 2.0), (double)pos.m_123342_() + yStart - Math.random() * verticalSpread, (double)pos.m_123343_() + zStart + (Math.random() * horzSpread - horzSpread / 2.0), Math.random() * smokeRandom - smokeRandom / 2.0, Math.random() * smokeRandom - smokeRandom / 2.0, Math.random() * smokeRandom - smokeRandom / 2.0);
                    }
                } else {
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123804_, (double)pos.m_123341_() + xStart + (Math.random() * horzSpread - horzSpread / 2.0), (double)pos.m_123342_() + yStart - Math.random() * verticalSpread, (double)pos.m_123343_() + zStart + (Math.random() * horzSpread - horzSpread / 2.0), 0.0, 1.0, 0.0);
                }
                --this.tickCount;
            }
        }
        if (this.running) {
            ++this.tickCount;
        }
    }
}

