/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.tileentities;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WallShelfBlockEntity
extends BlockEntity
implements Container {
    public static final BlockEntityType<WallShelfBlockEntity> WALL_SHELF = BlockEntityType.Builder.m_155273_(WallShelfBlockEntity::wallShelf, (Block[])new Block[]{(Block)CustomBlocks.BLOCK_ACACIA_WALL_SHELF.get(), (Block)CustomBlocks.BLOCK_BIRCH_WALL_SHELF.get(), (Block)CustomBlocks.BLOCK_CRIMSON_WALL_SHELF.get(), (Block)CustomBlocks.BLOCK_DARK_OAK_WALL_SHELF.get(), (Block)CustomBlocks.BLOCK_JUNGLE_WALL_SHELF.get(), (Block)CustomBlocks.BLOCK_OAK_WALL_SHELF.get(), (Block)CustomBlocks.BLOCK_SPRUCE_WALL_SHELF.get(), (Block)CustomBlocks.BLOCK_WARPED_WALL_SHELF.get()}).m_58966_(null);
    public static final BlockEntityType<WallShelfBlockEntity> DOUBLE_WALL_SHELF = BlockEntityType.Builder.m_155273_(WallShelfBlockEntity::doubleWallShelf, (Block[])new Block[]{(Block)CustomBlocks.BLOCK_DOUBLE_ACACIA_WALL_SHELF.get(), (Block)CustomBlocks.BLOCK_DOUBLE_BIRCH_WALL_SHELF.get(), (Block)CustomBlocks.BLOCK_DOUBLE_CRIMSON_WALL_SHELF.get(), (Block)CustomBlocks.BLOCK_DOUBLE_DARK_OAK_WALL_SHELF.get(), (Block)CustomBlocks.BLOCK_DOUBLE_JUNGLE_WALL_SHELF.get(), (Block)CustomBlocks.BLOCK_DOUBLE_OAK_WALL_SHELF.get(), (Block)CustomBlocks.BLOCK_DOUBLE_SPRUCE_WALL_SHELF.get(), (Block)CustomBlocks.BLOCK_DOUBLE_WARPED_WALL_SHELF.get()}).m_58966_(null);
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int WALL_SHELF_CONTAINER_SIZE = 3;
    public static final int DOUBLE_WALL_SHELF_CONTAINER_SIZE = 6;
    private NonNullList<ItemStack> items = null;

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void initItems() {
        BlockEntityType type;
        if (this.items == null && (type = this.m_58903_()) != null) {
            if (type == DOUBLE_WALL_SHELF) {
                ModernLifeCommon.LOGGER.debug("init with size = 6");
                this.items = NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);
            } else {
                ModernLifeCommon.LOGGER.debug("init with size = 3");
                this.items = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
            }
        }
    }

    public boolean isFull() {
        int count = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).m_41619_()) continue;
            ++count;
        }
        return count == this.items.size();
    }

    public int getNextFreeSlot() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((ItemStack)this.items.get(i)).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public int getNextOccupiedSlot() {
        for (int i = this.items.size() - 1; i >= 0; --i) {
            if (((ItemStack)this.items.get(i)).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public void placeItem(ItemStack itemStack) {
        int freeSlot = this.getNextFreeSlot();
        if (freeSlot != -1) {
            this.m_6836_(freeSlot, itemStack.m_41777_());
        }
    }

    public WallShelfBlockEntity(boolean doubleShelf, BlockPos pos, BlockState state) {
        super(doubleShelf ? DOUBLE_WALL_SHELF : WALL_SHELF, pos, state);
        this.initItems();
    }

    public static WallShelfBlockEntity wallShelf(BlockPos pos, BlockState state) {
        return new WallShelfBlockEntity(false, pos, state);
    }

    public static WallShelfBlockEntity doubleWallShelf(BlockPos pos, BlockState state) {
        return new WallShelfBlockEntity(true, pos, state);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        ContainerHelper.m_18973_((CompoundTag)nbt, this.items);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.initItems();
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        super.handleUpdateTag(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection conn, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            this.initItems();
            this.items.clear();
            ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        }
    }

    public void m_142466_(CompoundTag p_230337_2_) {
        super.m_142466_(p_230337_2_);
        this.initItems();
        ContainerHelper.m_18980_((CompoundTag)p_230337_2_, this.items);
    }

    protected void m_183515_(CompoundTag p_189515_1_) {
        ContainerHelper.m_18973_((CompoundTag)p_189515_1_, this.items);
    }

    public void m_6211_() {
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.set(i, (Object)ItemStack.f_41583_);
        }
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i) == ItemStack.f_41583_) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int var1) {
        return (ItemStack)this.items.get(var1);
    }

    public ItemStack m_7407_(int var1, int var2) {
        return ContainerHelper.m_18969_(this.items, (int)var1, (int)var2);
    }

    public ItemStack m_8016_(int var1) {
        return ContainerHelper.m_18966_(this.items, (int)var1);
    }

    public void m_6836_(int var1, ItemStack var2) {
        this.items.set(var1, (Object)var2);
    }

    public boolean m_6542_(Player p_70300_1_) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return p_70300_1_.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }
}

