/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.tileentities;

import com.dairymoose.entity.DummyEntity;
import com.dairymoose.modernlife.blocks.WinchBlock;
import com.dairymoose.modernlife.blocks.gui.HBlockPos;
import com.dairymoose.modernlife.core.BlockVolume;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeCommon;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WinchBlockEntity
extends BlockEntity
implements Container {
    public static final BlockEntityType<WinchBlockEntity> WINCH = BlockEntityType.Builder.m_155273_(WinchBlockEntity::new, (Block[])new Block[]{(Block)CustomBlocks.BLOCK_WINCH.get()}).m_58966_(null);
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int WINCH_CONTAINER_SIZE = 9;
    private NonNullList<ItemStack> winchStack = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    public static HashMap<HBlockPos, DummyEntity> entityForWinchPos = new HashMap();
    final int LOOK_FOR_AIR_MAX_TRAVERSAL = 30;
    boolean unpowered = true;
    public static boolean useSmoothAnimation = false;

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        ContainerHelper.m_18973_((CompoundTag)nbt, this.winchStack);
        return nbt;
    }

    public int m_6893_() {
        return 64;
    }

    public boolean m_7013_(int flag, ItemStack itemStack) {
        return this.m_7983_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        ContainerHelper.m_18980_((CompoundTag)tag, this.winchStack);
        ItemStack item = this.m_8020_(0);
        super.handleUpdateTag(tag);
    }

    public void m_142466_(CompoundTag p_230337_2_) {
        super.m_142466_(p_230337_2_);
        ContainerHelper.m_18980_((CompoundTag)p_230337_2_, this.winchStack);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection conn, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            this.winchStack.clear();
            ContainerHelper.m_18980_((CompoundTag)tag, this.winchStack);
        }
    }

    protected void m_183515_(CompoundTag p_189515_1_) {
        ContainerHelper.m_18973_((CompoundTag)p_189515_1_, this.winchStack);
    }

    public boolean isFull() {
        int count = 0;
        for (int i = 0; i < this.winchStack.size(); ++i) {
            if (((ItemStack)this.winchStack.get(i)).m_41619_()) continue;
            ++count;
        }
        return count == this.winchStack.size();
    }

    public int getNextFreeSlot() {
        for (int i = 0; i < this.winchStack.size(); ++i) {
            if (!((ItemStack)this.winchStack.get(i)).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public int getOpenChainSlot() {
        for (int i = 0; i < this.winchStack.size(); ++i) {
            ItemStack itemStack = (ItemStack)this.winchStack.get(i);
            if (!itemStack.m_150930_(Items.f_42026_) || itemStack.m_41613_() >= itemStack.m_41741_()) continue;
            return i;
        }
        return this.getNextFreeSlot();
    }

    public static BlockPos moveAwayFromWinch(BlockState state, BlockPos pos) {
        AttachFace face = (AttachFace)state.m_61143_((Property)WinchBlock.f_53179_);
        if (face == AttachFace.FLOOR) {
            return pos.m_7494_();
        }
        if (face == AttachFace.CEILING) {
            return pos.m_7495_();
        }
        return pos.m_121945_((Direction)state.m_61143_((Property)WinchBlock.f_54117_));
    }

    public static BlockPos moveTowardsWinch(BlockState state, BlockPos pos) {
        AttachFace face = (AttachFace)state.m_61143_((Property)WinchBlock.f_53179_);
        if (face == AttachFace.FLOOR) {
            return pos.m_7495_();
        }
        if (face == AttachFace.CEILING) {
            return pos.m_7494_();
        }
        return pos.m_121945_(((Direction)state.m_61143_((Property)WinchBlock.f_54117_)).m_122424_());
    }

    public boolean isValidCeilingChain(BlockState posState) {
        if (!posState.m_60713_(Blocks.f_50184_)) {
            return false;
        }
        AttachFace face = (AttachFace)this.m_58900_().m_61143_((Property)WinchBlock.f_53179_);
        boolean validCeilingChain = (face == AttachFace.CEILING || face == AttachFace.FLOOR) && posState.m_61143_((Property)ChainBlock.f_55923_) == Direction.Axis.Y;
        return validCeilingChain;
    }

    public boolean isValidXChain(BlockState posState) {
        if (!posState.m_60713_(Blocks.f_50184_)) {
            return false;
        }
        AttachFace face = (AttachFace)this.m_58900_().m_61143_((Property)WinchBlock.f_53179_);
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)WinchBlock.f_54117_);
        boolean validWallChainX = face == AttachFace.WALL && (facing == Direction.EAST || facing == Direction.WEST) && posState.m_61143_((Property)ChainBlock.f_55923_) == Direction.Axis.X;
        return validWallChainX;
    }

    public boolean isValidZChain(BlockState posState) {
        if (!posState.m_60713_(Blocks.f_50184_)) {
            return false;
        }
        AttachFace face = (AttachFace)this.m_58900_().m_61143_((Property)WinchBlock.f_53179_);
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)WinchBlock.f_54117_);
        boolean validWallChainZ = face == AttachFace.WALL && (facing == Direction.NORTH || facing == Direction.SOUTH) && posState.m_61143_((Property)ChainBlock.f_55923_) == Direction.Axis.Z;
        return validWallChainZ;
    }

    public int getTotalChainCount() {
        int sum = 0;
        BlockPos pos = this.m_58899_();
        AttachFace face = (AttachFace)this.m_58900_().m_61143_((Property)WinchBlock.f_53179_);
        pos = WinchBlockEntity.moveAwayFromWinch(this.m_58900_(), pos);
        BlockState posState = this.f_58857_.m_8055_(pos);
        while (posState.m_60713_(Blocks.f_50184_)) {
            if (!(this.isValidCeilingChain(posState) || this.isValidXChain(posState) || this.isValidZChain(posState))) {
                return 0;
            }
            ++sum;
            pos = WinchBlockEntity.moveAwayFromWinch(this.m_58900_(), pos);
            posState = this.f_58857_.m_8055_(pos);
        }
        return sum;
    }

    public int getInventoryChainCount() {
        int sum = 0;
        for (int i = 0; i < this.winchStack.size(); ++i) {
            ItemStack itemStack = (ItemStack)this.winchStack.get(i);
            if (!itemStack.m_150930_(Items.f_42026_)) continue;
            sum += itemStack.m_41613_();
        }
        return sum;
    }

    public int getTotalChainCountIncludingInventory() {
        int sum = this.getTotalChainCount();
        return sum += this.getInventoryChainCount();
    }

    public int getNextChainSlot() {
        for (int i = 0; i < this.winchStack.size(); ++i) {
            ItemStack itemStack = (ItemStack)this.winchStack.get(i);
            if (!itemStack.m_150930_(Items.f_42026_)) continue;
            return i;
        }
        return -1;
    }

    public int getNextOccupiedSlot() {
        for (int i = 0; i < this.winchStack.size(); ++i) {
            if (((ItemStack)this.winchStack.get(i)).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public BlockPos getExpandedChainBlockPos() {
        int chainCount = this.getTotalChainCount();
        if (chainCount == 0) {
            return WinchBlockEntity.moveAwayFromWinch(this.m_58900_(), this.m_58899_());
        }
        BlockPos pos = this.m_58899_();
        pos = WinchBlockEntity.moveAwayFromWinch(this.m_58900_(), pos);
        for (int i = 0; i < chainCount; ++i) {
            pos = WinchBlockEntity.moveAwayFromWinch(this.m_58900_(), pos);
        }
        return pos;
    }

    public boolean canExpandChain() {
        int chainCount = this.getTotalChainCount();
        if (chainCount == 0) {
            return true;
        }
        BlockPos pos = this.getExpandedChainBlockPos();
        return this.f_58857_.m_8055_(pos).m_60795_();
    }

    public void m_6211_() {
        for (int i = 0; i < this.winchStack.size(); ++i) {
            this.winchStack.set(i, (Object)ItemStack.f_41583_);
        }
    }

    public int m_6643_() {
        return 9;
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.winchStack.size(); ++i) {
            if (((ItemStack)this.winchStack.get(i)).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int var1) {
        return (ItemStack)this.winchStack.get(var1);
    }

    public ItemStack m_7407_(int var1, int var2) {
        return ContainerHelper.m_18969_(this.winchStack, (int)var1, (int)var2);
    }

    public ItemStack m_8016_(int var1) {
        return ContainerHelper.m_18966_(this.winchStack, (int)var1);
    }

    public void m_6836_(int var1, ItemStack var2) {
        this.winchStack.set(var1, (Object)var2);
    }

    public boolean m_6542_(Player p_70300_1_) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return p_70300_1_.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public WinchBlockEntity(BlockPos pos, BlockState state) {
        super(WINCH, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, WinchBlockEntity entity) {
        entity.tick();
    }

    public void playMovementSound() {
        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11746_, SoundSource.BLOCKS, 0.15f, 0.5f);
    }

    public void tick() {
        if (!this.f_58857_.f_46443_ && ModernLifeCommon.winchTickCounter % 8 == 0) {
            if (((Boolean)this.m_58900_().m_61143_((Property)WinchBlock.POWERED)).booleanValue()) {
                int chainCount;
                int powerLevel = this.f_58857_.m_277086_(this.m_58899_());
                if (powerLevel > 3 && (chainCount = this.getTotalChainCountIncludingInventory()) > 0) {
                    BlockPos expanded = this.getExpandedChainBlockPos();
                    ItemStack newChain = new ItemStack(new ItemLike(){

                        public Item m_5456_() {
                            return Items.f_42026_;
                        }
                    });
                    boolean playedSound = false;
                    BlockPos lastChainLink = WinchBlockEntity.moveTowardsWinch(this.m_58900_(), expanded);
                    BlockState expandedState = this.f_58857_.m_8055_(expanded);
                    if (!expandedState.m_60713_((Block)CustomBlocks.BLOCK_WINCH_ANCHOR.get()) && !this.f_58857_.f_46443_) {
                        for (int i = 0; i < chainCount && !(expandedState = this.f_58857_.m_8055_(expanded)).m_155947_() && !expandedState.m_60795_() && expandedState.m_60819_().m_76178_() && !this.f_58857_.m_8055_(lastChainLink).m_60713_((Block)CustomBlocks.BLOCK_WINCH.get()); ++i) {
                            if (!playedSound) {
                                playedSound = true;
                                this.playMovementSound();
                                int chainSlot = this.getOpenChainSlot();
                                if (chainSlot == -1) break;
                                ItemStack chainItem = this.m_8020_(chainSlot);
                                if (chainItem.m_150930_(Items.f_42026_)) {
                                    chainItem.m_41769_(1);
                                } else {
                                    this.m_6836_(chainSlot, newChain);
                                }
                            }
                            this.f_58857_.m_7731_(lastChainLink, expandedState, 2);
                            this.f_58857_.m_7731_(expanded, Blocks.f_50016_.m_49966_(), 2);
                            this.f_58857_.m_46672_(lastChainLink, this.f_58857_.m_8055_(lastChainLink).m_60734_());
                            this.f_58857_.m_46672_(expanded, Blocks.f_50016_);
                            expanded = WinchBlockEntity.moveAwayFromWinch(this.m_58900_(), expanded);
                            lastChainLink = WinchBlockEntity.moveAwayFromWinch(this.m_58900_(), lastChainLink);
                        }
                    } else {
                        if (this.f_58857_.f_46443_ || this.unpowered) {
                            // empty if block
                        }
                        BlockVolume bv = new BlockVolume(this.f_58857_, expanded, (Block)CustomBlocks.BLOCK_WINCH_ANCHOR.get());
                        if (useSmoothAnimation) {
                            if (bv.shiftBlocksWithDummyEntity(this.f_58857_, WinchBlockEntity::moveTowardsWinch, this.m_58900_(), true, this)) {
                                this.playMovementSound();
                            }
                        } else if (bv.shiftBlocks(this.f_58857_, WinchBlockEntity::moveTowardsWinch, this.m_58900_(), true, this)) {
                            this.playMovementSound();
                        }
                    }
                }
            } else if (this.m_58900_().m_61143_((Property)WinchBlock.f_53179_) == AttachFace.CEILING) {
                if (!this.unpowered) {
                    BlockVolume.shouldFloat = false;
                }
                this.unpowered = true;
                int inventoryChainCount = this.getInventoryChainCount();
                if (inventoryChainCount > 0) {
                    BlockPos expanded = this.getExpandedChainBlockPos();
                    ItemStack newChain = new ItemStack(new ItemLike(){

                        public Item m_5456_() {
                            return Items.f_42026_;
                        }
                    });
                    boolean playedSound = false;
                    BlockState expandedState = this.f_58857_.m_8055_(expanded);
                    if (!expandedState.m_60713_((Block)CustomBlocks.BLOCK_WINCH_ANCHOR.get()) && !this.f_58857_.f_46443_) {
                        int chainSlot;
                        BlockPos airCheckPos = expanded;
                        int airCheckCounter = 0;
                        while (!this.f_58857_.m_8055_(airCheckPos).m_60795_()) {
                            airCheckPos = WinchBlockEntity.moveAwayFromWinch(this.m_58900_(), airCheckPos);
                            if (++airCheckCounter <= 30) continue;
                        }
                        int blocksMovedCount = 0;
                        if (this.f_58857_.m_8055_(airCheckPos).m_60795_()) {
                            BlockState sourceState;
                            BlockPos source = WinchBlockEntity.moveTowardsWinch(this.m_58900_(), airCheckPos);
                            BlockPos destination = airCheckPos;
                            for (int i = 0; i < airCheckCounter && !(sourceState = this.f_58857_.m_8055_(source)).m_155947_() && !sourceState.m_60795_() && sourceState.m_60819_().m_76178_() && !this.f_58857_.m_8055_(destination).m_60713_((Block)CustomBlocks.BLOCK_WINCH.get()); ++i) {
                                if (!playedSound) {
                                    playedSound = true;
                                    this.playMovementSound();
                                }
                                ++blocksMovedCount;
                                this.f_58857_.m_7731_(destination, sourceState, 2);
                                this.f_58857_.m_7731_(source, Blocks.f_50016_.m_49966_(), 2);
                                this.f_58857_.m_46672_(destination, this.f_58857_.m_8055_(destination).m_60734_());
                                this.f_58857_.m_46672_(source, Blocks.f_50016_);
                                source = WinchBlockEntity.moveTowardsWinch(this.m_58900_(), source);
                                destination = WinchBlockEntity.moveTowardsWinch(this.m_58900_(), destination);
                            }
                        }
                        if (this.f_58857_.m_8055_(expanded = this.getExpandedChainBlockPos()).m_60795_() && blocksMovedCount >= airCheckCounter && (chainSlot = this.getNextChainSlot()) != -1) {
                            ItemStack itemStack = this.m_8020_(chainSlot);
                            itemStack.m_41774_(1);
                            this.f_58857_.m_7731_(expanded, Blocks.f_50184_.m_49966_(), 2);
                        }
                    } else {
                        BlockVolume bv = new BlockVolume(this.f_58857_, expanded, (Block)CustomBlocks.BLOCK_WINCH_ANCHOR.get());
                        boolean shiftResult = bv.shiftBlocks(this.f_58857_, WinchBlockEntity::moveAwayFromWinch, this.m_58900_(), false, this);
                        expanded = this.getExpandedChainBlockPos();
                        if (shiftResult) {
                            this.f_58857_.m_7731_(expanded, Blocks.f_50184_.m_49966_(), 2);
                            this.playMovementSound();
                        }
                    }
                }
            }
        }
    }
}

