/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.core.ModBlocks;
import com.mrcrayfish.furniture.entity.SeatEntity;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SofaBlock
extends FurnitureHorizontalBlock {
    public static final EnumProperty<Type> TYPE = EnumProperty.m_61587_((String)"type", Type.class);
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public SofaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)((Object)Type.SINGLE)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape BASE = Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
        VoxelShape[] LEG_BACK_LEFT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)3.0), Direction.SOUTH));
        VoxelShape[] LEG_FRONT_LEFT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)16.0), Direction.SOUTH));
        VoxelShape[] LEG_FRONT_RIGHT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0), Direction.SOUTH));
        VoxelShape[] LEG_BACK_RIGHT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0), Direction.SOUTH));
        VoxelShape[] BACK_REST = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)20.0, (double)4.0), Direction.SOUTH));
        VoxelShape[] BACK_REST_LEFT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)0.0, (double)10.0, (double)4.0, (double)4.0, (double)20.0, (double)16.0), Direction.SOUTH));
        VoxelShape[] BACK_REST_RIGHT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)12.0, (double)10.0, (double)4.0, (double)16.0, (double)20.0, (double)16.0), Direction.SOUTH));
        VoxelShape[] LEFT_ARM_REST = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)-2.0, (double)9.0, (double)1.0, (double)2.0, (double)14.0, (double)16.0), Direction.SOUTH));
        VoxelShape[] RIGHT_ARM_REST = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)14.0, (double)9.0, (double)1.0, (double)18.0, (double)14.0, (double)16.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            Type type = (Type)((Object)state.m_61143_(TYPE));
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(BASE);
            shapes.add(BACK_REST[direction.m_122416_()]);
            switch (type) {
                case SINGLE: {
                    shapes.add(LEG_BACK_LEFT[direction.m_122416_()]);
                    shapes.add(LEG_FRONT_LEFT[direction.m_122416_()]);
                    shapes.add(LEG_FRONT_RIGHT[direction.m_122416_()]);
                    shapes.add(LEG_BACK_RIGHT[direction.m_122416_()]);
                    shapes.add(LEFT_ARM_REST[direction.m_122416_()]);
                    shapes.add(RIGHT_ARM_REST[direction.m_122416_()]);
                    break;
                }
                case LEFT: {
                    shapes.add(LEG_BACK_LEFT[direction.m_122416_()]);
                    shapes.add(LEG_FRONT_LEFT[direction.m_122416_()]);
                    shapes.add(LEFT_ARM_REST[direction.m_122416_()]);
                    break;
                }
                case RIGHT: {
                    shapes.add(LEG_FRONT_RIGHT[direction.m_122416_()]);
                    shapes.add(LEG_BACK_RIGHT[direction.m_122416_()]);
                    shapes.add(RIGHT_ARM_REST[direction.m_122416_()]);
                    break;
                }
                case CORNER_LEFT: {
                    shapes.add(LEG_BACK_LEFT[direction.m_122416_()]);
                    shapes.add(BACK_REST_LEFT[direction.m_122416_()]);
                    break;
                }
                case CORNER_RIGHT: {
                    shapes.add(LEG_BACK_RIGHT[direction.m_122416_()]);
                    shapes.add(BACK_REST_RIGHT[direction.m_122416_()]);
                }
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        return this.getSofaState(state, (LevelAccessor)context.m_43725_(), context.m_8083_(), (Direction)state.m_61143_((Property)DIRECTION));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player playerEntity, InteractionHand hand, BlockHitResult result) {
        if (!level.m_5776_()) {
            ItemStack stack = playerEntity.m_21120_(hand);
            if (stack.m_41720_() == Items.f_42656_ && this != ModBlocks.SOFA_RAINBOW.get() && stack.m_41786_().getString().equals("jeb_")) {
                BlockState rainbowSofaState = (BlockState)((BlockState)((Block)ModBlocks.SOFA_RAINBOW.get()).m_49966_().m_61124_((Property)DIRECTION, (Comparable)((Direction)state.m_61143_((Property)DIRECTION)))).m_61124_(TYPE, (Comparable)((Object)((Type)((Object)state.m_61143_(TYPE)))));
                level.m_7731_(pos, rainbowSofaState, 3);
                return InteractionResult.SUCCESS;
            }
            return SeatEntity.create(level, pos, 0.4, playerEntity, (Direction)state.m_61143_((Property)DIRECTION));
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return this.getSofaState(state, level, pos, (Direction)state.m_61143_((Property)DIRECTION));
    }

    private BlockState getSofaState(BlockState state, LevelAccessor level, BlockPos pos, Direction dir) {
        boolean left = this.isSofa(level, pos, dir.m_122428_(), dir) || this.isSofa(level, pos, dir.m_122428_(), dir.m_122428_());
        boolean right = this.isSofa(level, pos, dir.m_122427_(), dir) || this.isSofa(level, pos, dir.m_122427_(), dir.m_122427_());
        boolean cornerLeft = this.isSofa(level, pos, dir.m_122424_(), dir.m_122428_());
        boolean cornerRight = this.isSofa(level, pos, dir.m_122424_(), dir.m_122427_());
        if (cornerLeft) {
            return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.CORNER_LEFT));
        }
        if (cornerRight) {
            return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.CORNER_RIGHT));
        }
        if (left && right) {
            return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.MIDDLE));
        }
        if (left) {
            return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.RIGHT));
        }
        if (right) {
            return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.LEFT));
        }
        return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.SINGLE));
    }

    private boolean isSofa(LevelAccessor level, BlockPos source, Direction direction, Direction targetDirection) {
        BlockState state = level.m_8055_(source.m_121945_(direction));
        if (state.m_60734_() == this) {
            Direction sofaDirection = (Direction)state.m_61143_((Property)DIRECTION);
            return sofaDirection.equals((Object)targetDirection);
        }
        return false;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TYPE});
    }

    public static enum Type implements StringRepresentable
    {
        SINGLE("single"),
        LEFT("left"),
        RIGHT("right"),
        MIDDLE("middle"),
        CORNER_LEFT("corner_left"),
        CORNER_RIGHT("corner_right");

        private final String id;

        private Type(String id) {
            this.id = id;
        }

        public String m_7912_() {
            return this.id;
        }

        public String toString() {
            return this.id;
        }
    }
}

