/*
 * Decompiled with CFR 0.152.
 */
package com.anar4732.opf;

import com.anar4732.opf.OPFBlock;
import com.anar4732.opf.OPFEntity;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class OPFCommand {
    public static void register(CommandDispatcher<CommandSourceStack> cd) {
        cd.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"assets/opf").requires(cs -> cs.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82127_((String)"setSize").then(Commands.m_82129_((String)"xSize", (ArgumentType)IntegerArgumentType.integer((int)1, (int)32)).then(Commands.m_82129_((String)"ySize", (ArgumentType)IntegerArgumentType.integer((int)1, (int)32)).executes(OPFCommand::setSize))))).then(Commands.m_82127_((String)"setImage").then(Commands.m_82129_((String)"url", (ArgumentType)StringArgumentType.string()).executes(OPFCommand::setURL)))));
    }

    private static int setURL(CommandContext<CommandSourceStack> css) throws CommandSyntaxException {
        ServerLevel world = ((CommandSourceStack)css.getSource()).m_81372_();
        BlockPos pos = BlockPosArgument.m_118242_(css, (String)"pos");
        String url = StringArgumentType.getString(css, (String)"url");
        OPFEntity te = OPFCommand.findTE(world, pos);
        if (te == null) {
            ((CommandSourceStack)css.getSource()).m_81352_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("No OPF found at " + pos.m_123344_())));
            return 0;
        }
        te.url = url;
        te.m_6596_();
        te.sendToClients();
        return 1;
    }

    private static int setSize(CommandContext<CommandSourceStack> css) throws CommandSyntaxException {
        ServerLevel world = ((CommandSourceStack)css.getSource()).m_81372_();
        BlockPos pos = BlockPosArgument.m_118242_(css, (String)"pos");
        int sizeX = IntegerArgumentType.getInteger(css, (String)"xSize");
        int sizeY = IntegerArgumentType.getInteger(css, (String)"ySize");
        OPFEntity te = OPFCommand.findTE(world, pos);
        if (te == null) {
            ((CommandSourceStack)css.getSource()).m_81352_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("No OPF found at " + pos.m_123344_())));
            return 0;
        }
        int oldSizeY = te.sizeY;
        int oldSizeX = te.sizeX;
        te.sizeX = sizeX;
        te.sizeY = sizeY;
        te.updateBlocks(oldSizeX, oldSizeY);
        te.m_6596_();
        te.sendToClients();
        world.m_7260_(te.m_58899_(), te.m_58900_(), te.m_58900_(), 2);
        return 1;
    }

    private static OPFEntity findTE(ServerLevel world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof OPFBlock) {
            OPFBlock opfBlock = (OPFBlock)block;
            return opfBlock.findMainTE((Level)world, pos);
        }
        return null;
    }
}

