/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.generated.data;

import javax.annotation.Nonnull;
import org.mtr.core.data.Route;
import org.mtr.core.data.SimplifiedRoutePlatform;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.core.serializer.WriterBase;
import org.mtr.core.tool.EnumHelper;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public abstract class SimplifiedRouteSchema
implements SerializedDataBase {
    protected final long id;
    protected final String name;
    protected final long color;
    protected final Route.CircularState circularState;
    protected final ObjectArrayList<SimplifiedRoutePlatform> platforms = new ObjectArrayList();

    protected SimplifiedRouteSchema(long id, String name, long color, Route.CircularState circularState) {
        this.id = id;
        this.name = name;
        this.color = color;
        this.circularState = circularState;
    }

    protected SimplifiedRouteSchema(ReaderBase readerBase) {
        this.id = readerBase.getLong("id", 0L);
        this.name = readerBase.getString("name", "");
        this.color = readerBase.getLong("color", 0L);
        this.circularState = EnumHelper.valueOf(Route.CircularState.values()[0], readerBase.getString("circularState", ""));
    }

    @Override
    public void updateData(ReaderBase readerBase) {
        readerBase.iterateReaderArray("platforms", this.platforms::clear, readerBaseChild -> this.platforms.add(new SimplifiedRoutePlatform((ReaderBase)readerBaseChild)));
    }

    @Override
    public void serializeData(WriterBase writerBase) {
        writerBase.writeLong("id", this.id);
        writerBase.writeString("name", this.name);
        writerBase.writeLong("color", this.color);
        writerBase.writeString("circularState", this.circularState.toString());
        this.serializePlatforms(writerBase);
    }

    @Nonnull
    public String toString() {
        return "id: " + this.id + "\nname: " + this.name + "\ncolor: " + this.color + "\ncircularState: " + (Object)((Object)this.circularState) + "\nplatforms: " + this.platforms + "\n";
    }

    protected void serializePlatforms(WriterBase writerBase) {
        writerBase.writeDataset(this.platforms, "platforms");
    }
}

