/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.generated.oba;

import javax.annotation.Nonnull;
import org.mtr.core.oba.Frequency;
import org.mtr.core.oba.Schedule;
import org.mtr.core.oba.TripStatus;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.core.serializer.WriterBase;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public abstract class TripDetailsSchema
implements SerializedDataBase {
    protected final String tripId;
    protected final long serviceDate;
    protected Frequency frequency = this.getDefaultFrequency();
    protected final TripStatus status;
    protected final Schedule schedule;
    protected final ObjectArrayList<String> situationIds = new ObjectArrayList();

    protected TripDetailsSchema(String tripId, long serviceDate, TripStatus status, Schedule schedule2) {
        this.tripId = tripId;
        this.serviceDate = serviceDate;
        this.status = status;
        this.schedule = schedule2;
    }

    protected TripDetailsSchema(ReaderBase readerBase) {
        this.tripId = readerBase.getString("tripId", "");
        this.serviceDate = readerBase.getLong("serviceDate", 0L);
        this.status = new TripStatus(readerBase.getChild("status"));
        this.schedule = new Schedule(readerBase.getChild("schedule"));
    }

    @Override
    public void updateData(ReaderBase readerBase) {
        readerBase.unpackChild("frequency", readerBaseChild -> {
            this.frequency = new Frequency((ReaderBase)readerBaseChild);
        });
        readerBase.iterateStringArray("situationIds", this.situationIds::clear, this.situationIds::add);
    }

    @Override
    public void serializeData(WriterBase writerBase) {
        writerBase.writeString("tripId", this.tripId);
        writerBase.writeLong("serviceDate", this.serviceDate);
        this.serializeFrequency(writerBase);
        if (this.status != null) {
            this.status.serializeData(writerBase.writeChild("status"));
        }
        if (this.schedule != null) {
            this.schedule.serializeData(writerBase.writeChild("schedule"));
        }
        this.serializeSituationIds(writerBase);
    }

    @Nonnull
    public String toString() {
        return "tripId: " + this.tripId + "\nserviceDate: " + this.serviceDate + "\nfrequency: " + this.frequency + "\nstatus: " + this.status + "\nschedule: " + this.schedule + "\nsituationIds: " + this.situationIds + "\n";
    }

    protected abstract Frequency getDefaultFrequency();

    protected void serializeFrequency(WriterBase writerBase) {
        if (this.frequency != null) {
            this.frequency.serializeData(writerBase.writeChild("frequency"));
        }
    }

    protected void serializeSituationIds(WriterBase writerBase) {
        WriterBase.Array situationIdsWriterBaseArray = writerBase.writeArray("situationIds");
        this.situationIds.forEach(situationIdsWriterBaseArray::writeString);
    }
}

