/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.tool;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.tool.DummyClass;

public final class PacketBufferSender
extends DummyClass {
    private int capacity;
    private ByteBuf currentByteBuf;
    private final List<ByteBuf> byteBufObjects = new ArrayList<ByteBuf>();
    private final Supplier<ByteBuf> createInstance;
    private static final int HEADER_BYTES = 16;
    private static final int MAX_PACKET_BYTES = 32751;

    @MappedMethod
    public PacketBufferSender(Supplier<ByteBuf> createInstance) {
        this.createInstance = createInstance;
        this.create();
    }

    @MappedMethod
    public void writeBoolean(boolean data) {
        this.write(1);
        this.currentByteBuf.writeBoolean(data);
    }

    @MappedMethod
    public void writeChar(char data) {
        this.write(2);
        this.currentByteBuf.writeChar((int)data);
    }

    @MappedMethod
    public void writeInt(int data) {
        this.write(4);
        this.currentByteBuf.writeInt(data);
    }

    @MappedMethod
    public void writeFloat(float data) {
        this.write(4);
        this.currentByteBuf.writeFloat(data);
    }

    @MappedMethod
    public void writeLong(long data) {
        this.write(8);
        this.currentByteBuf.writeLong(data);
    }

    @MappedMethod
    public void writeDouble(double data) {
        this.write(8);
        this.currentByteBuf.writeDouble(data);
    }

    @MappedMethod
    public void writeString(String data) {
        char[] characters = data.toCharArray();
        this.writeInt(characters.length);
        for (char character : characters) {
            this.writeChar(character);
        }
    }

    @MappedMethod
    public void send(Consumer<ByteBuf> consumer, Consumer<Runnable> scheduler) {
        this.byteBufObjects.add(this.currentByteBuf);
        long id = new Random().nextLong();
        ArrayList<Runnable> queue = new ArrayList<Runnable>();
        for (int i = 0; i < this.byteBufObjects.size(); ++i) {
            ByteBuf byteBuf = this.byteBufObjects.get(i);
            int writerIndex = byteBuf.writerIndex();
            byteBuf.resetWriterIndex();
            byteBuf.writeLong(id);
            byteBuf.writeInt(i);
            byteBuf.writeInt(this.byteBufObjects.size());
            byteBuf.writerIndex(writerIndex);
            queue.add(() -> consumer.accept(byteBuf));
        }
        PacketBufferSender.schedule(queue, scheduler);
    }

    private void write(int size) {
        if (this.capacity + size >= 32751) {
            this.byteBufObjects.add(this.currentByteBuf);
            this.create();
            this.capacity = 0;
        }
        this.capacity += size;
    }

    private void create() {
        this.currentByteBuf = this.createInstance.get();
        this.currentByteBuf.writeLong(0L);
        this.currentByteBuf.writeInt(0);
        this.currentByteBuf.writeInt(0);
    }

    private static void schedule(List<Runnable> queue, Consumer<Runnable> scheduler) {
        if (!queue.isEmpty()) {
            scheduler.accept(() -> {
                ((Runnable)queue.remove(0)).run();
                PacketBufferSender.schedule(queue, scheduler);
            });
        }
    }
}

