/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.BlockPIDSBase;
import org.mtr.mod.block.IBlock;

public abstract class BlockArrivalProjectorBase
extends BlockPIDSBase {
    private static final BiPredicate<World, BlockPos> CAN_STORE_DATA = (world, blockPos) -> true;
    private static final BiFunction<World, BlockPos, BlockPos> GET_BLOCK_POS_WITH_DATA = (world, blockPos) -> blockPos;

    public BlockArrivalProjectorBase(int maxArrivals) {
        super(maxArrivals, CAN_STORE_DATA, GET_BLOCK_POS_WITH_DATA);
    }

    @Override
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        Direction side = ctx.getSide();
        if (side != Direction.UP && side != Direction.DOWN) {
            return this.getDefaultState2().with(new Property((net.minecraft.world.level.block.state.properties.Property)BlockArrivalProjectorBase.FACING.data), side.getOpposite().data);
        }
        return null;
    }

    @Override
    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        Direction facing = IBlock.getStatePropertySafe(state, FACING);
        return IBlock.getVoxelShapeByDirection(0.0, 0.0, 0.0, 16.0, 16.0, 1.0, facing);
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add(FACING);
    }

    public static abstract class BlockEntityArrivalProjectorBase
    extends BlockPIDSBase.BlockEntityBase {
        public BlockEntityArrivalProjectorBase(int maxArrivals, BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(maxArrivals, CAN_STORE_DATA, GET_BLOCK_POS_WITH_DATA, type, pos, state);
        }

        @Override
        public boolean showArrivalNumber() {
            return false;
        }

        @Override
        public boolean alternateLines() {
            return false;
        }

        @Override
        public int textColorArrived() {
            return 0xFF9900;
        }

        @Override
        public int textColor() {
            return 0xFF9900;
        }
    }
}

