/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.BlockStationNameBase;
import org.mtr.mod.block.IBlock;

public abstract class BlockStationNameWallBase
extends BlockStationNameBase
implements BlockWithEntity {
    public BlockStationNameWallBase(BlockSettings blockSettings) {
        super(blockSettings);
    }

    @Override
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        Direction side = ctx.getSide();
        if (side != Direction.UP && side != Direction.DOWN) {
            return this.getDefaultState2().with(new Property((net.minecraft.world.level.block.state.properties.Property)BlockStationNameWallBase.FACING.data), side.getOpposite().data);
        }
        return null;
    }

    @Override
    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        return IBlock.getVoxelShapeByDirection(0.0, 0.0, 0.0, 16.0, 16.0, 1.0, IBlock.getStatePropertySafe(state, FACING));
    }

    @Override
    @Nonnull
    public VoxelShape getCollisionShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        return VoxelShapes.empty();
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add(FACING);
    }

    public static abstract class BlockEntityWallBase
    extends BlockStationNameBase.BlockEntityBase {
        public BlockEntityWallBase(BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state, 0.0f, 0.0f, false);
        }
    }
}

