/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.level.LevelAccessor;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Blocks;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mod.block.IBlock;

public interface TripleHorizontalBlock
extends IBlock,
DirectionHelper {
    public static final BooleanProperty CENTER = BooleanProperty.of("odd");

    @Nonnull
    public static BlockState getStateForNeighborUpdate(BlockState blockState, Direction direction, boolean isThis, BlockState defaultBlockState) {
        Direction sideDirection = IBlock.getSideDirection(blockState);
        if ((sideDirection == direction || sideDirection == direction.getOpposite() && IBlock.getStatePropertySafe(blockState, CENTER)) && !isThis) {
            return Blocks.getAirMapped().getDefaultState();
        }
        return defaultBlockState;
    }

    public static void onPlaced(World world, BlockPos blockPos, BlockState blockState, BlockState defaultPlacementState) {
        if (!world.isClient()) {
            Direction direction = IBlock.getStatePropertySafe(blockState, FACING);
            Direction rotatedDirection = direction.rotateYClockwise();
            BlockState newBlockState = defaultPlacementState.with(new Property((net.minecraft.world.level.block.state.properties.Property)TripleHorizontalBlock.FACING.data), direction.data).with(new Property((net.minecraft.world.level.block.state.properties.Property)TripleHorizontalBlock.SIDE.data), IBlock.EnumSide.RIGHT);
            world.setBlockState(blockPos.offset(rotatedDirection), newBlockState.with(new Property((net.minecraft.world.level.block.state.properties.Property)TripleHorizontalBlock.CENTER.data), true), 3);
            world.updateNeighbors(blockPos, Blocks.getAirMapped());
            blockState.updateNeighbors(new WorldAccess((LevelAccessor)world.data), blockPos, 3);
            world.setBlockState(blockPos.offset(rotatedDirection, 2), newBlockState.with(new Property((net.minecraft.world.level.block.state.properties.Property)TripleHorizontalBlock.CENTER.data), false), 3);
            world.updateNeighbors(blockPos.offset(rotatedDirection), Blocks.getAirMapped());
            blockState.updateNeighbors(new WorldAccess((LevelAccessor)world.data), blockPos.offset(rotatedDirection), 3);
        }
    }

    @Nullable
    public static BlockState getPlacementState(ItemPlacementContext itemPlacementContext, BlockState defaultPlacementState) {
        Direction direction = itemPlacementContext.getPlayerFacing();
        return IBlock.isReplaceable(itemPlacementContext, direction.rotateYClockwise(), 3) ? defaultPlacementState.with(new Property((net.minecraft.world.level.block.state.properties.Property)TripleHorizontalBlock.FACING.data), direction.data).with(new Property((net.minecraft.world.level.block.state.properties.Property)TripleHorizontalBlock.SIDE.data), IBlock.EnumSide.LEFT).with(new Property((net.minecraft.world.level.block.state.properties.Property)TripleHorizontalBlock.CENTER.data), false) : null;
    }

    public static void onBreak(World world, BlockPos blockPos, BlockState blockState, PlayerEntity playerEntity) {
        BlockPos breakBlockPos = IBlock.getStatePropertySafe(blockState, SIDE) == IBlock.EnumSide.RIGHT ? blockPos.offset(IBlock.getSideDirection(blockState), IBlock.getStatePropertySafe(blockState, CENTER) ? 1 : 2) : blockPos;
        IBlock.onBreakCreative(world, playerEntity, breakBlockPos);
    }
}

